/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.externalvisio;

import java.util.List;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webconferencing.ActiveCallProvider;
import org.exoplatform.webconferencing.CallProvider;
import org.exoplatform.webconferencing.CallProviderException;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.externalvisio.rest.model.ExternalVisioConnector;
import org.exoplatform.webconferencing.externalvisio.service.ExternalVisioConnectorService;

public class ExternalVisioProvider
extends CallProvider {
    public static final String EXTERNAL_VISIO_TYPE = "externalVisio";
    public static final String EXTERNAL_VISIO_TITLE = "ExternalVisio";
    private ExternalVisioConnectorService externalVisioConnectorService;
    private SpaceService spaceService;
    private IdentityManager identityManager;

    public ExternalVisioProvider(InitParams params, ExternalVisioConnectorService externalVisioConnectorService, IdentityManager identityManager, SpaceService spaceService) throws ConfigurationException {
        super(params);
        this.externalVisioConnectorService = externalVisioConnectorService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
    }

    public String getTitle() {
        return EXTERNAL_VISIO_TITLE;
    }

    public String getVersion() {
        return null;
    }

    public String getType() {
        return EXTERNAL_VISIO_TYPE;
    }

    public String[] getSupportedTypes() {
        return new String[]{this.getType()};
    }

    public UserInfo.IMInfo getIMInfo(String imId) throws CallProviderException {
        return null;
    }

    public List<ActiveCallProvider> getActiveProvidersForSpace(String spaceId) {
        List<ExternalVisioConnector> externalVisioConnectors = this.externalVisioConnectorService.getActiveExternalVisioConnectorsForSpace();
        return externalVisioConnectors.stream().map(externalVisioConnector -> new ActiveCallProvider(externalVisioConnector.getId().toString(), externalVisioConnector.getName(), null, false, true)).toList();
    }

    public boolean canInvite() {
        return false;
    }

    public boolean isConfiguredForIdentity(String remoteId) {
        Identity identity = this.identityManager.getOrCreateSpaceIdentity(remoteId);
        if (identity == null) {
            identity = this.identityManager.getOrCreateUserIdentity(remoteId);
        }
        if (identity != null) {
            return !this.externalVisioConnectorService.getConfiguredExternalVisioConnectors(identity).isEmpty();
        }
        return false;
    }
}

