/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.externalvisio.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webconferencing.externalvisio.rest.model.ExternalVisioConnector;
import org.exoplatform.webconferencing.externalvisio.rest.model.ExternalVisioConnectors;
import org.exoplatform.webconferencing.externalvisio.rest.util.EntityBuilder;
import org.exoplatform.webconferencing.externalvisio.service.ExternalVisioConnectorService;

@Path(value="/v1/externalVisio")
@Tag(name="/v1/externalVisio", description="Manages external visio connector")
public class ExternalVisioConnectorRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ExternalVisioConnectorRest.class);
    private final ExternalVisioConnectorService externalVisioConnectorService;
    private final IdentityManager identityManager;
    private final SpaceService spaceService;

    public ExternalVisioConnectorRest(ExternalVisioConnectorService externalVisioConnectorService, IdentityManager identityManager, SpaceService spaceService) {
        this.externalVisioConnectorService = externalVisioConnectorService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Creates a new External visio connector", description="Creates a new External visio connector", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createExternalVisioConnector(@RequestBody(description="ExternalVisioConnector object to create", required=true) ExternalVisioConnector externalVisioConnector) {
        if (externalVisioConnector == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"externalVisioConnector object is mandatory").build();
        }
        try {
            ExternalVisioConnector createdExternalVisioConnector = this.externalVisioConnectorService.createExternalVisioConnector(EntityBuilder.toEntity(externalVisioConnector));
            return Response.ok().entity((Object)createdExternalVisioConnector).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating a ExternalVisioConnector", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/connectors")
    @Operation(summary="Retrieves the list of external visio connectors", description="Retrieves the list of external visio connectors for an authenticated user", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getExternalVisioConnectors(@Parameter(description="filter ExternalVisioConnector by status", required=true) @Schema(defaultValue="true") @QueryParam(value="enabled") Boolean enabled) {
        try {
            List<ExternalVisioConnector> externalVisioConnectors = this.externalVisioConnectorService.getExternalVisioConnectors(enabled);
            return Response.ok(externalVisioConnectors).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of external visio connectors", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Operation(summary="Saves a externalVisioConnectors", description="Saves a externalVisioConnectors", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveExternalVisioConnectors(@RequestBody(description="ExternalVisioConnectors to create", required=true) ExternalVisioConnectors externalVisioConnectors) {
        if (externalVisioConnectors == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"externalVisioConnectors object is mandatory").build();
        }
        try {
            this.externalVisioConnectorService.saveExternalVisioConnectors(externalVisioConnectors);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving list of external visio connectors", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Updates an ExternalVisioConnector", description="Updates an ExternalVisioConnector", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateExternalVisioConnector(@Parameter(description="External visio id", required=true) @PathParam(value="id") long externalVisioId, @RequestBody(description="externalVisioConnector object to update", required=true) ExternalVisioConnector externalVisioConnector) {
        if (externalVisioConnector == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"externalVisioConnector object is mandatory").build();
        }
        if (externalVisioId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"ExternalVisio technical identifier must be positive").build();
        }
        try {
            ExternalVisioConnector updatedExternalVisioConnector = this.externalVisioConnectorService.updateExternalVisioConnector(EntityBuilder.toEntity(externalVisioConnector));
            return Response.ok((Object)updatedExternalVisioConnector).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating an ExternalVisioConnector", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Operation(summary="Deletes an ExternalVisioConnector", description="Deletes an ExternalVisioConnector", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteExternalVisioConnector(@Parameter(description="External visio id", required=true) @PathParam(value="id") long externalVisioId) {
        if (externalVisioId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"ExternalVisio technical identifier must be positive").build();
        }
        try {
            this.externalVisioConnectorService.deleteExternalVisioConnector(externalVisioId);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error deleting an ExternalVisioConnector", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="{identityId}")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves the list of configured external visio connectors", method="GET", description="Retrieves the list of configured external visio connectors")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getConfiguredExternalVisioConnectors(@Parameter(description="identityId", required=true) @PathParam(value="identityId") String identityId) {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Space space = this.spaceService.getSpaceByPrettyName(identityId);
        Identity identity = null;
        if (space != null) {
            identity = this.identityManager.getOrCreateSpaceIdentity(identityId);
            if (!this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(authenticatedUser)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
        } else {
            identity = this.identityManager.getOrCreateUserIdentity(identityId);
        }
        try {
            List<Object> externalVisioConnectors = new ArrayList();
            if (identity != null) {
                externalVisioConnectors = this.externalVisioConnectorService.getConfiguredExternalVisioConnectors(identity);
            }
            return Response.ok(externalVisioConnectors).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of configured external visio connectors", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

