/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.externalvisio.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webconferencing.externalvisio.dao.ExternalVisioConnectorDAO;
import org.exoplatform.webconferencing.externalvisio.entity.ExternalVisioConnectorEntity;
import org.exoplatform.webconferencing.externalvisio.rest.model.ExternalVisioConnector;
import org.exoplatform.webconferencing.externalvisio.rest.model.ExternalVisioConnectors;
import org.exoplatform.webconferencing.externalvisio.rest.util.EntityBuilder;
import org.exoplatform.webconferencing.externalvisio.service.ExternalVisioConnectorService;

public class ExternalVisioConnectorServiceImpl
implements ExternalVisioConnectorService {
    private static final Log LOG = ExoLogger.getLogger(ExternalVisioConnectorServiceImpl.class);
    private final ExternalVisioConnectorDAO externalVisioConnectorDAO;
    private final ProfilePropertyService profilePropertyService;
    private final SettingService settingService;
    private final SpaceService spaceService;

    public ExternalVisioConnectorServiceImpl(ExternalVisioConnectorDAO externalVisioConnectorDAO, ProfilePropertyService profilePropertyService, SettingService settingService, SpaceService spaceService) {
        this.externalVisioConnectorDAO = externalVisioConnectorDAO;
        this.profilePropertyService = profilePropertyService;
        this.settingService = settingService;
        this.spaceService = spaceService;
    }

    @Override
    public ExternalVisioConnector createExternalVisioConnector(ExternalVisioConnectorEntity externalVisioConnectorEntity) {
        if (externalVisioConnectorEntity == null) {
            throw new IllegalArgumentException("externalVisioConnectorEntity is mandatory");
        }
        if (externalVisioConnectorEntity.isActiveForUsers()) {
            this.createPropertySetting(externalVisioConnectorEntity);
        }
        return EntityBuilder.fromEntity((ExternalVisioConnectorEntity)this.externalVisioConnectorDAO.create(externalVisioConnectorEntity));
    }

    @Override
    public List<ExternalVisioConnector> getExternalVisioConnectors(boolean enabled) {
        List<ExternalVisioConnectorEntity> visioConnectorEntityList = this.externalVisioConnectorDAO.getExternalVisioConnectors(enabled);
        return visioConnectorEntityList.stream().map(EntityBuilder::fromEntity).toList();
    }

    @Override
    public void saveExternalVisioConnectors(ExternalVisioConnectors externalVisioConnectors) {
        List<ExternalVisioConnector> visioConnectorList;
        List<ExternalVisioConnector> existingVisioConnectors = this.getExternalVisioConnectors(externalVisioConnectors.isEnabled());
        if (CollectionUtils.isEmpty(existingVisioConnectors)) {
            existingVisioConnectors = Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(visioConnectorList = externalVisioConnectors.getVisioConnectors())) {
            visioConnectorList = Collections.emptyList();
        }
        this.processUpdatedExternalVisioConnectors(visioConnectorList, existingVisioConnectors);
    }

    private void processUpdatedExternalVisioConnectors(List<ExternalVisioConnector> visioConnectorList, List<ExternalVisioConnector> existingVisioConnectors) {
        visioConnectorList.stream().filter(l -> existingVisioConnectors.stream().anyMatch(l2 -> l.getId() == l2.getId())).forEach(connector -> this.externalVisioConnectorDAO.update(EntityBuilder.toEntity(connector)));
    }

    @Override
    public ExternalVisioConnector updateExternalVisioConnector(ExternalVisioConnectorEntity externalVisioConnectorEntity) throws ObjectNotFoundException {
        if (externalVisioConnectorEntity == null) {
            throw new IllegalArgumentException("externalVisioConnectorEntity is mandatory");
        }
        ExternalVisioConnectorEntity oldExternalVisioConnectorEntity = (ExternalVisioConnectorEntity)this.externalVisioConnectorDAO.find(externalVisioConnectorEntity.getId());
        if (oldExternalVisioConnectorEntity == null) {
            throw new ObjectNotFoundException("externalVisioConnector is not exist");
        }
        if (oldExternalVisioConnectorEntity.equals(externalVisioConnectorEntity)) {
            throw new IllegalArgumentException("there are no changes to save");
        }
        ProfilePropertySetting profilePropertySetting = this.profilePropertyService.getProfileSettingByName(oldExternalVisioConnectorEntity.getName());
        if (profilePropertySetting != null) {
            profilePropertySetting.setPropertyName(externalVisioConnectorEntity.getName());
            profilePropertySetting.setActive(externalVisioConnectorEntity.isActiveForUsers());
            this.profilePropertyService.updatePropertySetting(profilePropertySetting);
        } else if (externalVisioConnectorEntity.isActiveForUsers()) {
            this.createPropertySetting(externalVisioConnectorEntity);
        }
        return EntityBuilder.fromEntity((ExternalVisioConnectorEntity)this.externalVisioConnectorDAO.update(externalVisioConnectorEntity));
    }

    @Override
    public void deleteExternalVisioConnector(long externalVisioId) {
        ExternalVisioConnectorEntity externalVisioConnectorEntity = (ExternalVisioConnectorEntity)this.externalVisioConnectorDAO.find(Long.valueOf(externalVisioId));
        if (externalVisioConnectorEntity == null) {
            throw new IllegalArgumentException("externalVisioConnectorEntity is mandatory");
        }
        this.externalVisioConnectorDAO.delete(externalVisioConnectorEntity);
        this.removeConnectorSettingForAllSpaces(externalVisioConnectorEntity);
        this.removePropertySetting(externalVisioConnectorEntity);
    }

    @Override
    public List<ExternalVisioConnector> getActiveExternalVisioConnectorsForSpace() {
        List<ExternalVisioConnectorEntity> activeVisioConnectorEntityList = this.externalVisioConnectorDAO.getActiveExternalVisioConnectors(true);
        return activeVisioConnectorEntityList.stream().map(EntityBuilder::fromEntity).toList();
    }

    @Override
    public List<ExternalVisioConnector> getActiveExternalVisioConnectorsForUser() {
        List<ExternalVisioConnectorEntity> activeVisioConnectorEntityList = this.externalVisioConnectorDAO.getActiveExternalVisioConnectors(false);
        return activeVisioConnectorEntityList.stream().map(EntityBuilder::fromEntity).toList();
    }

    @Override
    public List<ExternalVisioConnector> getConfiguredExternalVisioConnectors(Identity identity) {
        List<Object> externalVisioConnectors = identity.isSpace() || identity.isUser() ? this.externalVisioConnectorDAO.getActiveExternalVisioConnectors(identity.isSpace()) : new ArrayList();
        return externalVisioConnectors.stream().map(EntityBuilder::fromEntity).map(p -> {
            p.setUrl(this.getExternalVisioConnectorsUrl(identity, (ExternalVisioConnector)p));
            return p;
        }).filter(p -> p.getUrl() != null && !p.getUrl().isBlank()).toList();
    }

    public String getExternalVisioConnectorsUrl(Identity identity, ExternalVisioConnector externalVisioConnector) {
        String url = null;
        if (identity.isSpace()) {
            Space space = this.spaceService.getSpaceByPrettyName(identity.getRemoteId());
            SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.SPACE.id(space.getId()), String.valueOf(externalVisioConnector.getId()));
            if (settingValue != null) {
                url = String.valueOf(settingValue.getValue());
            }
        } else if (identity.isUser()) {
            url = (String)identity.getProfile().getProperty(externalVisioConnector.getName());
        }
        return url;
    }

    public void createPropertySetting(ExternalVisioConnectorEntity externalVisioConnectorEntity) {
        ProfilePropertySetting profilePropertySetting = new ProfilePropertySetting();
        profilePropertySetting.setActive(true);
        profilePropertySetting.setEditable(true);
        profilePropertySetting.setVisible(false);
        profilePropertySetting.setPropertyName(externalVisioConnectorEntity.getName());
        profilePropertySetting.setGroupSynchronized(false);
        profilePropertySetting.setRequired(false);
        profilePropertySetting.setMultiValued(false);
        try {
            this.profilePropertyService.createPropertySetting(profilePropertySetting);
        }
        catch (ObjectAlreadyExistsException e) {
            LOG.warn((Object)("Profile property " + profilePropertySetting.getPropertyName() + " already exists"));
        }
    }

    private void removeConnectorSettingForAllSpaces(ExternalVisioConnectorEntity externalVisioConnectorEntity) {
        Map settings = this.settingService.getSettingsByContext(Context.GLOBAL);
        settings.entrySet().stream().filter(entry -> ((Scope)entry.getKey()).getName().equals(Scope.SPACE.getName())).forEach(entry -> ((Map)entry.getValue()).entrySet().stream().filter(settingEntry -> ((String)settingEntry.getKey()).equals(String.valueOf(externalVisioConnectorEntity.getId()))).forEach(settingEntry -> this.settingService.remove(Context.GLOBAL, (Scope)entry.getKey(), String.valueOf(externalVisioConnectorEntity.getId()))));
    }

    public void removePropertySetting(ExternalVisioConnectorEntity externalVisioConnectorEntity) {
        ProfilePropertySetting profilePropertySetting = this.profilePropertyService.getProfileSettingByName(externalVisioConnectorEntity.getName());
        if (profilePropertySetting != null) {
            this.profilePropertyService.deleteProfilePropertySetting(profilePropertySetting.getId());
        }
    }
}

