/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.exoplatform.api.calendar.CalendarException;
import org.exoplatform.api.calendar.CalendarsService;
import org.exoplatform.api.calendar.Event;
import org.exoplatform.calendar.CalendarFactory;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarsServiceImpl
implements CalendarsService {
    private CalendarService calendarService;

    public CalendarsServiceImpl(CalendarService calendarService) {
        this.calendarService = calendarService;
    }

    public Event addEvent(String username, Event event) throws CalendarException {
        try {
            String calendarId = this.getDefaultCalendarId(username);
            CalendarEvent evt = CalendarFactory.toCalendarEvent(event);
            this.calendarService.saveUserEvent(username, calendarId, evt, true);
            return CalendarFactory.toEvent(evt);
        }
        catch (Exception e) {
            throw new CalendarException(e);
        }
    }

    String getDefaultCalendarId(String username) throws Exception {
        List calendars = this.calendarService.getUserCalendars(username, true);
        return ((Calendar)calendars.get(0)).getId();
    }

    public List<Event> getNextEvents(String username, int limit) throws CalendarException {
        try {
            List<Event> result = null;
            String calendarId = this.getDefaultCalendarId(username);
            EventQuery query = this.nextEventsQuery(limit, calendarId);
            List events = this.calendarService.getUserEvents(username, query);
            result = CalendarFactory.toEvents(events);
            return result;
        }
        catch (Exception e) {
            throw new CalendarException(e);
        }
    }

    EventQuery newEventQuery(String calendarId) {
        EventQuery eventQuery = new EventQuery();
        eventQuery.setCalendarId(new String[]{calendarId});
        return eventQuery;
    }

    private EventQuery nextEventsQuery(int limit, String calendarId) {
        EventQuery eventQuery = this.newEventQuery(calendarId);
        eventQuery.setLimitedItems(limit);
        GregorianCalendar now = new GregorianCalendar();
        now.setTime(new Date());
        eventQuery.setFromDate((java.util.Calendar)now);
        return eventQuery;
    }
}

