/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.backup.exporter;

import java.util.Collections;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.NodeDataOrderComparator;
import org.exoplatform.services.jcr.impl.dataflow.PropertyDataOrderComparator;
import org.exoplatform.services.jcr.impl.xml.exporting.WorkspaceSystemViewStreamExporter;

public class SystemWorkspaceStreamExporter
extends WorkspaceSystemViewStreamExporter {
    public SystemWorkspaceStreamExporter(XMLStreamWriter writer, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        super(writer, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
    }

    public void visit(NodeData node) throws RepositoryException {
        try {
            if (this.currentLevel == 1 && !this.getExportName((ItemData)node, false).equals("jcr:system")) {
                return;
            }
            if (this.currentLevel == 2 && !this.getExportName((ItemData)node, false).equals("jcr:versionStorage") && !this.getExportName((ItemData)node, false).equals("exo:ecm")) {
                return;
            }
            this.entering(node, this.currentLevel);
            if (this.maxLevel == -1 || this.currentLevel < this.maxLevel) {
                ++this.currentLevel;
                List properties = this.dataManager.getChildPropertiesData(node);
                Collections.sort(properties, new PropertyDataOrderComparator());
                for (PropertyData data : properties) {
                    InternalQName propName = data.getQPath().getName();
                    if (Constants.JCR_LOCKISDEEP.equals((Object)propName) || Constants.JCR_LOCKOWNER.equals((Object)propName)) continue;
                    data.accept((ItemDataVisitor)this);
                }
                if (!this.isNoRecurse() && this.currentLevel > 0) {
                    List nodes = this.dataManager.getChildNodesData(node);
                    Collections.sort(nodes, new NodeDataOrderComparator());
                    for (NodeData data : nodes) {
                        data.accept((ItemDataVisitor)this);
                    }
                }
                --this.currentLevel;
            }
            this.leaving(node, this.currentLevel);
        }
        catch (RepositoryException re) {
            this.currentLevel = 0;
            throw re;
        }
    }
}

