/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.queries.impl.QueryData;
import org.exoplatform.services.cms.queries.impl.QueryPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;

public class QueryHandler
extends ComponentHandler {
    private static final String AUTO_CREATE_IN_NEW_REPOSITORY = "autoCreateInNewRepository".intern();
    private static final String STATEMENT = "jcr:statement".intern();
    private static final String LANGUAGE = "jcr:language".intern();
    private static final String PERMISSIONS = "exo:accessPermissions".intern();
    private static final String CACHED_RESULT = "exo:cachedResult".intern();
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public QueryHandler() {
        super.setTargetComponentName(QueryService.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        Object dmsWorkspaceSession = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Handler invoked for component: " + component.getKey()));
            }
            List componentPluginsList = this.cleanComponentPlugins(component, QueryPlugin.class);
            ComponentPlugin templatesComponentPlugin = new ComponentPlugin();
            templatesComponentPlugin.setName("query.plugin");
            templatesComponentPlugin.setSetMethod("setQueryPlugin");
            templatesComponentPlugin.setType(QueryPlugin.class.getName());
            InitParams templatesPluginInitParams = new InitParams();
            templatesComponentPlugin.setInitParams(templatesPluginInitParams);
            if (component.getInitParams() != null) {
                ValueParam valueParam = new ValueParam();
                valueParam.setName(AUTO_CREATE_IN_NEW_REPOSITORY);
                String autoCreateInNewRepository = "false";
                ValueParam originalParam = component.getInitParams().getValueParam(AUTO_CREATE_IN_NEW_REPOSITORY);
                if (originalParam != null) {
                    autoCreateInNewRepository = originalParam.getValue();
                }
                valueParam.setValue(autoCreateInNewRepository);
                templatesPluginInitParams.addParam((Object)valueParam);
            }
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository repository = repositoryService.getDefaultRepository();
            String defaumtRepositoryName = repository.getConfiguration().getName();
            ValueParam valueParam = new ValueParam();
            valueParam.setName("repository");
            valueParam.setValue(defaumtRepositoryName);
            templatesPluginInitParams.addParam((Object)valueParam);
            componentPluginsList.add(templatesComponentPlugin);
            QueryService queryService = (QueryService)container.getComponentInstanceOfType(QueryService.class);
            SessionProvider systemSessionProvider = SessionProvider.createSystemProvider();
            List queryNodes = queryService.getSharedQueries(defaumtRepositoryName, systemSessionProvider);
            for (Node node : queryNodes) {
                QueryData queryData = new QueryData();
                queryData.setCacheResult(node.getProperty(CACHED_RESULT).getBoolean());
                queryData.setStatement(node.getProperty(STATEMENT).getString());
                queryData.setLanguage(node.getProperty(LANGUAGE).getString());
                Value[] vls = node.getProperty(PERMISSIONS).getValues();
                ArrayList<String> permissions = new ArrayList<String>();
                for (Value permissionValue : vls) {
                    permissions.add(permissionValue.getString());
                }
                queryData.setPermissions(permissions);
                queryData.setName(node.getName());
                ObjectParameter objectParam = new ObjectParameter();
                objectParam.setName(queryData.getName());
                objectParam.setObject((Object)queryData);
                templatesPluginInitParams.addParam((Object)objectParam);
            }
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.XML);
            entry.setContent(this.toXML(configuration));
            ComponentHandler.Entry entry2 = entry;
            return entry2;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            ComponentHandler.Entry entry = null;
            return entry;
        }
        finally {
            if (dmsWorkspaceSession != null) {
                dmsWorkspaceSession.logout();
            }
        }
    }
}

