/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.common.handler.impl;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.platform.migration.common.component.Logger;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.resources.Query;
import org.exoplatform.services.resources.ResourceBundleData;
import org.exoplatform.services.resources.ResourceBundleService;

public class ResourceBundleHandler
extends ComponentHandler {
    private Logger logger_ = null;

    public ResourceBundleHandler(InitParams initParams) {
        super.setTargetComponentName(ResourceBundleService.class.getName());
    }

    public ComponentHandler.Entry invoke(Component component, ExoContainer container) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(out);
        this.logger_ = (Logger)container.getComponentInstanceOfType(Logger.class);
        this.logger_.setLogger(((Object)((Object)this)).getClass());
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Invoking handler ");
        }
        this.writeResourceBundles(component, zos, container);
        Configuration configuration = new Configuration();
        configuration.addComponent((Object)component);
        zos.putNextEntry(new ZipEntry(component.getKey() + ".xml"));
        zos.write(this.toXML(configuration));
        zos.closeEntry();
        zos.close();
        ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
        entry.setType(ComponentHandler.EntryType.ZIP);
        entry.setContent(out.toByteArray());
        return entry;
    }

    private void writeResourceBundles(Component component, ZipOutputStream zos, ExoContainer container) throws Exception {
        ResourceBundleService resourceBundleService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Component: " + resourceBundleService.getClass().getName());
        }
        Query query_ = new Query(null, null);
        List dataList = resourceBundleService.findResourceDescriptions(query_).getAll();
        ArrayList<String> resourcesNames = new ArrayList<String>();
        for (ResourceBundleData rsrcBundleData : dataList) {
            resourcesNames.add(rsrcBundleData.getName());
            String resourceBundleName = rsrcBundleData.getName().replaceAll("\\.", "/");
            zos.putNextEntry(new ZipEntry(resourceBundleName + "_" + rsrcBundleData.getLanguage() + ".properties"));
            zos.write(rsrcBundleData.getData().getBytes());
            zos.closeEntry();
            if (!this.logger_.isDebugEnabled()) continue;
            this.logger_.debug("Adding entry: " + resourceBundleName + "_" + rsrcBundleData.getLanguage() + ".properties");
        }
        ValuesParam initResources = component.getInitParams().getValuesParam("init.resources");
        ArrayList initValues = initResources.getValues();
        ValuesParam portalResources = component.getInitParams().getValuesParam("portal.resource.names");
        ArrayList portalValues = portalResources.getValues();
        HashSet<String> values = new HashSet<String>();
        values.addAll(initValues);
        values.addAll(portalValues);
        values.addAll(resourcesNames);
        initResources.setValues(new ArrayList(values));
    }
}

