/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.common.handler.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.migration.common.component.Logger;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationConfig;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;

public class OrganizationServiceHandler
extends ComponentHandler {
    private OrganizationService organizationService;
    private int maxUsersPerFile = 0;
    private Logger logger_ = null;

    public OrganizationServiceHandler(InitParams initParams) {
        ValueParam valueParam = initParams.getValueParam("max-users-per-file");
        if (valueParam == null || valueParam.getValue().length() == 0) {
            throw new IllegalStateException("max-users-per-file init param is missing");
        }
        this.maxUsersPerFile = Integer.parseInt(valueParam.getValue());
        if (this.maxUsersPerFile == 0) {
            this.maxUsersPerFile = 100;
        }
        super.setTargetComponentName(OrganizationService.class.getName());
    }

    public ComponentHandler.Entry invoke(Component component, ExoContainer container) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(out);
        this.organizationService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        this.logger_ = (Logger)container.getComponentInstanceOfType(Logger.class);
        this.logger_.setLogger(((Object)((Object)this)).getClass());
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Invoking handler for component: " + this.organizationService.getClass().getName());
        }
        this.writeProfiles(zos);
        this.writeUsers(zos);
        Configuration configuration = new Configuration();
        this.writeOrganizationModelData(zos, configuration);
        configuration.addComponent((Object)component);
        zos.putNextEntry(new ZipEntry(component.getKey() + ".xml"));
        zos.write(this.toXML(configuration));
        zos.closeEntry();
        zos.close();
        ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
        entry.setType(ComponentHandler.EntryType.ZIP);
        entry.setContent(out.toByteArray());
        return entry;
    }

    private void writeOrganizationModelData(ZipOutputStream zos, Configuration configuration) throws Exception {
        Configuration organizationServiceConfiguration = this.buildOrganizationServiceConfiguration(this.getOrganizationConfig(this.getAllGroups(), this.getAllMembershipTypes(), null));
        this.addEntry(zos, this.toXML(organizationServiceConfiguration), "OrganizationDataModel/Groups-MembershipTypes.xml");
        configuration.addImport("OrganizationDataModel/Groups-MembershipTypes.xml");
        PageList pageList = this.organizationService.getUserHandler().findUsers(new Query());
        pageList.getPageSize();
        int entryNumber = 1;
        ArrayList<OrganizationConfig.User> orgConfigUsersInSigleFile = new ArrayList<OrganizationConfig.User>();
        int i = 1;
        while (i <= pageList.getAvailablePage()) {
            List users = pageList.getPage(i);
            if (orgConfigUsersInSigleFile.size() < this.maxUsersPerFile) {
                for (Object user : users) {
                    OrganizationConfig.User orgConfigUser = this.convertUserToSerializableObject((User)user);
                    orgConfigUsersInSigleFile.add(orgConfigUser);
                }
                ++i;
            }
            if (orgConfigUsersInSigleFile.size() < this.maxUsersPerFile && i <= pageList.getAvailablePage()) continue;
            Configuration organizationServiceConfiguration2 = this.buildOrganizationServiceConfiguration(this.getOrganizationConfig(null, null, orgConfigUsersInSigleFile));
            this.addEntry(zos, this.toXML(organizationServiceConfiguration2), "OrganizationDataModel/Users" + entryNumber + ".xml");
            orgConfigUsersInSigleFile.clear();
            configuration.addImport("OrganizationDataModel/Users" + entryNumber + ".xml");
            ++entryNumber;
        }
    }

    private OrganizationConfig.User convertUserToSerializableObject(User user) throws Exception {
        OrganizationConfig.User orgConfigUser = new OrganizationConfig.User();
        orgConfigUser.setEmail(user.getEmail());
        orgConfigUser.setFirstName(user.getFirstName());
        orgConfigUser.setLastName(user.getLastName());
        orgConfigUser.setPassword(user.getPassword());
        orgConfigUser.setUserName(user.getUserName());
        Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUser(user.getUserName());
        String groups = "";
        for (Object ob : memberships) {
            groups = groups + ((Membership)ob).getMembershipType() + ":" + ((Membership)ob).getGroupId() + ",";
            groups.substring(0, groups.lastIndexOf(","));
        }
        orgConfigUser.setGroups(groups);
        return orgConfigUser;
    }

    private void addEntry(ZipOutputStream zos, byte[] bytes, String entryName) throws IOException {
        zos.putNextEntry(new ZipEntry(entryName));
        zos.write(bytes);
        zos.closeEntry();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Adding entry: " + entryName);
        }
    }

    private Configuration buildOrganizationServiceConfiguration(OrganizationConfig organizationConfig) {
        Configuration configuration = new Configuration();
        ExternalComponentPlugins externalComponentPlugins = new ExternalComponentPlugins();
        ComponentPlugin componentPlugin = new ComponentPlugin();
        InitParams initParams = new InitParams();
        ValueParam valueParam1 = new ValueParam();
        ValueParam valueParam2 = new ValueParam();
        ObjectParameter objectParam = new ObjectParameter();
        valueParam1.setName("checkDatabaseAlgorithm");
        valueParam1.setValue("entry");
        valueParam2.setName("printInformation");
        valueParam2.setValue("true");
        objectParam.setName("configuration");
        objectParam.setObject((Object)organizationConfig);
        initParams.addParam((Object)valueParam1);
        initParams.addParam((Object)valueParam2);
        initParams.addParameter((Parameter)objectParam);
        externalComponentPlugins.setTargetComponent("org.exoplatform.services.organization.OrganizationService");
        componentPlugin.setName("init.organizationDataModel.listener");
        componentPlugin.setSetMethod("addListenerPlugin");
        componentPlugin.setType("org.exoplatform.services.organization.OrganizationDatabaseInitializer");
        componentPlugin.setInitParams(initParams);
        ArrayList<ComponentPlugin> componentPlugins = new ArrayList<ComponentPlugin>();
        componentPlugins.add(componentPlugin);
        externalComponentPlugins.setComponentPlugins(componentPlugins);
        configuration.addExternalComponentPlugins((Object)externalComponentPlugins);
        return configuration;
    }

    private OrganizationConfig getOrganizationConfig(List groups, List membershipTypes, List users) {
        OrganizationConfig organizationConfig = new OrganizationConfig();
        organizationConfig.setGroup(groups);
        organizationConfig.setMembershipType(membershipTypes);
        organizationConfig.setUser(users);
        return organizationConfig;
    }

    private List getAllGroups() throws Exception {
        ArrayList<OrganizationConfig.Group> allGroups = new ArrayList<OrganizationConfig.Group>();
        try {
            Collection groups = this.organizationService.getGroupHandler().getAllGroups();
            for (Group group : groups) {
                OrganizationConfig.Group orgConfGroup = new OrganizationConfig.Group();
                orgConfGroup.setDescription(group.getDescription());
                orgConfGroup.setLabel(group.getLabel());
                orgConfGroup.setName(group.getGroupName());
                orgConfGroup.setParentId(group.getParentId());
                allGroups.add(orgConfGroup);
            }
        }
        catch (Exception e) {
            this.logger_.error("Error when recovering of all groups ... ", e);
            return null;
        }
        return allGroups;
    }

    private List getAllMembershipTypes() throws Exception {
        ArrayList<OrganizationConfig.MembershipType> allMembershipTypes = new ArrayList<OrganizationConfig.MembershipType>();
        try {
            Collection membershipTypes = this.organizationService.getMembershipTypeHandler().findMembershipTypes();
            for (MembershipType membershipType : membershipTypes) {
                OrganizationConfig.MembershipType orgConfMemberShipType = new OrganizationConfig.MembershipType();
                orgConfMemberShipType.setDescription(membershipType.getDescription());
                orgConfMemberShipType.setType(membershipType.getName());
                allMembershipTypes.add(orgConfMemberShipType);
            }
        }
        catch (Exception e) {
            this.logger_.error("Error when recovering of all membershipTypes ... ", e);
            return null;
        }
        return allMembershipTypes;
    }

    private void writeProfiles(ZipOutputStream zos) throws Exception {
        PageList usersPageList = this.organizationService.getUserHandler().findUsers(new Query());
        int pageCount = usersPageList.getAvailablePage();
        XStream xstream_ = new XStream((HierarchicalStreamDriver)new XppDriver());
        for (int i = 1; i <= pageCount; ++i) {
            List usersList = usersPageList.getPage(i);
            for (User user : usersList) {
                UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(user.getUserName());
                if (userProfile == null || userProfile.getUserInfoMap() == null || userProfile.getUserInfoMap().isEmpty()) continue;
                xstream_.alias("user-profile", userProfile.getClass());
                String xml = xstream_.toXML((Object)userProfile);
                zos.putNextEntry(new ZipEntry("profiles/" + userProfile.getUserName() + "_profile.xml"));
                zos.write(xml.getBytes());
                zos.closeEntry();
                if (!this.logger_.isDebugEnabled()) continue;
                this.logger_.debug("Adding entry for userProfile: " + userProfile.getUserName());
            }
        }
    }

    private void writeUsers(ZipOutputStream zos) throws Exception {
        PageList usersPageList = this.organizationService.getUserHandler().findUsers(new Query());
        int pageCount = usersPageList.getAvailablePage();
        XStream xstream_ = new XStream((HierarchicalStreamDriver)new XppDriver());
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Adding entries for each user, additional fields are missing: LastLoginTime & CreatedDate");
        }
        for (int i = 1; i <= pageCount; ++i) {
            List usersList = usersPageList.getPage(i);
            for (User user : usersList) {
                if (user == null) continue;
                xstream_.alias("user", user.getClass());
                String xml = xstream_.toXML((Object)user);
                zos.putNextEntry(new ZipEntry("users/" + user.getUserName() + "_user.xml"));
                zos.write(xml.getBytes());
                zos.closeEntry();
                if (!this.logger_.isDebugEnabled()) continue;
                this.logger_.debug("Adding entry for user: " + user.getUserName());
            }
        }
    }
}

