/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.drives.impl.ManageDrivePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageDriveHandler
extends ComponentHandler {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public ManageDriveHandler() {
        super.setTargetComponentName(ManageDriveService.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        Object dmsWorkspaceSession = null;
        try {
            List<ComponentPlugin> componentPluginsList = this.cleanComponentPlugins(component);
            ComponentPlugin templatesComponentPlugin = new ComponentPlugin();
            templatesComponentPlugin.setName("manage.drive.plugin");
            templatesComponentPlugin.setSetMethod("setManageDrivePlugin");
            templatesComponentPlugin.setType(ManageDrivePlugin.class.getName());
            InitParams templatesPluginInitParams = new InitParams();
            templatesComponentPlugin.setInitParams(templatesPluginInitParams);
            componentPluginsList.add(templatesComponentPlugin);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository repository = repositoryService.getDefaultRepository();
            String defaumtRepositoryName = repository.getConfiguration().getName();
            ManageDriveService driveService = (ManageDriveService)container.getComponentInstanceOfType(ManageDriveService.class);
            List driveDataList = driveService.getAllDrives(defaumtRepositoryName);
            for (DriveData driveData : driveDataList) {
                driveData.setRepository(defaumtRepositoryName);
                ObjectParameter objectParam = new ObjectParameter();
                objectParam.setName(driveData.getName());
                objectParam.setObject((Object)driveData);
                templatesPluginInitParams.addParam((Object)objectParam);
            }
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey() + ".xml");
            entry.setType(ComponentHandler.EntryType.XML);
            entry.setContent(this.toXML(configuration));
            ComponentHandler.Entry entry2 = entry;
            return entry2;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            ComponentHandler.Entry entry = null;
            return entry;
        }
        finally {
            if (dmsWorkspaceSession != null) {
                dmsWorkspaceSession.logout();
            }
        }
    }

    private List<ComponentPlugin> cleanComponentPlugins(Component component) {
        List componentPluginsList = component.getComponentPlugins();
        int i = 0;
        while (i < componentPluginsList.size()) {
            ComponentPlugin componentPlugin = (ComponentPlugin)componentPluginsList.get(i);
            if (componentPlugin.getType().equals(ManageDrivePlugin.class.getName())) {
                componentPluginsList.remove(i);
                continue;
            }
            ++i;
        }
        return componentPluginsList;
    }
}

