/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.impl.AddNamespacesPlugin;
import org.exoplatform.services.jcr.impl.AddNodeTypePlugin;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeManagerConfigHandler
extends ComponentHandler {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private StringBuffer nodeTypePathTmp_ = new StringBuffer();

    public NodeTypeManagerConfigHandler() {
        super.setTargetComponentName(RepositoryService.class.getName());
    }

    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(out);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Handler invoked for component: " + component.getKey()));
            }
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ExtendedNodeTypeManager ntManager = repositoryService.getDefaultRepository().getNodeTypeManager();
            NodeTypeIterator nodeTypeIter = ntManager.getAllNodeTypes();
            this.cleanComponentPlugins(component, AddNodeTypePlugin.class);
            List componentPluginsList = this.cleanComponentPlugins(component, AddNamespacesPlugin.class);
            this.addNamespaceComponentPlugin(repositoryService, componentPluginsList);
            this.generateNodeTypesConfiguration(zos, nodeTypeIter, componentPluginsList);
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            zos.putNextEntry(new ZipEntry(component.getKey() + ".xml"));
            zos.write(this.toXML(configuration));
            zos.closeEntry();
            zos.close();
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.ZIP);
            entry.setContent(out.toByteArray());
            return entry;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            return null;
        }
    }

    private void generateNodeTypesConfiguration(ZipOutputStream zos, NodeTypeIterator nodeTypeIter, List<ComponentPlugin> componentPluginsList) throws ValueFormatException, IllegalStateException, RepositoryException {
        ValuesParam nodeTypesValuesParam = new ValuesParam();
        nodeTypesValuesParam.setName("autoCreatedInNewRepository");
        nodeTypesValuesParam.setDescription("Node types configuration file");
        ArrayList<String> nodeTypesPathsList = new ArrayList<String>();
        nodeTypesValuesParam.setValues(nodeTypesPathsList);
        InitParams nodeTypePluginInitParams = new InitParams();
        nodeTypePluginInitParams.addParam((Object)nodeTypesValuesParam);
        while (nodeTypeIter.hasNext()) {
            NodeType nodeType = nodeTypeIter.nextNodeType();
            this.addNodeTypeXML(nodeType, zos);
            nodeTypesPathsList.add(this.getNodeTypePath(nodeType));
        }
        ComponentPlugin addNodeTypePlugin = new ComponentPlugin();
        addNodeTypePlugin.setName("add.nodeType");
        addNodeTypePlugin.setInitParams(nodeTypePluginInitParams);
        addNodeTypePlugin.setSetMethod("addPlugin");
        addNodeTypePlugin.setType(AddNodeTypePlugin.class.getName());
        componentPluginsList.add(addNodeTypePlugin);
    }

    private void addNamespaceComponentPlugin(RepositoryService repositoryService, List<ComponentPlugin> componentPluginsList) throws RepositoryException, RepositoryConfigurationException, NamespaceException {
        String[] uris;
        NamespaceRegistry namespaceRegistry = repositoryService.getDefaultRepository().getNamespaceRegistry();
        PropertiesParam namespacesParam = new PropertiesParam();
        namespacesParam.setName("namespaces");
        for (String uri : uris = namespaceRegistry.getURIs()) {
            namespacesParam.addProperty((Object)new Property(namespaceRegistry.getPrefix(uri), uri));
        }
        InitParams namespacesInitParams = new InitParams();
        namespacesInitParams.addParam((Object)namespacesParam);
        ComponentPlugin addNamespacesPlugin = new ComponentPlugin();
        addNamespacesPlugin.setName("add.nodeType");
        addNamespacesPlugin.setInitParams(namespacesInitParams);
        addNamespacesPlugin.setSetMethod("addPlugin");
        addNamespacesPlugin.setType(AddNamespacesPlugin.class.getName());
        componentPluginsList.add(addNamespacesPlugin);
    }

    private String addNodeTypeXML(NodeType nodeType, ZipOutputStream zos) throws ValueFormatException, IllegalStateException, RepositoryException {
        StringBuffer nodeTypeXML = new StringBuffer();
        nodeTypeXML.append("<nodeTypes xmlns:nt=\"http://www.jcp.org/jcr/nt/1.5\" ");
        nodeTypeXML.append("xmlns:mix=\"http://www.jcp.org/jcr/mix/1.5\" ");
        nodeTypeXML.append("xmlns:jcr=\"http://www.jcp.org/jcr/1.5\" >\n");
        nodeTypeXML.append("<nodeType ");
        nodeTypeXML.append("name=\"").append(nodeType.getName()).append("\" ");
        nodeTypeXML.append("isMixin=\"").append(nodeType.isMixin()).append("\" ");
        nodeTypeXML.append("hasOrderableChildNodes=\"").append(nodeType.hasOrderableChildNodes()).append("\" ");
        String primaryItemName = "";
        if (nodeType.getPrimaryItemName() != null) {
            primaryItemName = nodeType.getPrimaryItemName();
        }
        nodeTypeXML.append("primaryItemName=").append("\"").append(primaryItemName).append("\" >\n");
        String representSuperType = this.representSuperTypes(nodeType);
        nodeTypeXML.append(representSuperType);
        String representPropertiesXML = this.representPropertyDefinition(nodeType);
        nodeTypeXML.append(representPropertiesXML);
        String representChildXML = this.representChildNodeDefinition(nodeType);
        nodeTypeXML.append(representChildXML);
        nodeTypeXML.append("</nodeType>").append("\n");
        nodeTypeXML.append("</nodeTypes>");
        try {
            zos.putNextEntry(new ZipEntry(this.getNodeTypePath(nodeType)));
            zos.write(nodeTypeXML.toString().getBytes());
            zos.closeEntry();
        }
        catch (Exception exception) {
            this.log.error((Object)("Error while adding nodetype : " + nodeType.getName()), (Throwable)exception);
        }
        return nodeTypeXML.toString();
    }

    private String getNodeTypePath(NodeType nodeType) {
        this.nodeTypePathTmp_.delete(0, this.nodeTypePathTmp_.length());
        this.nodeTypePathTmp_.append("nodeTypes/");
        this.nodeTypePathTmp_.append(nodeType.getName().replace(":", "/"));
        this.nodeTypePathTmp_.append(".xml");
        return this.nodeTypePathTmp_.toString();
    }

    private String representSuperTypes(NodeType nodeType) {
        StringBuilder superTypeXML = new StringBuilder();
        NodeType[] superType = nodeType.getDeclaredSupertypes();
        if (superType != null && superType.length > 0) {
            superTypeXML.append("<supertypes>").append("\n");
            for (int i = 0; i < superType.length; ++i) {
                String typeName = superType[i].getName();
                superTypeXML.append("<supertype>").append(typeName).append("</supertype>").append("\n");
            }
            superTypeXML.append("</supertypes>").append("\n");
        }
        return superTypeXML.toString();
    }

    private String representPropertyDefinition(NodeType nodeType) throws ValueFormatException, IllegalStateException, RepositoryException {
        String[] requireType = new String[]{"undefined", "String", "Binary", "Long", "Double", "Date", "Boolean", "Name", "Path", "Reference"};
        String[] onparentVersion = new String[]{"", "COPY", "VERSION", "INITIALIZE", "COMPUTE", "IGNORE", "ABORT"};
        StringBuilder propertyXML = new StringBuilder();
        propertyXML.append("<propertyDefinitions>").append("\n");
        PropertyDefinition[] proDef = nodeType.getPropertyDefinitions();
        for (int j = 0; j < proDef.length; ++j) {
            String[] constraints;
            propertyXML.append("<propertyDefinition ");
            propertyXML.append("name=").append("\"").append(proDef[j].getName()).append("\" ");
            String requiredValue = null;
            requiredValue = proDef[j].getRequiredType() == 100 ? "Permission" : requireType[proDef[j].getRequiredType()];
            propertyXML.append("requiredType=").append("\"").append(requiredValue).append("\" ");
            String autoCreate = String.valueOf(proDef[j].isAutoCreated());
            propertyXML.append("autoCreated=").append("\"").append(autoCreate).append("\" ");
            String mandatory = String.valueOf(proDef[j].isMandatory());
            propertyXML.append("mandatory=").append("\"").append(mandatory).append("\" ");
            String onVersion = onparentVersion[proDef[j].getOnParentVersion()];
            propertyXML.append("onParentVersion=").append("\"").append(onVersion).append("\" ");
            String protect = String.valueOf(proDef[j].isProtected());
            propertyXML.append("protected=").append("\"").append(protect).append("\" ");
            String multiple = String.valueOf(proDef[j].isMultiple());
            propertyXML.append("multiple=").append("\"").append(multiple).append("\" >").append("\n");
            Value[] defaultValues = proDef[j].getDefaultValues();
            if (defaultValues != null && defaultValues.length > 0) {
                propertyXML.append("<defaultValues>").append("\n");
                for (int k = 0; k < defaultValues.length; ++k) {
                    String defaultValue = defaultValues[k].getString();
                    propertyXML.append("<defaultValue>").append(defaultValue).append("</defaultValue>");
                    propertyXML.append("\n");
                }
                propertyXML.append("</defaultValues>").append("\n");
            }
            if ((constraints = proDef[j].getValueConstraints()) != null && constraints.length > 0) {
                propertyXML.append("<valueConstraints>").append("\n");
                for (int k = 0; k < constraints.length; ++k) {
                    String cons = constraints[k].toString();
                    propertyXML.append("<valueConstraint>").append(cons).append("</valueConstraint>");
                    propertyXML.append("\n");
                }
                propertyXML.append("</valueConstraints>").append("\n");
            } else {
                propertyXML.append("<valueConstraints/>").append("\n");
            }
            propertyXML.append("</propertyDefinition>").append("\n");
        }
        propertyXML.append("</propertyDefinitions>").append("\n");
        return propertyXML.toString();
    }

    private String representChildNodeDefinition(NodeType nodeType) {
        String[] onparentVersion = new String[]{"", "COPY", "VERSION", "INITIALIZE", "COMPUTE", "IGNORE", "ABORT"};
        StringBuilder childNodeXML = new StringBuilder();
        NodeDefinition[] childDef = nodeType.getChildNodeDefinitions();
        if (childDef != null && childDef.length > 0) {
            childNodeXML.append("<childNodeDefinitions>").append("\n");
            for (int j = 0; j < childDef.length; ++j) {
                childNodeXML.append("<childNodeDefinition ");
                childNodeXML.append("name=").append("\"").append(childDef[j].getName()).append("\" ");
                NodeType defaultType = childDef[j].getDefaultPrimaryType();
                if (defaultType != null) {
                    String defaultName = defaultType.getName();
                    childNodeXML.append("defaultPrimaryType=").append("\"").append(defaultName).append("\" ");
                } else {
                    childNodeXML.append("defaultPrimaryType=").append("\"").append("\" ");
                }
                String autoCreate = String.valueOf(childDef[j].isAutoCreated());
                childNodeXML.append("autoCreated=").append("\"").append(autoCreate).append("\" ");
                String mandatory = String.valueOf(childDef[j].isMandatory());
                childNodeXML.append("mandatory=").append("\"").append(mandatory).append("\" ");
                String onVersion = onparentVersion[childDef[j].getOnParentVersion()];
                childNodeXML.append("onParentVersion=").append("\"").append(onVersion).append("\" ");
                String protect = String.valueOf(childDef[j].isProtected());
                childNodeXML.append("protected=").append("\"").append(protect).append("\" ");
                String sameName = String.valueOf(childDef[j].allowsSameNameSiblings());
                childNodeXML.append("sameNameSiblings=").append("\"").append(sameName).append("\" >");
                childNodeXML.append("\n");
                NodeType[] requiredType = childDef[j].getRequiredPrimaryTypes();
                if (requiredType != null && requiredType.length > 0) {
                    childNodeXML.append("<requiredPrimaryTypes>").append("\n");
                    for (int k = 0; k < requiredType.length; ++k) {
                        String requiredName = requiredType[k].getName();
                        childNodeXML.append("<requiredPrimaryType>").append(requiredName);
                        childNodeXML.append("</requiredPrimaryType>").append("\n");
                    }
                    childNodeXML.append("</requiredPrimaryTypes>").append("\n");
                }
                childNodeXML.append("</childNodeDefinition>").append("\n");
            }
            childNodeXML.append("</childNodeDefinitions>").append("\n");
        }
        return childNodeXML.toString();
    }
}

