/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.impl.ActionConfig;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyConfig;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonomyHandler
extends ComponentHandler {
    private static final String EXO_PERMISSIONS = "exo:permissions";
    private static final String AUTO_CREATE_IN_NEW_REPOSITORY = "autoCreateInNewRepository".intern();
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public TaxonomyHandler() {
        super.setTargetComponentName(TaxonomyService.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        Object dmsWorkspaceSession = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Handler invoked for component: " + component.getKey()));
            }
            List componentPluginsList = this.cleanComponentPlugins(component, TaxonomyPlugin.class);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository repository = repositoryService.getDefaultRepository();
            String defaumtRepositoryName = repository.getConfiguration().getName();
            TaxonomyService taxonomyService = (TaxonomyService)container.getComponentInstanceOfType(TaxonomyService.class);
            ActionServiceContainer actionServiceContainer = (ActionServiceContainer)container.getComponentInstanceOfType(ActionServiceContainer.class);
            List taxonomyTreeNodes = taxonomyService.getAllTaxonomyTrees(defaumtRepositoryName);
            for (Node node : taxonomyTreeNodes) {
                ObjectParameter objectParam;
                ArrayList<TaxonomyConfig.Taxonomy> taxonomyList;
                ComponentPlugin templatesComponentPlugin = new ComponentPlugin();
                templatesComponentPlugin.setName("predefinedTaxonomyPlugin");
                templatesComponentPlugin.setSetMethod("addTaxonomyPlugin");
                templatesComponentPlugin.setType(TaxonomyPlugin.class.getName());
                InitParams templatesPluginInitParams = new InitParams();
                templatesComponentPlugin.setInitParams(templatesPluginInitParams);
                componentPluginsList.add(templatesComponentPlugin);
                ValueParam valueParam = new ValueParam();
                valueParam.setName(AUTO_CREATE_IN_NEW_REPOSITORY);
                valueParam.setValue("true");
                templatesPluginInitParams.addParam((Object)valueParam);
                valueParam = new ValueParam();
                valueParam.setName("repository");
                valueParam.setValue(defaumtRepositoryName);
                templatesPluginInitParams.addParam((Object)valueParam);
                valueParam = new ValueParam();
                valueParam.setName("treeName");
                valueParam.setValue(node.getName());
                templatesPluginInitParams.addParam((Object)valueParam);
                Node taxonomyRootNode = taxonomyService.getTaxonomyTree(defaumtRepositoryName, node.getName(), true);
                if (node.hasProperty(EXO_PERMISSIONS)) {
                    TaxonomyConfig permissionTaxonomyConfig = new TaxonomyConfig();
                    taxonomyList = new ArrayList<TaxonomyConfig.Taxonomy>();
                    permissionTaxonomyConfig.setTaxonomies(taxonomyList);
                    TaxonomyConfig.Taxonomy taxonomy = new TaxonomyConfig.Taxonomy();
                    taxonomyList.add(taxonomy);
                    Value[] permissionValues = node.getProperty(EXO_PERMISSIONS).getValues();
                    taxonomy.setPermissions(this.getPermissions(permissionValues));
                    objectParam = new ObjectParameter();
                    objectParam.setName("permission.configuration");
                    objectParam.setObject((Object)permissionTaxonomyConfig);
                    templatesPluginInitParams.addParam((Object)objectParam);
                }
                TaxonomyConfig taxonomyConfiguration = new TaxonomyConfig();
                taxonomyList = new ArrayList();
                taxonomyConfiguration.setTaxonomies(taxonomyList);
                String taxonomyRootPath = taxonomyRootNode.getPath();
                NodeIterator subNodes = taxonomyRootNode.getNodes();
                while (subNodes.hasNext()) {
                    Node subNode = subNodes.nextNode();
                    String subTaxonomyPath = subNode.getPath();
                    TaxonomyConfig.Taxonomy taxonomy = new TaxonomyConfig.Taxonomy();
                    taxonomyList.add(taxonomy);
                    if (subNode.hasProperty(EXO_PERMISSIONS)) {
                        Value[] permissionValues = subNode.getProperty(EXO_PERMISSIONS).getValues();
                        taxonomy.setPermissions(this.getPermissions(permissionValues));
                    }
                    taxonomy.setName(subNode.getName());
                    taxonomy.setPath(subTaxonomyPath.replace(taxonomyRootPath, ""));
                }
                objectParam = new ObjectParameter();
                objectParam.setName("taxonomy.configuration");
                objectParam.setObject((Object)taxonomyConfiguration);
                templatesPluginInitParams.addParam((Object)objectParam);
                ActionConfig actionConfig = new ActionConfig();
                ArrayList<ActionConfig.TaxonomyAction> taxonomyActionList = new ArrayList<ActionConfig.TaxonomyAction>();
                actionConfig.setActions(taxonomyActionList);
                actionConfig.setAutoCreatedInNewRepository(false);
                List taxonomyActionNodes = actionServiceContainer.getActions(taxonomyRootNode);
                for (Node taxonomyActionNode : taxonomyActionNodes) {
                    ActionConfig.TaxonomyAction taxonomyAction = new ActionConfig.TaxonomyAction();
                    taxonomyActionList.add(taxonomyAction);
                    taxonomyAction.setName(taxonomyActionNode.getName());
                    if (taxonomyActionNode.hasProperty("exo:description")) {
                        taxonomyAction.setDescription(taxonomyActionNode.getProperty("exo:description").getString());
                    }
                    if (taxonomyActionNode.hasProperty("exo:storeHomePath")) {
                        taxonomyAction.setHomePath(taxonomyActionNode.getProperty("exo:storeHomePath").getString());
                    }
                    if (taxonomyActionNode.hasProperty("exo:lifecyclePhase")) {
                        taxonomyAction.setLifecyclePhase(taxonomyActionNode.getProperty("exo:lifecyclePhase").getString());
                    }
                    ArrayList<String> mixins = new ArrayList<String>();
                    taxonomyActionNode.getMixinNodeTypes();
                    for (String mixin : mixins) {
                        mixins.add(mixin);
                    }
                    taxonomyAction.setMixins(mixins);
                    if (taxonomyActionNode.hasProperty("exo:role")) {
                        Value[] roles = taxonomyActionNode.getProperty("exo:role").getValues();
                        StringBuffer rolesStringBuffer = new StringBuffer();
                        for (Value roleValue : roles) {
                            rolesStringBuffer.append(roleValue.getString()).append(";");
                        }
                        if (rolesStringBuffer.length() > 0) {
                            rolesStringBuffer.replace(rolesStringBuffer.length() - 1, rolesStringBuffer.length(), "");
                        }
                        taxonomyAction.setRoles(rolesStringBuffer.toString());
                    }
                    if (taxonomyActionNode.hasProperty("exo:targetPath")) {
                        taxonomyAction.setTargetPath(taxonomyActionNode.getProperty("exo:targetPath").getString());
                    }
                    if (taxonomyActionNode.hasProperty("exo:targetWorkspace")) {
                        taxonomyAction.setTargetWspace(taxonomyActionNode.getProperty("exo:targetWorkspace").getString());
                    }
                    taxonomyAction.setType(taxonomyActionNode.getPrimaryNodeType().getName());
                }
                ObjectParameter objectParam2 = new ObjectParameter();
                objectParam2.setName("predefined.actions");
                objectParam2.setObject((Object)actionConfig);
                templatesPluginInitParams.addParam((Object)objectParam2);
            }
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.XML);
            entry.setContent(this.toXML(configuration));
            ComponentHandler.Entry entry2 = entry;
            return entry2;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            ComponentHandler.Entry entry = null;
            return entry;
        }
        finally {
            if (dmsWorkspaceSession != null) {
                dmsWorkspaceSession.logout();
            }
        }
    }

    public List<TaxonomyConfig.Permission> getPermissions(Value[] permissionValues) throws ValueFormatException, IllegalStateException, RepositoryException {
        HashMap permissionsMap = new HashMap();
        for (Value permission : permissionValues) {
            String[] permissionEntries = permission.getString().split(" ");
            List<String> permissionDetails = null;
            permissionDetails = !permissionsMap.containsKey(permissionEntries[0]) ? new ArrayList<String>() : (List)permissionsMap.get(permissionEntries[0]);
            permissionDetails.add(permissionEntries[1]);
            permissionsMap.put(permissionEntries[0], permissionDetails);
        }
        ArrayList<TaxonomyConfig.Permission> permissionList = new ArrayList<TaxonomyConfig.Permission>();
        for (Map.Entry permissionEntry : permissionsMap.entrySet()) {
            Value permission;
            permission = new TaxonomyConfig.Permission();
            permission.setIdentity((String)permissionEntry.getKey());
            for (String perm : (List)permissionEntry.getValue()) {
                if ("read".equals(perm)) {
                    permission.setRead("true");
                    continue;
                }
                if ("add_node".equals(perm)) {
                    permission.setAddNode("true");
                    continue;
                }
                if ("set_property".equals(perm)) {
                    permission.setSetProperty("true");
                    continue;
                }
                if (!"remove".equals(perm)) continue;
                permission.setRemove("true");
            }
            permissionList.add((TaxonomyConfig.Permission)permission);
        }
        return permissionList;
    }
}

