/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.rest;

import java.io.ByteArrayInputStream;
import org.apache.commons.logging.Log;
import org.exoplatform.platform.migration.common.component.MarshallConfigurationService;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;

@URITemplate(value="/containersConfiguration")
public class MarshallConfigurationREST
implements ResourceContainer {
    private MarshallConfigurationService marshallConfigurationService;
    private Log log = ExoLogger.getLogger(this.getClass());

    public MarshallConfigurationREST(MarshallConfigurationService marshallConfigurationService) {
        this.marshallConfigurationService = marshallConfigurationService;
    }

    @HTTPMethod(value="GET")
    @URITemplate
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response containersList() {
        String htmlContainersLink;
        this.log.info((Object)("Starting: " + this.getClass().getName()));
        this.log.info((Object)"The Marshaller is ready for use ..");
        try {
            htmlContainersLink = this.marshallConfigurationService.generateHTMLContainersList();
        }
        catch (Exception e) {
            this.log.error((Object)"Error while generating containers list", (Throwable)e);
            return null;
        }
        return Response.Builder.ok().entity((Object)htmlContainersLink, "text/html").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/ComponentsList/")
    @OutputTransformer(value=StringOutputTransformer.class)
    public Response componentsList(@QueryParam(value="containerId") String containerId) {
        String htmlComponentsLink;
        try {
            htmlComponentsLink = this.marshallConfigurationService.generateHTMLComponentsList(containerId);
        }
        catch (Exception e) {
            this.log.error((Object)("Error while generating components list for container: " + containerId), (Throwable)e);
            return null;
        }
        return Response.Builder.ok().entity((Object)htmlComponentsLink, "text/html").build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/getComponentConfiguration/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getComponentConfiguration(@QueryParam(value="containerId") String containerId, @QueryParam(value="componentKey") String componentKey) {
        ComponentHandler.Entry configurationEntry;
        try {
            configurationEntry = this.marshallConfigurationService.getComponentConfiguration(containerId, componentKey);
        }
        catch (Exception e) {
            this.log.error((Object)("Error while generating component configuration for component: " + componentKey), (Throwable)e);
            return null;
        }
        Response.Builder builder = Response.Builder.ok();
        if (configurationEntry.getType().equals((Object)ComponentHandler.EntryType.ZIP)) {
            builder.header("Content-disposition", "attachment; filename=" + configurationEntry.getComponentName() + configurationEntry.getType());
        }
        return builder.entity((Object)new ByteArrayInputStream(configurationEntry.getContent())).build();
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/exportContainerComponents/")
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getAllComponentsConfiguration(@QueryParam(value="containerId") String containerId) {
        ComponentHandler.Entry configurationEntry;
        try {
            configurationEntry = this.marshallConfigurationService.getAllComponentsConfiguration(containerId);
        }
        catch (Exception e) {
            this.log.error((Object)("Error while generating all configurations for container: " + containerId), (Throwable)e);
            return null;
        }
        Response.Builder builder = Response.Builder.ok();
        builder.header("Content-disposition", "attachment; filename=" + configurationEntry.getComponentName() + configurationEntry.getType());
        return builder.entity((Object)new ByteArrayInputStream(configurationEntry.getContent()), configurationEntry.getType().getMediaType()).build();
    }
}

