/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.cms.impl.ResourceConfig;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.scripts.impl.ScriptPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScriptHandler
extends ComponentHandler {
    private static final String AUTO_CREATE_IN_NEW_REPOSITORY = "autoCreateInNewRepository";
    private static final String SCRIPTS_LOCATION = "scripts/";
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public GroovyScriptHandler() {
        super.setTargetComponentName(ScriptService.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        Object dmsWorkspaceSession = null;
        try {
            ValueParam valueParam;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(out);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Handler invoked for component: " + component.getKey()));
            }
            List<ComponentPlugin> componentPluginsList = this.cleanComponentPlugins(component);
            ComponentPlugin templatesComponentPlugin = new ComponentPlugin();
            templatesComponentPlugin.setName("manage.script.plugin");
            templatesComponentPlugin.setSetMethod("addScriptPlugin");
            templatesComponentPlugin.setType(ScriptPlugin.class.getName());
            InitParams templatesPluginInitParams = new InitParams();
            templatesComponentPlugin.setInitParams(templatesPluginInitParams);
            if (component.getInitParams() != null) {
                valueParam = new ValueParam();
                valueParam.setName(AUTO_CREATE_IN_NEW_REPOSITORY);
                String autoCreateInNewRepository = "false";
                ValueParam originalParam = component.getInitParams().getValueParam(AUTO_CREATE_IN_NEW_REPOSITORY);
                if (originalParam != null) {
                    autoCreateInNewRepository = originalParam.getValue();
                }
                valueParam.setValue(autoCreateInNewRepository);
                templatesPluginInitParams.addParam((Object)valueParam);
            }
            valueParam = new ValueParam();
            valueParam.setName("predefinedScriptsLocation");
            valueParam.setValue(SCRIPTS_LOCATION);
            templatesPluginInitParams.addParam((Object)valueParam);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ManageableRepository repository = repositoryService.getDefaultRepository();
            String defaumtRepositoryName = repository.getConfiguration().getName();
            valueParam = new ValueParam();
            valueParam.setName("repository");
            valueParam.setValue(defaumtRepositoryName);
            templatesPluginInitParams.addParam((Object)valueParam);
            componentPluginsList.add(templatesComponentPlugin);
            ResourceConfig resourceConfig = new ResourceConfig();
            ArrayList<ResourceConfig.Resource> resources = new ArrayList<ResourceConfig.Resource>();
            resourceConfig.setRessources(resources);
            ObjectParameter objectParam = new ObjectParameter();
            objectParam.setName("predefined.scripts");
            objectParam.setObject((Object)resourceConfig);
            templatesPluginInitParams.addParam((Object)objectParam);
            ScriptService scriptService = (ScriptService)container.getComponentInstanceOfType(ScriptService.class);
            SessionProvider systemSessionProvider = SessionProvider.createSystemProvider();
            Node cbScriptHome = scriptService.getCBScriptHome(defaumtRepositoryName, systemSessionProvider);
            if (cbScriptHome.hasNodes()) {
                this.generateScriptsConfiguration(zos, (List<ResourceConfig.Resource>)resources, (Iterator<?>)cbScriptHome.getNodes());
            }
            List ecmActionScripts = scriptService.getECMActionScripts(defaumtRepositoryName, systemSessionProvider);
            this.generateScriptsConfiguration(zos, resources, ecmActionScripts.iterator());
            List ecmInterceptorScripts = scriptService.getECMInterceptorScripts(defaumtRepositoryName, systemSessionProvider);
            this.generateScriptsConfiguration(zos, resources, ecmInterceptorScripts.iterator());
            List ecmWidgetScripts = scriptService.getECMWidgetScripts(defaumtRepositoryName, systemSessionProvider);
            this.generateScriptsConfiguration(zos, resources, ecmWidgetScripts.iterator());
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            zos.putNextEntry(new ZipEntry(component.getKey() + ".xml"));
            zos.write(this.toXML(configuration));
            zos.closeEntry();
            zos.close();
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.ZIP);
            entry.setContent(out.toByteArray());
            ComponentHandler.Entry entry2 = entry;
            return entry2;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            ComponentHandler.Entry entry = null;
            return entry;
        }
        finally {
            if (dmsWorkspaceSession != null) {
                dmsWorkspaceSession.logout();
            }
        }
    }

    private void generateScriptsConfiguration(ZipOutputStream zos, List<ResourceConfig.Resource> resources, Iterator<?> scriptsNodeIterator) throws RepositoryException, ValueFormatException, PathNotFoundException, IOException {
        while (scriptsNodeIterator.hasNext()) {
            Node templateNode = (Node)scriptsNodeIterator.next();
            ResourceConfig.Resource resource = new ResourceConfig.Resource();
            String resourcePath = templateNode.getPath().replace("/exo:ecm/scripts/", "");
            resource.setName(resourcePath);
            resources.add(resource);
            String scriptData = templateNode.getProperty("jcr:data").getString();
            zos.putNextEntry(new ZipEntry(SCRIPTS_LOCATION + resourcePath));
            zos.write(scriptData.getBytes());
            zos.closeEntry();
        }
    }

    private List<ComponentPlugin> cleanComponentPlugins(Component component) {
        List componentPluginsList = component.getComponentPlugins();
        int i = 0;
        while (i < componentPluginsList.size()) {
            ComponentPlugin componentPlugin = (ComponentPlugin)componentPluginsList.get(i);
            if (componentPlugin.getType().equals(ScriptPlugin.class.getName())) {
                componentPluginsList.remove(i);
                continue;
            }
            ++i;
        }
        return componentPluginsList;
    }
}

