/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.aio.handler.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplateConfig;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeTemplateHandler
extends ComponentHandler {
    private static final String AUTO_CREATE_IN_NEW_REPOSITORY = "autoCreateInNewRepository";
    private static final String GTMPL_EXTENSION = ".gtmpl";
    private static final String TEMPLATES_NODETYPE_LOCATION = "nodetype-templates";
    private static final String CSS_EXTENSION = ".css";
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public NodeTypeTemplateHandler() {
        super.setTargetComponentName(TemplateService.class.getName());
    }

    public ComponentHandler.Entry invoke(Component component, ExoContainer container) {
        try {
            ValueParam valueParam;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(out);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Handler invoked for component: " + component.getKey()));
            }
            TemplateService templateService = (TemplateService)container.getComponentInstanceOfType(TemplateService.class);
            List componentPluginsList = this.cleanComponentPlugins(component, TemplatePlugin.class);
            ComponentPlugin templatesComponentPlugin = new ComponentPlugin();
            templatesComponentPlugin.setName("addTemplates");
            templatesComponentPlugin.setSetMethod("addTemplates");
            templatesComponentPlugin.setType(TemplatePlugin.class.getName());
            InitParams templatesPluginInitParams = new InitParams();
            templatesComponentPlugin.setInitParams(templatesPluginInitParams);
            if (component.getInitParams() != null) {
                valueParam = new ValueParam();
                valueParam.setName(AUTO_CREATE_IN_NEW_REPOSITORY);
                String autoCreateInNewRepository = "false";
                ValueParam originalParam = component.getInitParams().getValueParam(AUTO_CREATE_IN_NEW_REPOSITORY);
                if (originalParam != null) {
                    autoCreateInNewRepository = originalParam.getValue();
                }
                valueParam.setValue(autoCreateInNewRepository);
                templatesPluginInitParams.addParam((Object)valueParam);
            }
            valueParam = new ValueParam();
            valueParam.setName("storedLocation");
            valueParam.setValue(TEMPLATES_NODETYPE_LOCATION);
            templatesPluginInitParams.addParam((Object)valueParam);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            String repositoryName = repositoryService.getDefaultRepository().getConfiguration().getName();
            valueParam = new ValueParam();
            valueParam.setName("repository");
            valueParam.setValue(repositoryName);
            templatesPluginInitParams.addParam((Object)valueParam);
            componentPluginsList.add(templatesComponentPlugin);
            TemplateConfig templateConfig = new TemplateConfig();
            ArrayList<TemplateConfig.NodeType> documentTypeList = new ArrayList<TemplateConfig.NodeType>();
            templateConfig.setNodeTypes(documentTypeList);
            ExtendedNodeTypeManager ntManager = repositoryService.getDefaultRepository().getNodeTypeManager();
            NodeTypeIterator nodeTypeIter = ntManager.getAllNodeTypes();
            List documentTypeTemplateNames = templateService.getAllDocumentNodeTypes(repositoryName);
            SessionProvider systemSessionProvider = SessionProvider.createSystemProvider();
            while (nodeTypeIter.hasNext()) {
                NodeType nodeType = nodeTypeIter.nextNodeType();
                boolean isManagedNodeType = templateService.isManagedNodeType(nodeType.getName(), repositoryName);
                if (!isManagedNodeType) continue;
                TemplateConfig.NodeType nodeTypeTemplates = new TemplateConfig.NodeType();
                documentTypeList.add(nodeTypeTemplates);
                nodeTypeTemplates.setLabel(templateService.getTemplateLabel(nodeType.getName(), repositoryName));
                nodeTypeTemplates.setNodetypeName(nodeType.getName());
                nodeTypeTemplates.setDocumentTemplate(documentTypeTemplateNames.contains(nodeType.getName()));
                NodeIterator dialogsNodeIterator = templateService.getAllTemplatesOfNodeType(true, nodeType.getName(), repositoryName, systemSessionProvider);
                List<TemplateConfig.Template> dialogs = this.generateDialogTemplates(zos, nodeType, dialogsNodeIterator);
                nodeTypeTemplates.setReferencedDialog(dialogs);
                NodeIterator viewsNodeIterator = templateService.getAllTemplatesOfNodeType(false, nodeType.getName(), repositoryName, systemSessionProvider);
                List<TemplateConfig.Template> views = this.generateViewTemplate(zos, nodeType, viewsNodeIterator);
                nodeTypeTemplates.setReferencedView(views);
                Node nodeTypeNode = templateService.getTemplatesHome(repositoryName, systemSessionProvider).getNode(nodeType.getName());
                if (!nodeTypeNode.hasNode(TemplateService.SKINS)) continue;
                NodeIterator skinsNodeIterator = nodeTypeNode.getNode(TemplateService.SKINS).getNodes();
                List<TemplateConfig.Template> skins = this.generateSkinTemplate(zos, nodeType, skinsNodeIterator);
                nodeTypeTemplates.setReferencedSkin(skins);
            }
            ObjectParameter objectParam = new ObjectParameter();
            objectParam.setName("template.configuration");
            objectParam.setObject((Object)templateConfig);
            templatesPluginInitParams.addParam((Object)objectParam);
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            zos.putNextEntry(new ZipEntry(component.getKey() + ".xml"));
            zos.write(this.toXML(configuration));
            zos.closeEntry();
            zos.close();
            ComponentHandler.Entry entry = new ComponentHandler.Entry(component.getKey());
            entry.setType(ComponentHandler.EntryType.ZIP);
            entry.setContent(out.toByteArray());
            return entry;
        }
        catch (Exception ie) {
            this.log.error((Object)("Error while invoking handler for component: " + component.getKey()), (Throwable)ie);
            return null;
        }
    }

    private List<TemplateConfig.Template> generateSkinTemplate(ZipOutputStream zos, NodeType nodeType, NodeIterator skinsNodeIterator) throws RepositoryException, ValueFormatException, PathNotFoundException, IOException {
        ArrayList<TemplateConfig.Template> skins = new ArrayList<TemplateConfig.Template>();
        while (skinsNodeIterator.hasNext()) {
            Node templateNode = skinsNodeIterator.nextNode();
            TemplateConfig.Template skinTemplate = new TemplateConfig.Template();
            String templateLocation = "/" + nodeType.getName() + "/" + TemplateService.SKINS + "/" + templateNode.getName();
            skinTemplate.setTemplateFile(templateLocation);
            Value[] values = templateNode.getProperty(TemplateService.EXO_ROLES_PROP).getValues();
            String roles = "";
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                roles = roles + value.getString();
                if (i >= values.length - 1) continue;
                roles = roles + ",";
            }
            skinTemplate.setRoles(roles);
            skins.add(skinTemplate);
            String template = templateNode.getProperty(TemplateService.EXO_TEMPLATE_FILE_PROP).getString();
            zos.putNextEntry(new ZipEntry(TEMPLATES_NODETYPE_LOCATION + templateLocation + CSS_EXTENSION));
            zos.write(template.getBytes());
            zos.closeEntry();
        }
        return skins;
    }

    private List<TemplateConfig.Template> generateViewTemplate(ZipOutputStream zos, NodeType nodeType, NodeIterator viewsNodeIterator) throws RepositoryException, ValueFormatException, PathNotFoundException, IOException {
        ArrayList<TemplateConfig.Template> views = new ArrayList<TemplateConfig.Template>();
        while (viewsNodeIterator.hasNext()) {
            Node templateNode = viewsNodeIterator.nextNode();
            TemplateConfig.Template viewTemplate = new TemplateConfig.Template();
            String templateLocation = "/" + nodeType.getName() + "/" + TemplateService.VIEWS + "/" + templateNode.getName();
            viewTemplate.setTemplateFile(templateLocation);
            Value[] values = templateNode.getProperty(TemplateService.EXO_ROLES_PROP).getValues();
            String roles = "";
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                roles = roles + value.getString();
                if (i >= values.length - 1) continue;
                roles = roles + ",";
            }
            viewTemplate.setRoles(roles);
            views.add(viewTemplate);
            String template = templateNode.getProperty(TemplateService.EXO_TEMPLATE_FILE_PROP).getString();
            zos.putNextEntry(new ZipEntry(TEMPLATES_NODETYPE_LOCATION + templateLocation + GTMPL_EXTENSION));
            zos.write(template.getBytes());
            zos.closeEntry();
        }
        return views;
    }

    private List<TemplateConfig.Template> generateDialogTemplates(ZipOutputStream zos, NodeType nodeType, NodeIterator dialogsNodeIterator) throws RepositoryException, ValueFormatException, PathNotFoundException, IOException {
        ArrayList<TemplateConfig.Template> dialogs = new ArrayList<TemplateConfig.Template>();
        while (dialogsNodeIterator.hasNext()) {
            Node templateNode = dialogsNodeIterator.nextNode();
            TemplateConfig.Template dialogTemplate = new TemplateConfig.Template();
            String templateLocation = "/" + nodeType.getName() + "/" + TemplateService.DIALOGS + "/" + templateNode.getName();
            dialogTemplate.setTemplateFile(templateLocation);
            Value[] values = templateNode.getProperty(TemplateService.EXO_ROLES_PROP).getValues();
            String roles = "";
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                roles = roles + value.getString();
                if (i >= values.length - 1) continue;
                roles = roles + ",";
            }
            dialogTemplate.setRoles(roles);
            dialogs.add(dialogTemplate);
            String template = templateNode.getProperty(TemplateService.EXO_TEMPLATE_FILE_PROP).getString();
            zos.putNextEntry(new ZipEntry(TEMPLATES_NODETYPE_LOCATION + templateLocation + GTMPL_EXTENSION));
            zos.write(template.getBytes());
            zos.closeEntry();
        }
        return dialogs;
    }
}

