/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.plf.rest;

import java.io.ByteArrayInputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.platform.migration.common.component.MarshallConfigurationService;
import org.exoplatform.platform.migration.common.handler.ComponentHandler;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/containersConfiguration")
public class MarshallConfigurationREST
implements ResourceContainer {
    private MarshallConfigurationService marshallConfigurationService;
    private Log log = ExoLogger.getLogger(this.getClass());

    public MarshallConfigurationREST(MarshallConfigurationService marshallConfigurationService) {
        this.marshallConfigurationService = marshallConfigurationService;
    }

    @GET
    @Produces(value={"text/html"})
    public Response containersList() {
        String htmlContainersLink;
        this.log.info((Object)("Starting: " + this.getClass().getName()));
        this.log.info((Object)"The Marshaller is ready for use ..");
        try {
            htmlContainersLink = this.marshallConfigurationService.generateHTMLContainersList();
        }
        catch (Exception e) {
            this.log.error((Object)"Error while generating containers list", (Throwable)e);
            return null;
        }
        return Response.ok().entity((Object)htmlContainersLink).build();
    }

    @GET
    @Path(value="/ComponentsList/")
    @Produces(value={"text/html"})
    public Response componentsList(@QueryParam(value="containerId") String containerId) {
        String htmlComponentsLink;
        try {
            htmlComponentsLink = this.marshallConfigurationService.generateHTMLComponentsList(containerId);
        }
        catch (Exception e) {
            this.log.error((Object)("Error while generating components list for container: " + containerId), (Throwable)e);
            return null;
        }
        return Response.ok().entity((Object)htmlComponentsLink).build();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="/getComponentConfiguration/")
    public Response getComponentConfiguration(@QueryParam(value="containerId") String containerId, @QueryParam(value="componentKey") String componentKey) {
        ComponentHandler.Entry configurationEntry;
        try {
            configurationEntry = this.marshallConfigurationService.getComponentConfiguration(containerId, componentKey);
        }
        catch (Exception e) {
            this.log.error((Object)("Error while generating component configuration for component: " + componentKey), (Throwable)e);
            return null;
        }
        Response.ResponseBuilder builder = Response.ok();
        if (configurationEntry.getType().equals((Object)ComponentHandler.EntryType.ZIP)) {
            builder.header("Content-disposition", (Object)("attachment; filename=" + configurationEntry.getComponentName() + configurationEntry.getType()));
        }
        return builder.entity((Object)new ByteArrayInputStream(configurationEntry.getContent())).build();
    }

    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="/exportContainerComponents/")
    public Response getAllComponentsConfiguration(@QueryParam(value="containerId") String containerId) {
        ComponentHandler.Entry configurationEntry;
        try {
            configurationEntry = this.marshallConfigurationService.getAllComponentsConfiguration(containerId);
        }
        catch (Exception e) {
            this.log.error((Object)("Error while generating all configurations for container: " + containerId), (Throwable)e);
            return null;
        }
        Response.ResponseBuilder builder = Response.ok();
        builder.header("Content-disposition", (Object)("attachment; filename=" + configurationEntry.getComponentName() + configurationEntry.getType()));
        return builder.entity((Object)new ByteArrayInputStream(configurationEntry.getContent())).build();
    }
}

