/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.plf.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.platform.migration.common.aio.object.Application;
import org.exoplatform.platform.migration.common.aio.object.Gadgets;
import org.exoplatform.platform.migration.common.aio.object.Page;
import org.exoplatform.platform.migration.common.aio.object.PageNavigation;
import org.exoplatform.platform.migration.common.aio.object.PortletPreferences;
import org.exoplatform.platform.migration.common.aio.object.Preference;
import org.exoplatform.platform.migration.common.component.ContainerParamExtractor;
import org.exoplatform.platform.migration.plf.object.Container;
import org.exoplatform.platform.migration.plf.object.Page;
import org.exoplatform.platform.migration.plf.object.PortalConfig;
import org.exoplatform.platform.migration.plf.object.Portlet;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/userPortalConfigurationConvertor")
public class UserPortalConfigurationConvertorREST
implements ResourceContainer {
    private ContainerParamExtractor containerParamExtractor_ = null;
    private Log log = ExoLogger.getLogger(this.getClass());
    private static final Map<String, Class<?>> unmarshelledObjectTypes = new HashMap();

    @GET
    @Produces(value={"text/html"})
    public Response importProfiles() {
        this.log.info((Object)("Starting: " + this.getClass().getName()));
        this.log.info((Object)"The UserPortalConfigurationConvertor is ready for use ..");
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.containerParamExtractor_ = (ContainerParamExtractor)container.getComponentInstanceOfType(ContainerParamExtractor.class);
        String containerId = this.containerParamExtractor_.getContainerId(container);
        String containerRestContextName = this.containerParamExtractor_.getContainerRestContext(container);
        StringBuffer responseStringBuffer = new StringBuffer();
        responseStringBuffer.append("<html><body><form action='/" + containerId + "/" + containerRestContextName + "/userPortalConfigurationConvertor/convert/' enctype='application/x-www-form-urlencoded' method='POST'>");
        responseStringBuffer.append("  <input type='text' name='filePath'/>");
        responseStringBuffer.append("  <input type='submit'/>");
        responseStringBuffer.append("</form></body></html>");
        return Response.ok().entity((Object)responseStringBuffer.toString()).build();
    }

    @POST
    @Path(value="/convert/")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response convert(@FormParam(value="filePath") String filePath) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            HashMap<String, Map<String, Map<String, Object>>> unmarshelledUserPortalConfigurations = new HashMap<String, Map<String, Map<String, Object>>>(3);
            FileInputStream fin = new FileInputStream(filePath);
            ZipInputStream zin = new ZipInputStream(fin);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                String[] entries = ze.getName().split("/");
                String ownerType = entries[0];
                String entryFileName = entries[entries.length - 1];
                Class<?> fileTypeToObjectClassType = unmarshelledObjectTypes.get(entryFileName);
                if (fileTypeToObjectClassType == null) continue;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 1; i < entries.length - 1; ++i) {
                    if (i != 1) {
                        stringBuffer.append("/");
                    }
                    stringBuffer.append(entries[i]);
                }
                String ownerId = stringBuffer.toString();
                Object unmarshelledObject = this.fromXML(this.readEntry(zin), fileTypeToObjectClassType);
                this.addUserPortalConfiguration(unmarshelledObject, unmarshelledUserPortalConfigurations, ownerType, ownerId, entryFileName);
            }
            zin.close();
            ZipOutputStream zos = new ZipOutputStream(result);
            for (Map.Entry portalConfigEntry : unmarshelledUserPortalConfigurations.entrySet()) {
                String ownerType = (String)portalConfigEntry.getKey();
                Map ownersConfigurationObjects = (Map)portalConfigEntry.getValue();
                for (Map.Entry ownerEntry : ownersConfigurationObjects.entrySet()) {
                    String ownerId = (String)ownerEntry.getKey();
                    String portalConfigForlder = ownerType + "/" + ownerId + "/";
                    Map ownerObjects = (Map)ownerEntry.getValue();
                    Page.PageSet pageSet = (Page.PageSet)ownerObjects.get("pages.xml");
                    PortletPreferences.PortletPreferencesSet portletPreferencesSet = (PortletPreferences.PortletPreferencesSet)ownerObjects.get("portlet-preferences.xml");
                    Page.PageSet convertedPageSet = this.convertPageSet(pageSet, portletPreferencesSet);
                    this.putEntry(zos, portalConfigForlder + "pages.xml", convertedPageSet);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Converting from zip entry: pages.xml & portlet-preferences.xml");
                    }
                    if ("portal".equals(ownerType)) {
                        org.exoplatform.platform.migration.common.aio.object.PortalConfig portalConfig = (org.exoplatform.platform.migration.common.aio.object.PortalConfig)ownerObjects.get("portal.xml");
                        PortalConfig convertedPortalConfig = this.convertPortalConfig(portalConfig, portletPreferencesSet);
                        this.putEntry(zos, portalConfigForlder + "portal.xml", (Object)convertedPortalConfig);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"Converting from zip entry: portal.xml");
                        }
                    }
                    PageNavigation pageNavigation = (PageNavigation)ownerObjects.get("navigation.xml");
                    org.exoplatform.portal.config.model.PageNavigation convertedPageNavigation = this.convertNavigation(pageNavigation);
                    this.putEntry(zos, portalConfigForlder + "navigation.xml", convertedPageNavigation);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)"Converting from zip entry: navigation.xml");
                }
            }
            zos.close();
        }
        catch (Exception e) {
            this.log.error((Object)"Error while converting portalConfiguration meta data ..", (Throwable)e);
        }
        return Response.ok().header("Content-disposition", (Object)"attachment; filename=ConvertedUserPortalConfigurationServiceFiles.zip").entity((Object)new ByteArrayInputStream(result.toByteArray())).build();
    }

    private org.exoplatform.portal.config.model.PageNavigation convertNavigation(PageNavigation pageNavigation) {
        org.exoplatform.portal.config.model.PageNavigation convertedPageNavigation = new org.exoplatform.portal.config.model.PageNavigation();
        convertedPageNavigation.setModifiable(true);
        convertedPageNavigation.setOwnerId(pageNavigation.getOwnerId());
        convertedPageNavigation.setOwnerType(pageNavigation.getOwnerType());
        convertedPageNavigation.setPriority(pageNavigation.getPriority());
        ArrayList<PageNode> convertedPageNodes = this.convertPageNodes(pageNavigation.getNodes());
        convertedPageNavigation.setNodes(convertedPageNodes);
        return convertedPageNavigation;
    }

    private ArrayList<PageNode> convertPageNodes(List<org.exoplatform.platform.migration.common.aio.object.PageNode> pageNodes) {
        if (pageNodes == null || pageNodes.size() == 0) {
            return null;
        }
        ArrayList<PageNode> convertedPageNodes = new ArrayList<PageNode>();
        for (org.exoplatform.platform.migration.common.aio.object.PageNode pageNode : pageNodes) {
            PageNode convertedPageNode = new PageNode();
            convertedPageNode.setChildren(this.convertPageNodes(pageNode.getChildren()));
            convertedPageNode.setModifiable(true);
            convertedPageNode.setEndPublicationDate(pageNode.getEndPublicationDate());
            convertedPageNode.setStartPublicationDate(pageNode.getStartPublicationDate());
            convertedPageNode.setIcon(pageNode.getIcon());
            convertedPageNode.setLabel(pageNode.getLabel());
            convertedPageNode.setName(pageNode.getName());
            convertedPageNode.setPageReference(pageNode.getPageReference());
            convertedPageNode.setUri(pageNode.getUri());
            convertedPageNode.setVisibility(pageNode.getVisible() ? Visibility.DISPLAYED : Visibility.HIDDEN);
            convertedPageNodes.add(convertedPageNode);
        }
        return convertedPageNodes;
    }

    private Page.PageSet convertPageSet(Page.PageSet pageSet, PortletPreferences.PortletPreferencesSet portletPreferencesSet) {
        Page.PageSet convertedPageSet = new Page.PageSet();
        ArrayList<Page> convertedPages = new ArrayList<Page>();
        ArrayList pages = pageSet.getPages();
        for (org.exoplatform.platform.migration.common.aio.object.Page page : pages) {
            Page convertedPage = new Page();
            convertedPage.setModifiable(true);
            convertedPage.setAccessPermissions(page.getAccessPermissions());
            convertedPage.setDecorator(page.getDecorator());
            convertedPage.setDescription(page.getDescription());
            convertedPage.setEditPermission(page.getEditPermission());
            convertedPage.setFactoryId(page.getFactoryId());
            convertedPage.setHeight(page.getHeight());
            convertedPage.setIcon(page.getIcon());
            convertedPage.setId(page.getId());
            convertedPage.setName(page.getName());
            convertedPage.setShowMaxWindow(page.isShowMaxWindow());
            convertedPage.setTitle(page.getTitle());
            convertedPage.setTemplate(page.getTemplate());
            convertedPage.setWidth(page.getWidth());
            convertedPages.add(convertedPage);
            ArrayList children = page.getChildren();
            convertedPage.setChildren(this.convertUIComponents(children, portletPreferencesSet, page.getAccessPermissions()));
        }
        convertedPageSet.setPages(convertedPages);
        return convertedPageSet;
    }

    private ArrayList<ModelObject> convertUIComponents(List<?> children, PortletPreferences.PortletPreferencesSet portletPreferencesSet, String[] accessPermissions) {
        if (children == null || children.size() == 0) {
            return null;
        }
        ArrayList<ModelObject> convertedPageChildren = new ArrayList<ModelObject>();
        for (Object child : children) {
            if (child instanceof org.exoplatform.platform.migration.common.aio.object.Container) {
                org.exoplatform.platform.migration.common.aio.object.Container container = (org.exoplatform.platform.migration.common.aio.object.Container)child;
                Container convertedContainer = new Container();
                convertedContainer.setAccessPermissions(accessPermissions);
                convertedContainer.setChildren(this.convertUIComponents(container.getChildren(), portletPreferencesSet, accessPermissions));
                convertedContainer.setDecorator(container.getDecorator());
                convertedContainer.setDescription(container.getDescription());
                convertedContainer.setFactoryId(container.getFactoryId());
                convertedContainer.setHeight(container.getHeight());
                convertedContainer.setIcon(container.getHeight());
                convertedContainer.setId(container.getId());
                convertedContainer.setName(container.getName());
                convertedContainer.setTemplate(container.getTemplate());
                convertedContainer.setTitle(container.getTitle());
                convertedContainer.setWidth(container.getWidth());
                convertedPageChildren.add(convertedContainer);
                continue;
            }
            if (child instanceof Application) {
                Application application = (Application)child;
                org.exoplatform.platform.migration.plf.object.Application convertedApplication = new org.exoplatform.platform.migration.plf.object.Application();
                convertedApplication.setModifiable(true);
                convertedApplication.setAccessPermissions(accessPermissions);
                convertedApplication.setDescription(application.getDescription());
                convertedApplication.setHeight(application.getHeight());
                convertedApplication.setIcon(application.getIcon());
                convertedApplication.setId(application.getId());
                if (application.getProperties() != null && application.getProperties().size() > 0) {
                    convertedApplication.setProperties(application.getProperties());
                }
                convertedApplication.setShowApplicationMode(application.isShowApplicationMode());
                convertedApplication.setShowApplicationState(application.isShowApplicationState());
                convertedApplication.setShowInfoBar(application.isShowInfoBar());
                convertedApplication.setTheme(application.getTheme());
                convertedApplication.setTitle(application.getTitle());
                convertedApplication.setWidth(application.getWidth());
                if (application.getInstanceId() == null || application.getInstanceId().length() == 0) continue;
                org.exoplatform.platform.migration.plf.object.PortletPreferences portletPreferences = this.getPortletPreferences(portletPreferencesSet, application.getInstanceId());
                String[] intanceNames = application.getInstanceId().split(":")[1].split("/");
                Portlet portlet = new Portlet(intanceNames[1], intanceNames[2]);
                portlet.setPreferences(portletPreferences);
                convertedApplication.setPortlet(portlet);
                convertedPageChildren.add(convertedApplication);
                continue;
            }
            if (!(child instanceof org.exoplatform.platform.migration.common.aio.object.PageBody)) continue;
            PageBody pageBody = new PageBody();
            convertedPageChildren.add((ModelObject)pageBody);
        }
        return convertedPageChildren;
    }

    private org.exoplatform.platform.migration.plf.object.PortletPreferences getPortletPreferences(PortletPreferences.PortletPreferencesSet portletPreferencesSet, String instanceId) {
        for (PortletPreferences portlet : portletPreferencesSet.getPortlets()) {
            if (!portlet.getWindowId().equals(instanceId)) continue;
            org.exoplatform.platform.migration.plf.object.PortletPreferences convertedPortletPreferences = new org.exoplatform.platform.migration.plf.object.PortletPreferences();
            for (Object object : portlet.getPreferences()) {
                Preference preference = (Preference)object;
                if (preference.getValues() == null || preference.getValues().size() == 0 || preference.getValues().get(0) == null || preference.getValues().get(0).equals("")) continue;
                org.exoplatform.platform.migration.plf.object.Preference convertedPreference = new org.exoplatform.platform.migration.plf.object.Preference();
                convertedPreference.setName(preference.getName());
                convertedPreference.setValues(preference.getValues());
                convertedPreference.setReadOnly(preference.isReadOnly());
                convertedPortletPreferences.setPreference(convertedPreference);
            }
            return convertedPortletPreferences;
        }
        return null;
    }

    private PortalConfig convertPortalConfig(org.exoplatform.platform.migration.common.aio.object.PortalConfig portalConfig, PortletPreferences.PortletPreferencesSet portletPreferencesSet) {
        PortalConfig convertedPortalConfig = new PortalConfig();
        convertedPortalConfig.setAccessPermissions(portalConfig.getAccessPermissions());
        convertedPortalConfig.setEditPermission(portalConfig.getEditPermission());
        convertedPortalConfig.setLocale(portalConfig.getLocale());
        convertedPortalConfig.setModifiable(true);
        convertedPortalConfig.setName(portalConfig.getName());
        convertedPortalConfig.setSessionAlive("onDemand");
        convertedPortalConfig.setSkin(portalConfig.getSkin());
        convertedPortalConfig.setType("portal");
        org.exoplatform.platform.migration.common.aio.object.Container portalLayoutContainer = portalConfig.getPortalLayout();
        List<org.exoplatform.platform.migration.common.aio.object.Container> uiCompomponents = Collections.singletonList(portalLayoutContainer);
        ArrayList<ModelObject> convertedPortalLayout = this.convertUIComponents(uiCompomponents, portletPreferencesSet, portalConfig.getAccessPermissions());
        assert (convertedPortalLayout != null && convertedPortalLayout.size() == 1);
        convertedPortalConfig.setPortalLayout((Container)convertedPortalLayout.get(0));
        return convertedPortalConfig;
    }

    private void putEntry(ZipOutputStream zos, String filePath, Object objectToMarshall) throws Exception {
        zos.putNextEntry(new ZipEntry(filePath));
        byte[] bytes = this.toXML(objectToMarshall);
        zos.write(bytes);
        zos.closeEntry();
    }

    private void addUserPortalConfiguration(Object unmarshelledObject, Map<String, Map<String, Map<String, Object>>> userPortalConfigurations, String ownerType, String ownerId, String fileNameType) {
        Map<String, Object> portalConfigObjects = null;
        if (userPortalConfigurations.get(ownerType) == null) {
            HashMap<String, Map<String, Object>> portalsConfig = new HashMap<String, Map<String, Object>>();
            userPortalConfigurations.put(ownerType, portalsConfig);
            portalConfigObjects = new HashMap<String, Object>();
            portalsConfig.put(ownerId, portalConfigObjects);
        } else {
            Map<String, Map<String, Object>> portalsConfig = userPortalConfigurations.get(ownerType);
            portalConfigObjects = portalsConfig.get(ownerId);
            if (portalConfigObjects == null) {
                portalConfigObjects = new HashMap<String, Object>();
                portalsConfig.put(ownerId, portalConfigObjects);
            }
        }
        portalConfigObjects.put(fileNameType, unmarshelledObject);
    }

    private byte[] readEntry(ZipInputStream zin) {
        try {
            ByteArrayOutputStream fout = new ByteArrayOutputStream();
            int c = zin.read();
            while (c != -1) {
                fout.write(c);
                c = zin.read();
            }
            zin.closeEntry();
            return fout.toByteArray();
        }
        catch (IOException e) {
            this.log.error((Object)"Error while reading entry from ZipInputStream ..", (Throwable)e);
            return null;
        }
    }

    protected byte[] toXML(Object obj) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(obj.getClass());
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument(obj, "UTF-8", null, (OutputStream)out);
            return out.toByteArray();
        }
        catch (Exception ie) {
            this.log.error((Object)"Error while converting to XML object ..", (Throwable)ie);
            return null;
        }
    }

    private <T> T fromXML(byte[] bytes, Class<T> clazz) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(clazz);
            UnmarshallingContext uctx = (UnmarshallingContext)bfact.createUnmarshallingContext();
            uctx.setDocument((InputStream)is, null, "UTF-8", false);
            return clazz.cast(uctx.unmarshalElement());
        }
        catch (Exception e) {
            this.log.error((Object)"Error while reading from XML object ..", (Throwable)e);
            return null;
        }
    }

    static {
        unmarshelledObjectTypes.put("portal.xml", org.exoplatform.platform.migration.common.aio.object.PortalConfig.class);
        unmarshelledObjectTypes.put("pages.xml", Page.PageSet.class);
        unmarshelledObjectTypes.put("navigation.xml", PageNavigation.class);
        unmarshelledObjectTypes.put("gadgets.xml", Gadgets.class);
        unmarshelledObjectTypes.put("portlet-preferences.xml", PortletPreferences.PortletPreferencesSet.class);
    }
}

