/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.plf.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.platform.migration.common.component.ContainerParamExtractor;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/userProfiles")
public class UserProfileImporterREST
implements ResourceContainer {
    public OrganizationService organizationService = null;
    private ContainerParamExtractor containerParamExtractor_ = null;
    private Log log = ExoLogger.getLogger(this.getClass());

    public UserProfileImporterREST(OrganizationService organizationService, InitParams initParams) {
        this.organizationService = organizationService;
    }

    @GET
    public Response importProfiles() {
        this.log.info((Object)("Starting: " + this.getClass().getName()));
        this.log.info((Object)"The UserProfileImporter is ready for use ..");
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.containerParamExtractor_ = (ContainerParamExtractor)container.getComponentInstanceOfType(ContainerParamExtractor.class);
        String containerId = this.containerParamExtractor_.getContainerId(container);
        String containerRestContextName = this.containerParamExtractor_.getContainerRestContext(container);
        StringBuffer responseStringBuffer = new StringBuffer();
        responseStringBuffer.append("<form action='/" + containerId + "/" + containerRestContextName + "/userProfiles/import/' method='POST'>");
        responseStringBuffer.append("  <input type='text' name='filePath'/>");
        responseStringBuffer.append("  <input type='submit'/>");
        responseStringBuffer.append("</form>");
        return Response.ok().entity((Object)responseStringBuffer.toString()).build();
    }

    @POST
    @Path(value="/import/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response put(@FormParam(value="filePath") String filePath) {
        try {
            XStream xstreamProfile_ = new XStream((HierarchicalStreamDriver)new XppDriver());
            xstreamProfile_.alias("user-profile", UserProfileImpl.class);
            XStream xstreamUser_ = new XStream((HierarchicalStreamDriver)new XppDriver());
            xstreamUser_.alias("user", UserImpl.class);
            FileInputStream fin = new FileInputStream(filePath);
            ZipInputStream zin = new ZipInputStream(fin);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                User user;
                ByteArrayOutputStream fout;
                if (ze.getName().contains("_profile.xml")) {
                    fout = new ByteArrayOutputStream();
                    int c = zin.read();
                    while (c != -1) {
                        fout.write(c);
                        c = zin.read();
                    }
                    zin.closeEntry();
                    UserProfileImpl userProfile = (UserProfileImpl)xstreamProfile_.fromXML(new String(fout.toByteArray()));
                    user = this.organizationService.getUserHandler().findUserByName(userProfile.getUserName());
                    if (user != null) {
                        this.organizationService.getUserProfileHandler().saveUserProfile((UserProfile)userProfile, true);
                        continue;
                    }
                    this.log.warn((Object)("userProfile = " + userProfile.getUserName() + " doesn't exist"));
                    continue;
                }
                if (!ze.getName().contains("_user.xml")) continue;
                fout = new ByteArrayOutputStream();
                int c = zin.read();
                while (c != -1) {
                    fout.write(c);
                    c = zin.read();
                }
                zin.closeEntry();
                UserImpl userImported = (UserImpl)xstreamUser_.fromXML(new String(fout.toByteArray()));
                user = this.organizationService.getUserHandler().findUserByName(userImported.getUserName());
                if (user != null) {
                    user.setLastLoginTime(userImported.getLastLoginTime());
                    user.setCreatedDate(userImported.getCreatedDate());
                    this.organizationService.getUserHandler().saveUser(user, false);
                    continue;
                }
                this.log.warn((Object)("user = " + userImported.getUserName() + " doesn't exist"));
            }
            zin.close();
            return Response.ok().entity((Object)"Imported successfully !").build();
        }
        catch (Exception e) {
            this.log.error((Object)"Can not import users profile .. ", (Throwable)e);
            return Response.ok().entity((Object)"An error occurs while importing users profile !").build();
        }
    }
}

