/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.handlers.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.platform.migration.handlers.ComponentHandler;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.NewPortalConfig;
import org.exoplatform.portal.config.jcr.DataMapper;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPortalConfigHandler
implements ComponentHandler {
    private Log log = ExoLogger.getLogger(this.getClass());
    private static final String PORTAL_DATA = "MainPortalData";
    private static final String USER_DATA = "UserPortalData";
    private static final String GROUP_DATA = "SharedPortalData";
    private static final String PORTAL_CONFIG_FILE_NAME = "portal-xml";
    private static final String NAVIGATION_CONFIG_FILE_NAME = "navigation-xml";
    private static final String EXO_REGISTRY = "exo:registry";
    private static final String EXO_REGISTRYENTRY_NT = "exo:registryEntry";
    private static final String EXO_DATA_TYPE = "exo:dataType";
    private RegistryService regService_;
    private PortalContainer portalContainer;
    private OrganizationService organizationService;
    private DataMapper mapper_ = new DataMapper();

    @Override
    public void invoke(Component component, String rootConfDir) {
        this.portalContainer = PortalContainer.getInstance();
        this.organizationService = (OrganizationService)this.portalContainer.getComponentInstanceOfType(OrganizationService.class);
        this.regService_ = (RegistryService)this.portalContainer.getComponentInstanceOfType(RegistryService.class);
        this.preMarshallComponent(component, rootConfDir);
        Configuration configuration = new Configuration();
        configuration.addComponent((Object)component);
        this.marshall(configuration, rootConfDir + File.separator + "portal" + File.separator + component.getKey() + ".xml");
    }

    private void preMarshallComponent(Component component, String rootConfDir) {
        try {
            PortletPreferences.PortletPreferencesSet portletPreferencesSet;
            PageNavigation navigation;
            Page.PageSet pageSet;
            ArrayList<String> portalNames = this.getPortalNames();
            String portalConfDir = rootConfDir + File.separator + "portal";
            String navigationConfDir = portalConfDir + File.separator + "portal-navigation";
            for (String portalName : portalNames) {
                File confSite = new File(navigationConfDir + File.separator + "portal" + File.separator + portalName);
                confSite.mkdirs();
                PortalConfig portalConfig = this.getPortalConfig(portalName);
                this.marshall(portalConfig, confSite.getPath() + File.separator + "portal.xml");
                pageSet = this.getPages("portal", portalName);
                this.marshall(pageSet, confSite.getPath() + File.separator + "pages.xml");
                navigation = this.getPageNavigation("portal", portalName);
                this.marshall(navigation, confSite.getPath() + File.separator + "navigation.xml");
                portletPreferencesSet = this.getPortletPreferencesSet("portal", portalName);
                this.marshall(portletPreferencesSet, confSite.getPath() + File.separator + "portlet-preferences.xml");
            }
            ArrayList<String> groups = this.getAllGroups();
            for (String group : groups) {
                File confGroup = new File(navigationConfDir + File.separator + "group" + File.separator + group.replace("/", File.separator));
                confGroup.mkdirs();
                pageSet = this.getPages("group", group);
                if (pageSet != null) {
                    this.marshall(pageSet, confGroup.getPath() + File.separator + "pages.xml");
                }
                if ((navigation = this.getPageNavigation("group", group)) != null) {
                    this.marshall(navigation, confGroup.getPath() + File.separator + "navigation.xml");
                }
                if ((portletPreferencesSet = this.getPortletPreferencesSet("group", group)) == null) continue;
                this.marshall(portletPreferencesSet, confGroup.getPath() + File.separator + "portlet-preferences.xml");
            }
            ArrayList<String> allUsers = this.getAllUsers();
            for (String user : allUsers) {
                PortletPreferences.PortletPreferencesSet portletPreferencesSet2;
                Page.PageSet pageSet2;
                File confUser = new File(navigationConfDir + File.separator + "user" + File.separator + user);
                confUser.mkdirs();
                navigation = this.getPageNavigation("user", user);
                if (navigation != null) {
                    this.marshall(navigation, confUser.getPath() + File.separator + "navigation.xml");
                }
                if ((pageSet2 = this.getPages("user", user)) != null) {
                    this.marshall(pageSet2, confUser.getPath() + File.separator + "pages.xml");
                }
                if ((portletPreferencesSet2 = this.getPortletPreferencesSet("user", user)) == null) continue;
                this.marshall(portletPreferencesSet2, confUser.getPath() + File.separator + "portlet-preferences.xml");
            }
            List componentPlugins = component.getComponentPlugins();
            for (ComponentPlugin componentPlugin : componentPlugins) {
                if (!componentPlugin.getName().equals("new.portal.config.user.listener")) continue;
                ObjectParameter objectParameter = componentPlugin.getInitParams().getObjectParam("portal.configuration");
                NewPortalConfig newPortalConfig = (NewPortalConfig)objectParameter.getObject();
                newPortalConfig.setTemplateLocation("portal-navigation");
                objectParameter = componentPlugin.getInitParams().getObjectParam("group.configuration");
                newPortalConfig = (NewPortalConfig)objectParameter.getObject();
                newPortalConfig.setTemplateLocation("portal-navigation");
                objectParameter = componentPlugin.getInitParams().getObjectParam("user.configuration");
                newPortalConfig = (NewPortalConfig)objectParameter.getObject();
                newPortalConfig.setTemplateLocation("portal-navigation");
                break;
            }
        }
        catch (Exception ie) {
            this.log.error((Object)"problem in the preMarshall Process", (Throwable)ie);
        }
    }

    private void marshall(Object obj, String xmlPath) {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(obj.getClass());
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument(obj, "UTF-8", null, (OutputStream)new FileOutputStream(xmlPath));
        }
        catch (Exception ie) {
            this.log.error((Object)"Cannot convert the object to xml", (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page.PageSet getPages(String ownerType, String ownerId) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Page.PageSet pages = null;
        try {
            String registryNodePath = this.regService_.getRegistry(sessionProvider).getNode().getPath();
            String queryString = "select * from exo:registryEntry where jcr:path like '" + registryNodePath + "/" + this.getApplicationRegistryPath(ownerType, ownerId) + "/%'" + " and " + EXO_DATA_TYPE + " like 'Page'";
            Session session = this.regService_.getRegistry(sessionProvider).getNode().getSession();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString, "sql");
            QueryResult result = query.execute();
            NodeIterator itr = result.getNodes();
            while (itr.hasNext()) {
                Node node = itr.nextNode();
                String entryPath = node.getPath().substring(registryNodePath.length() + 1);
                RegistryEntry pageEntry = this.regService_.getEntry(sessionProvider, entryPath);
                Page page = this.mapper_.toPageConfig(pageEntry.getDocument());
                if (pages == null) {
                    pages = new Page.PageSet();
                }
                pages.getPages().add(page);
            }
        }
        catch (Exception ie) {
            this.log.error((Object)"Cannot recovers pages from jcr", (Throwable)ie);
            Page.PageSet pageSet = null;
            return pageSet;
        }
        finally {
            sessionProvider.close();
        }
        sessionProvider.close();
        return pages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortletPreferences.PortletPreferencesSet getPortletPreferencesSet(String ownerType, String ownerId) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        PortletPreferences.PortletPreferencesSet portletPreferencesSet = null;
        try {
            ArrayList<PortletPreferences> portlets = new ArrayList<PortletPreferences>();
            String registryNodePath = this.regService_.getRegistry(sessionProvider).getNode().getPath();
            String queryString = "select * from exo:registryEntry where jcr:path like '" + registryNodePath + "/" + this.getApplicationRegistryPath(ownerType, ownerId) + "/%'" + " and " + EXO_DATA_TYPE + " like 'PortletPreferences'";
            Session session = this.regService_.getRegistry(sessionProvider).getNode().getSession();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString, "sql");
            QueryResult result = query.execute();
            NodeIterator itr = result.getNodes();
            while (itr.hasNext()) {
                Node node = itr.nextNode();
                String entryPath = node.getPath().substring(registryNodePath.length() + 1);
                RegistryEntry pageEntry = this.regService_.getEntry(sessionProvider, entryPath);
                PortletPreferences portletPreferences = this.mapper_.toPortletPreferences(pageEntry.getDocument());
                portlets.add(portletPreferences);
                if (portletPreferencesSet == null) {
                    portletPreferencesSet = new PortletPreferences.PortletPreferencesSet();
                }
                portletPreferencesSet.setPortlets(portlets);
            }
        }
        catch (Exception ie) {
            this.log.error((Object)"Cannot recovers preferences from jcr", (Throwable)ie);
            PortletPreferences.PortletPreferencesSet portletPreferencesSet2 = null;
            return portletPreferencesSet2;
        }
        finally {
            sessionProvider.close();
        }
        return portletPreferencesSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortalConfig getPortalConfig(String portalName) throws Exception {
        RegistryEntry portalEntry;
        String portalPath = this.getApplicationRegistryPath("portal", portalName) + "/" + PORTAL_CONFIG_FILE_NAME;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            portalEntry = this.regService_.getEntry(sessionProvider, portalPath);
        }
        catch (PathNotFoundException ie) {
            PortalConfig portalConfig = null;
            return portalConfig;
        }
        finally {
            sessionProvider.close();
        }
        PortalConfig config = this.mapper_.toPortalConfig(portalEntry.getDocument());
        return config;
    }

    private String getApplicationRegistryPath(String ownerType, String ownerId) {
        String path = "";
        if ("portal".equals(ownerType)) {
            path = "exo:applications/MainPortalData/" + ownerId;
        } else if ("user".equals(ownerType)) {
            path = "exo:users/" + ownerId + "/" + USER_DATA;
        } else if ("group".equals(ownerType)) {
            if (ownerId.charAt(0) != '/') {
                ownerId = "/" + ownerId;
            }
            path = "exo:groups" + ownerId + "/" + GROUP_DATA;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageNavigation getPageNavigation(String ownerType, String id) throws Exception {
        RegistryEntry navigationEntry;
        String navigationPath = this.getApplicationRegistryPath(ownerType, id) + "/" + NAVIGATION_CONFIG_FILE_NAME;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            navigationEntry = this.regService_.getEntry(sessionProvider, navigationPath);
        }
        catch (PathNotFoundException ie) {
            PageNavigation pageNavigation = null;
            return pageNavigation;
        }
        finally {
            sessionProvider.close();
        }
        PageNavigation navigation = this.mapper_.toPageNavigation(navigationEntry.getDocument());
        return navigation;
    }

    private ArrayList<String> getPortalNames() throws RepositoryException {
        ArrayList<String> portalNames = new ArrayList<String>();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Session session = this.regService_.getRegistry(sessionProvider).getNode().getSession();
        Node node = (Node)session.getItem("/exo:registry/exo:applications/MainPortalData");
        NodeIterator nodeIterator = node.getNodes();
        while (nodeIterator.hasNext()) {
            node = nodeIterator.nextNode();
            portalNames.add(node.getName());
        }
        return portalNames;
    }

    private ArrayList<String> getAllGroups() {
        ArrayList<String> allGroups = new ArrayList<String>();
        try {
            PortalContainer portalContainer = PortalContainer.getInstance();
            OrganizationService organizationService = (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
            Collection groups = organizationService.getGroupHandler().getAllGroups();
            for (Group group : groups) {
                allGroups.add(group.getId());
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error when recovering of all groups", (Throwable)e);
            return null;
        }
        return allGroups;
    }

    private ArrayList<String> getAllUsers() {
        ArrayList<String> allUsers = new ArrayList<String>();
        try {
            org.exoplatform.services.organization.Query query = new org.exoplatform.services.organization.Query();
            query.setUserName("*");
            PageList users = this.organizationService.getUserHandler().findUsers(query);
            for (Object o : users.getAll()) {
                String userName = ((User)o).getUserName();
                allUsers.add(userName);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error when recovering of all users", (Throwable)e);
            return null;
        }
        return allUsers;
    }
}

