/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.component.rest;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.platform.migration.handlers.ComponentHandler;
import org.exoplatform.platform.migration.handlers.impl.ApplicationRegistryHandler;
import org.exoplatform.platform.migration.handlers.impl.BackupWorkspaceHandler;
import org.exoplatform.platform.migration.handlers.impl.ResourceBundleHandler;
import org.exoplatform.platform.migration.handlers.impl.UserPortalConfigHandler;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.jcr.DataMapper;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

@URITemplate(value="/marshall/")
public class MarshallConfiguration
implements ResourceContainer {
    private Log log = ExoLogger.getLogger(this.getClass());
    HashMap<String, ComponentHandler> handlersHashMap = new HashMap();
    private RegistryService regService_;
    private DataMapper mapper_ = new DataMapper();
    private static final String ROOT_CONF_DIR = "C:\\conf";

    public MarshallConfiguration(RegistryService service) {
        this.regService_ = service;
        this.handlersHashMap.put(UserPortalConfigService.class.getName(), new UserPortalConfigHandler());
        this.handlersHashMap.put(ApplicationRegistryService.class.getName(), new ApplicationRegistryHandler());
        this.handlersHashMap.put(ResourceBundleService.class.getName(), new ResourceBundleHandler());
        this.handlersHashMap.put(RepositoryService.class.getName(), new BackupWorkspaceHandler());
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/configuration/")
    public Response marshallComponenet() throws Exception {
        this.log.info((Object)"marshallComponenet Start...");
        ExoContainer rootContainer = ExoContainerContext.getTopContainer();
        ArrayList rootComponents = new ArrayList();
        File rootConfFolder = new File(ROOT_CONF_DIR);
        if (rootConfFolder.exists()) {
            rootConfFolder.delete();
        }
        rootConfFolder.mkdirs();
        ConfigurationManager rootManager = (ConfigurationManager)rootContainer.getComponentInstanceOfType(ConfigurationManager.class);
        Iterator it = rootManager.getConfiguration().getComponentIterator();
        while (it.hasNext()) {
            ComponentHandler handler;
            Component component = (Component)it.next();
            ExternalComponentPlugins externalComponentPlugins = rootManager.getConfiguration().getExternalComponentPlugins(component.getKey());
            if (externalComponentPlugins != null && externalComponentPlugins.getComponentPlugins() != null && component.getComponentPlugins() != null) {
                if (component.getComponentPlugins() != null && externalComponentPlugins != null && externalComponentPlugins.getComponentPlugins() != null) {
                    component.getComponentPlugins().addAll(externalComponentPlugins.getComponentPlugins());
                } else if (component.getComponentPlugins() == null && externalComponentPlugins != null && externalComponentPlugins.getComponentPlugins() != null) {
                    component.setComponentPlugins((ArrayList)externalComponentPlugins.getComponentPlugins());
                }
            }
            if ((handler = this.handlersHashMap.get(component.getKey())) != null) {
                handler.invoke(component, ROOT_CONF_DIR);
                continue;
            }
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            this.toXML(configuration, ROOT_CONF_DIR + File.separator + component.getKey() + ".xml");
        }
        PortalContainer portalContainer = PortalContainer.getInstance();
        ConfigurationManager portalManager = (ConfigurationManager)portalContainer.getComponentInstanceOfType(ConfigurationManager.class);
        File portalConfFolder = new File(ROOT_CONF_DIR + File.separator + "portal");
        portalConfFolder.mkdirs();
        it = portalManager.getConfiguration().getComponentIterator();
        while (it.hasNext()) {
            Component component = (Component)it.next();
            ExternalComponentPlugins externalComponentPlugins = portalManager.getConfiguration().getExternalComponentPlugins(component.getKey());
            if (component.getComponentPlugins() != null && externalComponentPlugins != null && externalComponentPlugins.getComponentPlugins() != null) {
                component.getComponentPlugins().addAll(externalComponentPlugins.getComponentPlugins());
            } else if (component.getComponentPlugins() == null && externalComponentPlugins != null && externalComponentPlugins.getComponentPlugins() != null) {
                component.setComponentPlugins((ArrayList)externalComponentPlugins.getComponentPlugins());
            }
            ComponentHandler handler = this.handlersHashMap.get(component.getKey());
            if (handler != null) {
                handler.invoke(component, ROOT_CONF_DIR);
                continue;
            }
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            this.toXML(configuration, portalConfFolder.getPath() + File.separator + component.getKey() + ".xml");
        }
        this.log.info((Object)"marshallComponenet End...");
        return Response.Builder.noContent().build();
    }

    public void toXML(Object obj, String xmlPath) {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(obj.getClass());
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument(obj, "UTF-8", null, (OutputStream)new FileOutputStream(xmlPath));
        }
        catch (Exception ie) {
            this.log.error((Object)"Cannot convert the object to xml", (Throwable)ie);
        }
    }
}

