/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.migration.handlers.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.platform.migration.handlers.ComponentHandler;
import org.exoplatform.services.log.ExoLogger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;

public class ApplicationRegistryHandler
implements ComponentHandler {
    private PortalContainer portalContainer;
    private ApplicationRegistryService applicationRegistryService;
    private Log log = ExoLogger.getLogger(this.getClass());

    public void invoke(Component component, String rootConfDir) {
        try {
            this.portalContainer = PortalContainer.getInstance();
            this.applicationRegistryService = (ApplicationRegistryService)this.portalContainer.getComponentInstanceOfType(ApplicationRegistryService.class);
            this.preMarshallComponent(component, rootConfDir);
            Configuration configuration = new Configuration();
            configuration.addComponent((Object)component);
            this.marshall(configuration, rootConfDir + File.separator + "portal" + File.separator + component.getKey() + ".xml");
        }
        catch (Exception ie) {
            this.log.error((Object)"error in the invoke method", (Throwable)ie);
        }
    }

    private void preMarshallComponent(Component component, String rootConfDir) {
        try {
            List componentPlugins = component.getComponentPlugins();
            for (ComponentPlugin componentPlugin : componentPlugins) {
                if (!componentPlugin.getType().equals("org.exoplatform.application.registry.ApplicationCategoriesPlugins")) continue;
                componentPlugin.getInitParams().clear();
                List applicationCategories = this.applicationRegistryService.getApplicationCategories();
                for (ApplicationCategory applicationCategory : applicationCategories) {
                    ObjectParameter objectParameter = new ObjectParameter();
                    String[] appTypes = new String[]{"portlet", "eXoGadget"};
                    applicationCategory.setApplications(this.applicationRegistryService.getApplications(applicationCategory, appTypes));
                    objectParameter.setDescription(applicationCategory.getDescription());
                    objectParameter.setName(applicationCategory.getName());
                    objectParameter.setObject((Object)applicationCategory);
                    componentPlugin.getInitParams().addParameter((Parameter)objectParameter);
                }
            }
        }
        catch (Exception ie) {
            this.log.error((Object)"problem in the preMarshall Process", (Throwable)ie);
        }
    }

    private void marshall(Object obj, String xmlPath) {
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(obj.getClass());
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.setIndent(2);
            mctx.marshalDocument(obj, "UTF-8", null, (OutputStream)new FileOutputStream(xmlPath));
        }
        catch (Exception ie) {
            this.log.error((Object)"Cannot convert the object to xml", (Throwable)ie);
        }
    }
}

