/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene.spell;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TraversingQueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellChecker;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LuceneSpellChecker
implements SpellChecker {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.LuceneSpellChecker");
    private InternalSpellChecker spellChecker;
    private final long refreshInterval;

    public LuceneSpellChecker() {
        this(3600000L);
    }

    protected LuceneSpellChecker(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void init(QueryHandler handler, float minDistance, boolean morePopular) throws IOException {
        if (!(handler instanceof SearchIndex)) {
            throw new IOException("LuceneSpellChecker only works with " + SearchIndex.class.getName());
        }
        this.spellChecker = new InternalSpellChecker((SearchIndex)handler, minDistance, morePopular);
    }

    public String check(QueryRootNode aqt) throws IOException, RepositoryException {
        String stmt = this.getFulltextStatement(aqt);
        if (stmt == null) {
            return null;
        }
        return this.spellChecker.suggest(stmt);
    }

    public void close() {
        this.spellChecker.close();
    }

    private String getFulltextStatement(QueryRootNode aqt) throws RepositoryException {
        final String[] stmt = new String[1];
        aqt.accept(new TraversingQueryNodeVisitor(){

            public Object visit(RelationQueryNode node, Object o) throws RepositoryException {
                if (stmt[0] == null && node.getOperation() == 29) {
                    stmt[0] = node.getStringValue();
                }
                return super.visit(node, o);
            }
        }, null);
        return stmt[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class InternalSpellChecker {
        private long lastRefresh;
        private boolean refreshing = false;
        private final SearchIndex handler;
        private final Directory spellIndexDirectory;
        private org.apache.lucene.search.spell.SpellChecker spellChecker;
        private final boolean morePopular;

        InternalSpellChecker(SearchIndex handler, float minDistance, boolean morePopular) throws IOException {
            this.handler = handler;
            String path = handler.getContext().getIndexDirectory() + File.separatorChar + "spellchecker";
            this.spellIndexDirectory = FSDirectory.getDirectory((String)path, (LockFactory)new NativeFSLockFactory(path));
            if (IndexReader.indexExists((Directory)this.spellIndexDirectory)) {
                this.lastRefresh = System.currentTimeMillis();
            }
            this.spellChecker = new org.apache.lucene.search.spell.SpellChecker(this.spellIndexDirectory);
            this.spellChecker.setAccuracy(minDistance);
            this.morePopular = morePopular;
            this.refreshSpellChecker();
        }

        String suggest(String statement) throws IOException {
            ArrayList<String> words = new ArrayList<String>();
            ArrayList<Token> tokens = new ArrayList<Token>();
            this.tokenize(statement, words, tokens);
            String[] suggestions = this.check(words.toArray(new String[words.size()]));
            if (suggestions != null) {
                StringBuffer sb = new StringBuffer(statement);
                for (int i = suggestions.length - 1; i >= 0; --i) {
                    Token t = (Token)tokens.get(i);
                    if (t.termText().equalsIgnoreCase(suggestions[i])) continue;
                    sb.replace(t.startOffset(), t.endOffset(), suggestions[i]);
                }
                String result = sb.toString();
                if (statement.equalsIgnoreCase(result)) {
                    return null;
                }
                return result;
            }
            return null;
        }

        void close() {
            try {
                this.spellIndexDirectory.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.spellChecker = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tokenize(String statement, List<String> words, List<Token> tokens) throws IOException {
            TokenStream ts = this.handler.getTextAnalyzer().tokenStream(FieldNames.FULLTEXT, (Reader)new StringReader(statement));
            try {
                Token t;
                while ((t = ts.next()) != null) {
                    String origWord = statement.substring(t.startOffset(), t.endOffset());
                    if (t.getPositionIncrement() > 0) {
                        words.add(t.termText());
                        tokens.add(t);
                        continue;
                    }
                    Token current = tokens.get(tokens.size() - 1);
                    if (Math.abs(origWord.length() - current.termText().length()) <= Math.abs(origWord.length() - t.termText().length())) continue;
                    words.set(words.size() - 1, t.termText());
                    tokens.set(tokens.size() - 1, t);
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ts.close();
                throw throwable;
            }
            ts.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String[] check(String[] words) throws IOException {
            String[] stringArray;
            this.refreshSpellChecker();
            boolean hasSuggestion = false;
            IndexReader reader = this.handler.getIndexReader();
            try {
                for (int retries = 0; retries < 100; ++retries) {
                    block8: {
                        String[] stringArray2;
                        try {
                            String[] suggestion = new String[words.length];
                            for (int i = 0; i < words.length; ++i) {
                                String[] similar = this.spellChecker.suggestSimilar(words[i], 5, reader, FieldNames.FULLTEXT, this.morePopular);
                                if (similar.length > 0) {
                                    suggestion[i] = similar[0];
                                    hasSuggestion = true;
                                    continue;
                                }
                                suggestion[i] = words[i];
                            }
                            if (!hasSuggestion) break block8;
                            log.debug((Object)("Successful after " + new Integer(retries) + " retries"));
                            stringArray2 = suggestion;
                        }
                        catch (AlreadyClosedException e) {
                            continue;
                        }
                        Object var9_12 = null;
                        reader.close();
                        return stringArray2;
                    }
                    String[] stringArray3 = null;
                    Object var9_13 = null;
                    reader.close();
                    return stringArray3;
                }
                stringArray = null;
                Object var9_14 = null;
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            return stringArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshSpellChecker() {
            if (this.lastRefresh + LuceneSpellChecker.this.refreshInterval < System.currentTimeMillis()) {
                InternalSpellChecker internalSpellChecker = this;
                synchronized (internalSpellChecker) {
                    if (this.refreshing) {
                        return;
                    }
                    this.refreshing = true;
                    Runnable refresh = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                IndexReader reader = InternalSpellChecker.this.handler.getIndexReader();
                                try {
                                    long time = System.currentTimeMillis();
                                    LuceneDictionary dict = new LuceneDictionary(reader, FieldNames.FULLTEXT);
                                    log.debug((Object)"Starting spell checker index refresh");
                                    InternalSpellChecker.this.spellChecker.indexDictionary((Dictionary)dict);
                                    time = System.currentTimeMillis() - time;
                                    log.info((Object)("Spell checker index refreshed in: " + new Long(time /= 1000L) + " s."));
                                    Object var6_5 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var6_6 = null;
                                    reader.close();
                                    InternalSpellChecker internalSpellChecker = InternalSpellChecker.this;
                                    synchronized (internalSpellChecker) {
                                        InternalSpellChecker.this.refreshing = false;
                                    }
                                    throw throwable;
                                }
                                reader.close();
                                InternalSpellChecker internalSpellChecker = InternalSpellChecker.this;
                                synchronized (internalSpellChecker) {
                                    InternalSpellChecker.this.refreshing = false;
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    };
                    new Thread(refresh, "SpellChecker Refresh").start();
                    this.lastRefresh = System.currentTimeMillis();
                }
            }
        }
    }

    public static final class OneDayRefreshInterval
    extends LuceneSpellChecker {
        public OneDayRefreshInterval() {
            super(86400000L);
        }
    }

    public static final class TwelveHoursRefreshInterval
    extends LuceneSpellChecker {
        public TwelveHoursRefreshInterval() {
            super(43200000L);
        }
    }

    public static final class SixHoursRefreshInterval
    extends LuceneSpellChecker {
        public SixHoursRefreshInterval() {
            super(21600000L);
        }
    }

    public static final class OneHourRefreshInterval
    extends LuceneSpellChecker {
        public OneHourRefreshInterval() {
            super(3600000L);
        }
    }

    public static final class ThirtyMinutesRefreshInterval
    extends LuceneSpellChecker {
        public ThirtyMinutesRefreshInterval() {
            super(1800000L);
        }
    }

    public static final class FiveMinutesRefreshInterval
    extends LuceneSpellChecker {
        public FiveMinutesRefreshInterval() {
            super(300000L);
        }
    }

    public static final class OneMinuteRefreshInterval
    extends LuceneSpellChecker {
        public OneMinuteRefreshInterval() {
            super(60000L);
        }
    }

    public static final class FiveSecondsRefreshInterval
    extends LuceneSpellChecker {
        public FiveSecondsRefreshInterval() {
            super(5000L);
        }
    }
}

