/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.application;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class SpaceActivityPublisher
extends SpaceListenerPlugin {
    private static Log LOG = ExoLogger.getExoLogger(SpaceActivityPublisher.class);
    private ActivityManager activityManager;
    private IdentityManager identityManager;

    public SpaceActivityPublisher(InitParams params, ActivityManager activityManager, IdentityManager identityManager) throws Exception {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        String spaceId = space.getId();
        try {
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", spaceId, false);
            String creator = event.getTarget();
            this.activityManager.recordActivity(spaceIdentity, "exosocial:spaces", space.getName() + " was created by @" + creator + " .", null);
            LOG.info((Object)("space " + space.getName() + " was added for group " + space.getGroupId()));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to initialize space activity stream ", (Throwable)e);
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        LOG.info((Object)("space " + event.getSpace().getName() + " was removed!"));
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
        LOG.info((Object)("application <b>" + event.getTarget() + "</b> was activated in space " + event.getSpace().getName()));
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        LOG.info((Object)("application <b>" + event.getTarget() + "</b> was added in space " + event.getSpace().getName()));
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
        LOG.info((Object)("application " + event.getTarget() + " was deactivated in space " + event.getSpace().getName()));
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
        LOG.info((Object)("application " + event.getTarget() + " was removed in space " + event.getSpace().getName()));
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        try {
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getId(), false);
            String member = event.getTarget();
            this.activityManager.recordActivity(spaceIdentity, "exosocial:spaces", "@" + member + " was granted lead.", null);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to grant lead ", (Throwable)e);
        }
        LOG.info((Object)("user " + event.getTarget() + " was granted lead of space " + space.getName()));
    }

    public void joined(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        try {
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getId(), false);
            String member = event.getTarget();
            this.activityManager.recordActivity(spaceIdentity, "exosocial:spaces", "@" + member + " has joined.", null);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to log join activity ", (Throwable)e);
        }
        LOG.info((Object)("user " + event.getTarget() + " joined space " + event.getSpace().getName()));
    }

    public void left(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        try {
            Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getId(), false);
            String member = event.getTarget();
            this.activityManager.recordActivity(spaceIdentity, "exosocial:spaces", "@" + member + " has left the space.", null);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to log leave activity ", (Throwable)e);
        }
        LOG.info((Object)("user " + event.getTarget() + " has left of space " + event.getSpace().getName()));
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
        LOG.info((Object)("user " + event.getTarget() + " was revoked lead privileges of space " + event.getSpace().getName()));
    }
}

