/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FileAttachment;
import org.exoplatform.faq.service.QuestionLanguage;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Question {
    private String id;
    private String language;
    private String question;
    private String detail;
    private String author;
    private String email;
    private boolean isActivated = true;
    private boolean isApproved = true;
    private Date createdDate;
    private String categoryId;
    private String[] relations;
    private String link = "";
    private List<FileAttachment> listAttachments = new ArrayList<FileAttachment>();
    private String languagesNotYetAnswered = "";
    private String[] nameAttachs;
    private Answer[] answers;
    private Comment[] comments;
    private String[] usersVote;
    private double markVote = 0.0;
    private String[] usersWatch = null;
    private String[] emailsWatch = null;
    private QuestionLanguage[] multiLanguages;
    private String topicIdDiscuss;
    private String path;
    private String authorOfLastActivity;
    private long timeOfLastActivity = -1L;
    private long numberOfPublicAnswers = 0L;

    public Question() {
        this.id = "Question" + IdGenerator.generate();
        this.relations = new String[0];
        this.multiLanguages = new QuestionLanguage[0];
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String name) {
        this.detail = name;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public String[] getRelations() {
        return this.relations;
    }

    public void setRelations(String[] relations) {
        this.relations = relations;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setActivated(boolean isActivated) {
        this.isActivated = isActivated;
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public void setApproved(boolean isApproved) {
        this.isApproved = isApproved;
    }

    public boolean isApproved() {
        return this.isApproved;
    }

    public void setCategoryId(String catId) {
        this.categoryId = catId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setAttachMent(List<FileAttachment> listFile) {
        this.listAttachments = listFile;
    }

    public List<FileAttachment> getAttachMent() {
        return this.listAttachments;
    }

    public String getLanguagesNotYetAnswered() {
        return this.languagesNotYetAnswered;
    }

    public Question setLanguagesNotYetAnswered(String languagesNotYetAnswered) {
        this.languagesNotYetAnswered = languagesNotYetAnswered;
        return this;
    }

    public String[] getNameAttachs() {
        return this.nameAttachs;
    }

    public void setNameAttachs(String[] nameAttachs) {
        this.nameAttachs = nameAttachs;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String[] getUsersVote() {
        return this.usersVote;
    }

    public void setUsersVote(String[] usersVote) {
        this.usersVote = usersVote;
    }

    public double getMarkVote() {
        return this.markVote;
    }

    public void setMarkVote(double markVote) {
        this.markVote = markVote;
    }

    public String[] getUsersWatch() {
        return this.usersWatch;
    }

    public void setUsersWatch(String[] usersWatch) {
        this.usersWatch = usersWatch;
    }

    public String[] getEmailsWatch() {
        return this.emailsWatch;
    }

    public void setEmailsWatch(String[] emailsWatch) {
        this.emailsWatch = emailsWatch;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String title) {
        this.question = title;
    }

    public String getTopicIdDiscuss() {
        return this.topicIdDiscuss;
    }

    public void setTopicIdDiscuss(String topicIdDiscuss) {
        this.topicIdDiscuss = topicIdDiscuss;
    }

    public Answer[] getAnswers() {
        return this.answers;
    }

    public void setAnswers(Answer[] answers) {
        this.answers = answers;
    }

    public Comment[] getComments() {
        return this.comments;
    }

    public void setComments(Comment[] comments) {
        this.comments = comments;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setMultiLanguages(QuestionLanguage[] multiLanguages) {
        this.multiLanguages = multiLanguages;
    }

    public QuestionLanguage[] getMultiLanguages() {
        return this.multiLanguages;
    }

    public String getAuthorOfLastActivity() {
        if (this.authorOfLastActivity == null || this.authorOfLastActivity.isEmpty()) {
            return this.author;
        }
        return this.authorOfLastActivity;
    }

    public long getTimeOfLastActivity() {
        if (this.timeOfLastActivity < 0L && this.createdDate != null) {
            return this.createdDate.getTime();
        }
        return this.timeOfLastActivity;
    }

    public void setLastActivity(String info) {
        this.authorOfLastActivity = Utils.getAuthorOfLastActivity(info);
        this.timeOfLastActivity = Utils.getTimeOfLastActivity(info);
    }

    public long getNumberOfPublicAnswers() {
        return this.numberOfPublicAnswers;
    }

    public void setNumberOfPublicAnswers(long numberOfPublicAnswers) {
        this.numberOfPublicAnswers = numberOfPublicAnswers;
    }
}

