/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.action;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsEditableFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotEditingDocumentFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentFormController;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionForm;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionTypeForm;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={EditDocumentActionListener.class})})
public class EditDocumentActionComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsDocumentFilter(), new IsEditableFilter(), new CanSetPropertyFilter(), new IsNotLockedFilter(), new IsCheckedOutFilter(), new IsNotInTrashFilter(), new IsNotEditingDocumentFilter()});

    @UIExtensionFilters
    public static List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    private static void refresh(Node node) throws Exception {
        node.refresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void editDocument(Event<? extends UIComponent> event, WebuiRequestContext context, UIComponent comp, UIJCRExplorer uiExplorer, Node selectedNode, UIApplication uiApp) throws RepositoryException, Exception, ValueFormatException, PathNotFoundException {
        if (event != null) {
            context = event.getRequestContext();
        }
        if (selectedNode.isNodeType("exo:action")) {
            UIActionContainer uiContainer = (UIActionContainer)uiExplorer.createUIComponent(UIActionContainer.class, null, null);
            uiExplorer.setIsHidePopup(true);
            UIActionForm uiActionForm = (UIActionForm)uiContainer.getChild(UIActionForm.class);
            ((UIActionTypeForm)uiContainer.getChild(UIActionTypeForm.class)).setRendered(false);
            uiActionForm.createNewAction(selectedNode, selectedNode.getPrimaryNodeType().getName(), false);
            uiActionForm.setIsUpdateSelect(false);
            uiActionForm.setNodePath(selectedNode.getPath());
            uiActionForm.setWorkspace(selectedNode.getSession().getWorkspace().getName());
            uiActionForm.setStoredPath(selectedNode.getPath());
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
            UIPopupContainer2.activate((UIComponent)uiContainer, 700, 550);
            context.addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
            return;
        }
        String nodeType = null;
        nodeType = selectedNode.hasProperty("exo:presentationType") ? selectedNode.getProperty("exo:presentationType").getString() : selectedNode.getPrimaryNodeType().getName();
        UIDocumentFormController uiController = event != null ? (UIDocumentFormController)((UIComponent)event.getSource()).createUIComponent(UIDocumentFormController.class, null, "EditFormController") : (UIDocumentFormController)comp.createUIComponent(UIDocumentFormController.class, null, "EditFormController");
        UIDocumentForm uiDocumentForm = (UIDocumentForm)uiController.getChild(UIDocumentForm.class);
        uiDocumentForm.setRepositoryName(uiExplorer.getRepositoryName());
        uiDocumentForm.setContentType(nodeType);
        if (uiDocumentForm.getTemplate() == null) {
            uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.template-null", null));
            context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        EditDocumentActionComponent.refresh(selectedNode);
        uiDocumentForm.setIsKeepinglock(false);
        if (!selectedNode.isLocked()) {
            Class<EditDocumentActionComponent> clazz = EditDocumentActionComponent.class;
            // MONITORENTER : org.exoplatform.ecm.webui.component.explorer.control.action.EditDocumentActionComponent.class
            EditDocumentActionComponent.refresh(selectedNode);
            if (!selectedNode.isLocked()) {
                if (selectedNode.canAddMixin("mix:lockable")) {
                    selectedNode.addMixin("mix:lockable");
                    selectedNode.save();
                }
                Lock lock = selectedNode.lock(false, false);
                LockUtil.keepLock((Lock)lock);
                LockService lockService = (LockService)uiExplorer.getApplicationComponent(LockService.class);
                List settingLockList = lockService.getAllGroupsOrUsersForLock();
                for (String settingLock : settingLockList) {
                    LockUtil.keepLock((Lock)lock, (String)settingLock);
                    if (!settingLock.startsWith("*")) continue;
                    String lockTokenString = settingLock;
                    ExoContainer container = ExoContainerContext.getCurrentContainer();
                    OrganizationService service = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
                    List memberships = (List)service.getMembershipTypeHandler().findMembershipTypes();
                    for (MembershipType membership : memberships) {
                        lockTokenString = settingLock.replace("*", membership.getName());
                        LockUtil.keepLock((Lock)lock, (String)lockTokenString);
                    }
                }
                selectedNode.save();
                uiDocumentForm.setIsKeepinglock(true);
            }
            // MONITOREXIT : clazz
        }
        EditDocumentActionComponent.refresh(selectedNode);
        if (LockUtil.getLockTokenOfUser((Node)selectedNode) == null) {
            Object[] arg = new Object[]{selectedNode.getPath()};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked-editing", arg, 1));
            context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        uiDocumentForm.setNodePath(selectedNode.getPath());
        uiDocumentForm.addNew(false);
        uiDocumentForm.setWorkspace(selectedNode.getSession().getWorkspace().getName());
        uiDocumentForm.setStoredPath(selectedNode.getPath());
        uiController.setRenderedChild(UIDocumentForm.class);
        if (((UIJCRExplorerPortlet)uiExplorer.getAncestorOfType(UIJCRExplorerPortlet.class)).isEditInNewWindow()) {
            UIPopupContainer uiPopupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
            uiPopupContainer.activate((UIComponent)uiController, 800, 600);
            context.addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
            context.addUIComponentToUpdateByAjax(uiExplorer.getChild(UIControl.class));
            return;
        }
        UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
        UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
        if (!uiDocumentWorkspace.isRendered()) {
            ((UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class)).setRendered(false);
            ((UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).setRendered(true);
        }
        UIDocumentContainer uiDocumentContainer = (UIDocumentContainer)uiDocumentWorkspace.getChild(UIDocumentContainer.class);
        uiDocumentContainer.setRendered(false);
        uiDocumentWorkspace.addChild((UIComponent)uiController);
        uiController.initOptionBlockPanel();
        uiController.setRendered(true);
        ((UIDocumentForm)uiController.getChild(UIDocumentForm.class)).initFieldInput();
        context.addUIComponentToUpdateByAjax((UIComponent)uiWorkingArea);
        if (event != null) {
            uiExplorer.updateAjax(event);
        }
        context.addUIComponentToUpdateByAjax(uiExplorer.getChild(UIControl.class));
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditDocumentActionListener
    extends UIActionBarActionListener<EditDocumentActionComponent> {
        public void processEvent(Event<EditDocumentActionComponent> event) throws Exception {
            EditDocumentActionComponent uicomp = (EditDocumentActionComponent)((Object)event.getSource());
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uicomp.getAncestorOfType(UIJCRExplorer.class);
            Node selectedNode = null;
            if (nodePath != null && nodePath.length() != 0) {
                Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
                String wsName = null;
                if (!matcher.find()) {
                    throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
                }
                wsName = matcher.group(1);
                nodePath = matcher.group(2);
                Session session = uiExplorer.getSessionByWorkspace(wsName);
                UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
                try {
                    selectedNode = uiExplorer.getNodeByPath(nodePath, session);
                }
                catch (PathNotFoundException path) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                catch (AccessDeniedException ace) {
                    uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.null-exception", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                catch (Exception e) {
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                    return;
                }
            }
            if (selectedNode == null) {
                selectedNode = uiExplorer.getCurrentNode();
            }
            uiExplorer.setCurrentPath(selectedNode.getPath());
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            EditDocumentActionComponent.editDocument(event, null, (UIComponent)uicomp, uiExplorer, selectedNode, uiApp);
        }
    }
}

