/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.command;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.ftp.command.FtpCommandImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdRnFr
extends FtpCommandImpl {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ftp.CmdRnFr");

    public CmdRnFr() {
        this.commandName = "RNFR";
    }

    public void run(String[] params) throws IOException {
        if (params.length < 2) {
            this.reply(String.format("500 %s: command requires a parameter", "RNFR"));
            return;
        }
        String resName = params[1];
        this.clientSession().setPrevParamsEx(null);
        try {
            ArrayList<String> newPath = this.clientSession().getFullPath(resName);
            Session curSession = this.clientSession().getSession(newPath.get(0));
            String repoPath = this.clientSession().getRepoPath(newPath);
            curSession.getItem(repoPath);
            this.clientSession().setPrevParamsEx(repoPath);
            this.reply("350 File or directory exists, ready for destination name");
            return;
        }
        catch (RepositoryException rexc) {
        }
        catch (Exception exc) {
            log.info("Unhandled exception. " + exc.getMessage(), exc);
        }
        this.reply(String.format("550 %s: Permission denied", resName));
    }
}

