/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ecms.xcmis.sp.BaseObjectData;
import org.exoplatform.ecms.xcmis.sp.FolderDataImpl;
import org.exoplatform.ecms.xcmis.sp.JcrNodeEntry;
import org.exoplatform.ecms.xcmis.sp.PWC;
import org.exoplatform.ecms.xcmis.sp.index.IndexListener;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocumentDataImpl
extends BaseObjectData
implements DocumentData {
    protected static final Set<String> CHECKOUT_SKIP = new HashSet<String>();

    public DocumentDataImpl(JcrNodeEntry jcrEntry, IndexListener indexListener) {
        super(jcrEntry, indexListener);
    }

    public void cancelCheckout() throws VersioningException, UpdateConflictException, StorageException {
        try {
            String pwcId = this.getVersionSeriesCheckedOutId();
            PWC pwc = new PWC(this.entry.storage.getEntry(pwcId), this.indexListener, this);
            pwc.delete();
        }
        catch (ObjectNotFoundException e) {
            throw new CmisRuntimeException("Unable cancel checkout. PWC does not exists. " + e.getMessage());
        }
    }

    public DocumentData checkin(boolean major, String checkinComment, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws NameConstraintViolationException, UpdateConflictException, StorageException {
        throw new CmisRuntimeException("Current object is not Private Working Copy.");
    }

    public DocumentData checkout() throws VersioningException, UpdateConflictException, StorageException {
        if (this.isVersionSeriesCheckedOut()) {
            throw new VersioningException("Version series already checked-out. Not allowed have more then one PWC for version series at a time.");
        }
        try {
            Node node = this.entry.getNode();
            Session session = node.getSession();
            String id = this.getObjectId();
            String name = this.getName();
            TypeDefinition type = this.getTypeDefinition();
            Node workingCopies = (Node)session.getItem("/xcmis:system/xcmis:workingCopyStore");
            Node workingCopyNode = workingCopies.addNode(id, "xcmis:workingCopy");
            Node pwcNode = workingCopyNode.addNode(name, type.getLocalName());
            if (!pwcNode.isNodeType("cmis:document")) {
                pwcNode.addMixin("cmis:document");
            }
            if (pwcNode.canAddMixin("mix:versionable")) {
                pwcNode.addMixin("mix:versionable");
            }
            JcrNodeEntry pwcEntry = this.entry.storage.fromNode(pwcNode);
            pwcEntry.setValue("cmis:objectTypeId", type.getId());
            pwcEntry.setValue("cmis:baseTypeId", type.getBaseId().value());
            String userId = session.getUserID();
            pwcEntry.setValue("cmis:createdBy", userId);
            pwcEntry.setValue("cmis:lastModifiedBy", userId);
            Calendar cal = Calendar.getInstance();
            pwcEntry.setValue("cmis:creationDate", cal);
            pwcEntry.setValue("cmis:lastModificationDate", cal);
            pwcEntry.setValue("cmis:versionSeriesId", this.getVersionSeriesId());
            pwcEntry.setValue("cmis:isLatestVersion", true);
            pwcEntry.setValue("cmis:isMajorVersion", false);
            pwcEntry.setValue("cmis:versionLabel", "pwc");
            pwcEntry.setValue("cmis:isVersionSeriesCheckedOut", true);
            pwcEntry.setValue("cmis:versionSeriesCheckedOutId", pwcEntry.getId());
            pwcEntry.setValue("cmis:versionSeriesCheckedOutBy", session.getUserID());
            pwcEntry.setValue("xcmis:latestVersionId", id);
            pwcEntry.setContentStream(this.getContentStream(null));
            try {
                for (PropertyDefinition propertyDefinition : type.getPropertyDefinitions()) {
                    String propertyId = propertyDefinition.getId();
                    if (CHECKOUT_SKIP.contains(propertyId)) continue;
                    pwcEntry.setProperty(this.getProperty(propertyId));
                }
            }
            catch (NameConstraintViolationException never) {
                throw new CmisRuntimeException(never.getMessage(), (Throwable)never);
            }
            this.entry.setValue("cmis:isLatestVersion", false);
            this.entry.setValue("cmis:isVersionSeriesCheckedOut", true);
            this.entry.setValue("cmis:versionSeriesCheckedOutId", pwcEntry.getId());
            this.entry.setValue("cmis:versionSeriesCheckedOutBy", userId);
            PWC pwc = new PWC(pwcEntry, this.indexListener, this);
            pwc.save();
            if (this.indexListener != null) {
                this.indexListener.updated(this);
            }
            return pwc;
        }
        catch (ObjectNotFoundException onfe) {
            throw new StorageException("Unable checkout. " + onfe.getMessage(), (Throwable)onfe);
        }
        catch (IOException ioe) {
            throw new CmisRuntimeException("Unable checkout. " + ioe.getMessage(), (Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable checkout. " + re.getMessage(), (Throwable)re);
        }
    }

    public ContentStream getContentStream() throws IOException {
        return this.entry.getContentStream(null);
    }

    public ContentStream getContentStream(String streamId) throws IOException {
        ContentStream contentStream = this.entry.getContentStream(streamId);
        if (contentStream == null) {
            contentStream = RenditionManager.getInstance().getStream((ObjectData)this, streamId);
        }
        return contentStream;
    }

    public String getContentStreamMimeType() {
        String mimeType = this.entry.getString("cmis:contentStreamMimeType");
        if (mimeType == null) {
            mimeType = this.entry.getString("jcr:content/jcr:mimeType");
        }
        return mimeType;
    }

    @Override
    public Calendar getCreationDate() {
        Calendar date = super.getCreationDate();
        if (date == null) {
            date = this.entry.getDate("jcr:created");
        }
        return date;
    }

    @Override
    public Calendar getLastModificationDate() {
        Calendar date = super.getLastModificationDate();
        if (date == null) {
            date = this.entry.getDate("jcr:content/jcr:lastModified");
        }
        return date;
    }

    public FolderData getParent() throws ConstraintException {
        Collection<FolderData> parents = this.getParents();
        if (parents.size() > 1) {
            throw new ConstraintException("Object has more then one parent.");
        }
        if (parents.size() == 0) {
            return null;
        }
        return parents.iterator().next();
    }

    public Collection<FolderData> getParents() {
        Collection<JcrNodeEntry> parentEntries = this.entry.getParents();
        HashSet<FolderData> parents = new HashSet<FolderData>(parentEntries.size());
        for (JcrNodeEntry parentEntry : parentEntries) {
            parents.add(new FolderDataImpl(parentEntry, this.indexListener));
        }
        return parents;
    }

    public String getVersionLabel() {
        return this.entry.getString("cmis:versionLabel");
    }

    public String getVersionSeriesCheckedOutBy() {
        return this.entry.getString("cmis:versionSeriesCheckedOutBy");
    }

    public String getVersionSeriesCheckedOutId() {
        return this.entry.getString("cmis:versionSeriesCheckedOutId");
    }

    public String getVersionSeriesId() {
        return this.entry.getString("cmis:versionSeriesId");
    }

    public boolean hasContent() {
        return this.entry.hasContent();
    }

    public boolean isLatestMajorVersion() {
        return this.isLatestVersion() && this.isMajorVersion();
    }

    public boolean isLatestVersion() {
        Boolean latest = this.entry.getBoolean("cmis:isLatestVersion");
        return latest == null ? true : latest;
    }

    public boolean isMajorVersion() {
        Boolean major = this.entry.getBoolean("cmis:isMajorVersion");
        return major == null ? false : major;
    }

    public boolean isPWC() {
        return false;
    }

    public boolean isVersionSeriesCheckedOut() {
        Boolean checkout = this.entry.getBoolean("cmis:isVersionSeriesCheckedOut");
        return checkout == null ? false : checkout;
    }

    public void setContentStream(ContentStream contentStream) throws IOException, VersioningException, UpdateConflictException, StorageException {
        this.entry.setContentStream(contentStream);
        this.save();
    }

    protected long getContentStreamLength() {
        Long length = this.entry.getLong("cmis:contentStreamLength");
        if (length == null) {
            ContentStream contentStream = this.entry.getContentStream(null);
            length = contentStream == null ? 0L : contentStream.length();
        }
        return length;
    }

    @Override
    protected void delete() throws StorageException {
        String objectId = this.getObjectId();
        this.entry.delete();
        if (this.indexListener != null) {
            HashSet<String> removed = new HashSet<String>();
            removed.add(objectId);
            this.indexListener.removed(removed);
        }
    }

    static {
        CHECKOUT_SKIP.add("cmis:name");
        CHECKOUT_SKIP.add("cmis:objectId");
        CHECKOUT_SKIP.add("cmis:objectTypeId");
        CHECKOUT_SKIP.add("cmis:baseTypeId");
        CHECKOUT_SKIP.add("cmis:createdBy");
        CHECKOUT_SKIP.add("cmis:creationDate");
        CHECKOUT_SKIP.add("cmis:lastModifiedBy");
        CHECKOUT_SKIP.add("cmis:lastModificationDate");
        CHECKOUT_SKIP.add("cmis:changeToken");
        CHECKOUT_SKIP.add("cmis:isImmutable");
        CHECKOUT_SKIP.add("cmis:versionSeriesId");
        CHECKOUT_SKIP.add("cmis:isLatestVersion");
        CHECKOUT_SKIP.add("cmis:isMajorVersion");
        CHECKOUT_SKIP.add("cmis:isLatestMajorVersion");
        CHECKOUT_SKIP.add("cmis:versionLabel");
        CHECKOUT_SKIP.add("cmis:checkinComment");
        CHECKOUT_SKIP.add("cmis:isVersionSeriesCheckedOut");
        CHECKOUT_SKIP.add("cmis:versionSeriesCheckedOutId");
        CHECKOUT_SKIP.add("cmis:versionSeriesCheckedOutBy");
        CHECKOUT_SKIP.add("cmis:contentStreamFileName");
        CHECKOUT_SKIP.add("cmis:contentStreamId");
        CHECKOUT_SKIP.add("cmis:contentStreamLength");
        CHECKOUT_SKIP.add("cmis:contentStreamMimeType");
        CHECKOUT_SKIP.add("xcmis:latestVersionId");
    }
}

