/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.RepositoryException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecms.xcmis.sp.JcrCmisRegistry;
import org.exoplatform.ecms.xcmis.sp.StorageConfiguration;
import org.exoplatform.ecms.xcmis.sp.StorageProviderImpl;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.impl.RepositoryServiceImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.Connection;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.StorageProvider;
import org.xcmis.spi.model.RepositoryShortInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriveCmisRegistry
extends JcrCmisRegistry {
    private static final Log LOG = ExoLogger.getLogger(DriveCmisRegistry.class);
    private final RepositoryService repositoryService;
    private final DocumentReaderService documentReaderService;
    private final ManageDriveService driveService;
    private final String defRepository = "repository";
    private String repository;
    private final PermissionService permissionService;
    private boolean persistRenditions;
    private final DMSConfiguration dmsConfiguration;

    public DriveCmisRegistry(RepositoryServiceImpl repositoryService, DocumentReaderService documentReaderService, InitParams initParams, ManageDriveService driveService, DMSConfiguration dmsConfiguration) {
        super(repositoryService, documentReaderService, initParams);
        this.repositoryService = repositoryService;
        this.documentReaderService = documentReaderService;
        this.dmsConfiguration = dmsConfiguration;
        this.permissionService = new PermissionService();
        this.driveService = driveService;
    }

    public DriveCmisRegistry(RepositoryServiceImpl repositoryService, InitParams initParams, ManageDriveService driveService, DMSConfiguration dmsConfiguration) {
        this(repositoryService, null, initParams, driveService, dmsConfiguration);
    }

    public Connection getConnection(String storageId) {
        StorageProvider provider = (StorageProvider)this.storageProviders.get(storageId);
        if (provider == null) {
            DriveData drive = null;
            try {
                drive = this.driveService.getDriveByName(storageId, this.repository);
            }
            catch (Exception e) {
                throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
            }
            if (drive != null) {
                StorageProviderImpl provider0 = this.createStorageProvider(drive);
                try {
                    provider0.init();
                    provider = provider0;
                }
                catch (Exception e) {
                    throw new CmisRuntimeException("Initializing of storage provider " + storageId + " failed. " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (provider != null) {
            return provider.getConnection();
        }
        throw new InvalidArgumentException("Storage '" + storageId + "' does not exist.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RepositoryShortInfo> getStorageInfos() {
        Identity identity;
        List memberships = null;
        String userId = null;
        ConversationState state = ConversationState.getCurrent();
        if (state != null && (identity = state.getIdentity()) != null) {
            userId = identity.getUserId();
            memberships = new ArrayList(identity.getMemberships().size());
            for (MembershipEntry membership : identity.getMemberships()) {
                memberships.add(membership.toString());
            }
        }
        if (userId == null) {
            userId = SystemIdentity.ANONIM;
        }
        if (memberships == null) {
            memberships = Collections.emptyList();
        }
        TreeSet<RepositoryShortInfo> repositories = new TreeSet<RepositoryShortInfo>();
        List availableDrives = null;
        try {
            availableDrives = this.driveService.getDriveByUserRoles(this.repository, userId, memberships);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (availableDrives != null) {
            for (DriveData drive : availableDrives) {
                String driveName = drive.getName();
                StorageProvider provider = (StorageProvider)this.storageProviders.get(driveName);
                if (provider == null) {
                    StorageProviderImpl provider0 = this.createStorageProvider(drive);
                    try {
                        provider0.init();
                        provider = provider0;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Initializing of storage provider " + driveName + " failed. "), (Throwable)e);
                    }
                }
                if (provider == null) continue;
                Connection connection = null;
                try {
                    String storageID = provider.getStorageID();
                    RepositoryShortInfo info = new RepositoryShortInfo(storageID, storageID);
                    connection = provider.getConnection();
                    info.setRootFolderId(connection.getStorage().getRepositoryInfo().getRootFolderId());
                    repositories.add(info);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage());
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
        }
        return Collections.unmodifiableSortedSet(repositories);
    }

    @Override
    public String[] getAffectedWorkspaceNames() throws RepositoryException {
        List drives;
        try {
            drives = this.driveService.getAllDrives(this.repositoryService.getCurrentRepository().getConfiguration().getName());
        }
        catch (Exception e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
        HashSet<String> wsNames = new HashSet<String>();
        if (drives != null) {
            for (DriveData driveData : drives) {
                wsNames.add(driveData.getWorkspace());
            }
        }
        return wsNames.toArray(new String[wsNames.size()]);
    }

    @Override
    public void start() {
        this.repository = this.getValueParameter("repository", "repository");
        this.persistRenditions = Boolean.parseBoolean(this.getValueParameter("exo.cmis.renditions.persistent", "false"));
        List allDrives = null;
        try {
            allDrives = this.driveService.getAllDrives(this.repository);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Unable get list of drives. " + e.getMessage(), (Throwable)e);
        }
        for (DriveData drive : allDrives) {
            if (this.isPrivateDrive(drive)) continue;
            String driveName = drive.getName();
            StorageProviderImpl sp = this.createStorageProvider(drive);
            try {
                sp.init();
                this.addStorage(sp);
            }
            catch (Exception e) {
                LOG.error((Object)("Initializing of storage provider " + driveName + " failed. " + e.getMessage()));
            }
        }
        super.start();
    }

    protected boolean isPrivateDrive(DriveData drive) {
        return drive.getHomePath().contains("${userId}");
    }

    private StorageProviderImpl createStorageProvider(DriveData drive) {
        String driveName = drive.getName();
        String driveRootPath = drive.getHomePath();
        String driveWorkspace = drive.getWorkspace();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("exo.cmis.renditions.persistent", this.persistRenditions);
        StorageConfiguration configuration = new StorageConfiguration(driveName, this.repository, driveWorkspace, driveRootPath, properties, null);
        StorageProviderImpl sp = new StorageProviderImpl(this.repositoryService, this.documentReaderService, this.permissionService, this, this.getSearchService(this.repository, driveWorkspace), configuration);
        return sp;
    }
}

