/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormTextAreaInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseUIActivity
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(BaseUIActivity.class);
    public static int LATEST_COMMENTS_SIZE = 2;
    private int commentMinCharactersAllowed = 0;
    private int commentMaxCharactersAllowed = 100;
    private String image;
    private Activity activity;
    private List<Activity> comments;
    private String[] identityLikes;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private boolean commentFormDisplayed = false;
    private boolean likesDisplayed = false;
    private CommentStatus commentListStatus = CommentStatus.LATEST;
    private boolean allCommentsHidden = false;
    private boolean commentFormFocused = false;

    public BaseUIActivity() {
        this.setSubmitAction("return false;");
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
        this.addChild((UIComponent)new UIFormTextAreaInput("CommentTextarea" + activity.getId(), "CommentTextarea", null));
        this.refresh();
    }

    public Activity getActivity() {
        return this.activity;
    }

    public void setCommentMinCharactersAllowed(int num) {
        this.commentMinCharactersAllowed = num;
    }

    public int getCommentMinCharactersAllowed() {
        return this.commentMinCharactersAllowed;
    }

    public void setCommentMaxCharactersAllowed(int num) {
        this.commentMaxCharactersAllowed = num;
    }

    public int getCommentMaxCharactersAllowed() {
        return this.commentMaxCharactersAllowed;
    }

    public void setCommentFormDisplayed(boolean commentFormDisplayed) {
        this.commentFormDisplayed = commentFormDisplayed;
    }

    public boolean isCommentFormDisplayed() {
        return this.commentFormDisplayed;
    }

    public void setLikesDisplayed(boolean likesDisplayed) {
        this.likesDisplayed = likesDisplayed;
    }

    public boolean isLikesDisplayed() {
        return this.likesDisplayed;
    }

    public void setAllCommentsHidden(boolean allCommentsHidden) {
        this.allCommentsHidden = allCommentsHidden;
    }

    public boolean isAllCommentsHidden() {
        return this.allCommentsHidden;
    }

    public void setCommentFormFocused(boolean commentFormFocused) {
        this.commentFormFocused = commentFormFocused;
    }

    public boolean isCommentFormFocused() {
        return this.commentFormFocused;
    }

    public void setCommentListStatus(CommentStatus status) {
        this.commentListStatus = status;
        if (status == CommentStatus.ALL) {
            this.commentFormDisplayed = true;
        }
    }

    public CommentStatus getCommentListStatus() {
        return this.commentListStatus;
    }

    public boolean commentListToggleable() {
        return this.comments.size() > LATEST_COMMENTS_SIZE;
    }

    public List<Activity> getComments() {
        if (this.commentListStatus == CommentStatus.ALL) {
            return this.comments;
        }
        if (this.commentListStatus == CommentStatus.NONE) {
            return new ArrayList<Activity>();
        }
        int commentsSize = this.comments.size();
        if (commentsSize > LATEST_COMMENTS_SIZE) {
            return this.comments.subList(commentsSize - LATEST_COMMENTS_SIZE, commentsSize);
        }
        return this.comments;
    }

    public List<Activity> getAllComments() {
        return this.comments;
    }

    public String[] getIdentityLikes() {
        return this.identityLikes;
    }

    public String[] getDisplayedIdentityLikes() throws Exception {
        this.identityManager = this.getIdentityManager();
        Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", this.getRemoteUser());
        if (this.isLiked()) {
            return (String[])ArrayUtils.removeElement((Object[])this.identityLikes, (Object)userIdentity.getId());
        }
        return this.identityLikes;
    }

    public void setIdenityLikes(String[] identityLikes) {
        this.identityLikes = identityLikes;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public String event(String actionName, String callback, boolean updateForm) throws Exception {
        if (updateForm) {
            return super.url(actionName);
        }
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.social.webui.UIForm.submitForm('").append(this.getFormId()).append("','");
        b.append(actionName).append("',");
        b.append(callback).append(",");
        b.append("true").append(")");
        return b.toString();
    }

    public String getPostedTimeString(long postedTime) {
        long time = (new Date().getTime() - postedTime) / 1000L;
        long value = 0L;
        if (time < 60L) {
            return "less than a minute ago";
        }
        if (time < 120L) {
            return "about a minute ago";
        }
        if (time < 3600L) {
            value = Math.round(time / 60L);
            return "about " + value + " minutes ago";
        }
        if (time < 7200L) {
            return "about an hour ago";
        }
        if (time < 86400L) {
            value = Math.round(time / 3600L);
            return "about " + value + " hours ago";
        }
        if (time < 172800L) {
            return "about a day ago";
        }
        if (time < 2592000L) {
            value = Math.round(time / 86400L);
            return "about " + value + " days ago";
        }
        if (time < 5184000L) {
            return "about a month ago";
        }
        value = Math.round(time / 2592000L);
        return "about " + value + " months ago";
    }

    private String getFormId() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context instanceof PortletRequestContext) {
            return ((PortletRequestContext)context).getWindowId() + "#" + this.getId();
        }
        return this.getId();
    }

    protected void saveComment(String remoteUser, String message) throws Exception {
        this.activityManager = this.getActivityManager();
        this.identityManager = this.getIdentityManager();
        Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", remoteUser);
        Activity comment = new Activity(userIdentity.getId(), "exosocial:spaces", message, null);
        this.activityManager.saveComment(this.getActivity(), comment);
        this.comments = this.activityManager.getComments(this.getActivity());
        this.setCommentListStatus(CommentStatus.ALL);
    }

    protected void setLike(boolean isLiked, String remoteUser) throws Exception {
        this.activityManager = this.getActivityManager();
        this.identityManager = this.getIdentityManager();
        Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", remoteUser);
        if (isLiked) {
            this.activityManager.saveLike(this.activity, userIdentity);
        } else {
            this.activityManager.removeLike(this.activity, userIdentity);
        }
        this.activity = this.activityManager.getActivity(this.activity.getId());
        this.setIdenityLikes(this.activity.getLikeIdentityIds());
    }

    public boolean isLiked() throws Exception {
        this.identityManager = this.getIdentityManager();
        return ArrayUtils.contains((Object[])this.identityLikes, (Object)this.identityManager.getOrCreateIdentity("organization", this.getRemoteUser()).getId());
    }

    protected void refresh() {
        this.activityManager = this.getActivityManager();
        this.activity = this.activityManager.getActivity(this.activity.getId());
        if (this.activity == null) {
            LOG.info((Object)"activity_ is null, not found. It can be deleted!");
            return;
        }
        this.comments = this.activityManager.getComments(this.activity);
        this.identityLikes = this.activity.getLikeIdentityIds();
    }

    private String getRemoteUser() {
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        return requestContext.getRemoteUser();
    }

    public String getUserFullName(String userIdentityId) throws Exception {
        Identity userIdentity = this.getIdentityManager().getIdentity(userIdentityId, true);
        if (userIdentity == null) {
            return null;
        }
        Profile userProfile = userIdentity.getProfile();
        return userProfile.getFullName();
    }

    public String getUserProfileUri(String userIdentityId) {
        try {
            Identity userIdentity = this.getIdentityManager().getIdentity(userIdentityId, true);
            if (userIdentity == null) {
                return "#";
            }
            String url = userIdentity.getProfile().getUrl();
            if (url != null) {
                return url;
            }
            return "#";
        }
        catch (Exception e) {
            return "#";
        }
    }

    public String getUserAvatarImageSource(String userIdentityId) throws Exception {
        Identity userIdentity = this.identityManager.getIdentity(userIdentityId, true);
        if (userIdentity == null) {
            return null;
        }
        Profile userProfile = userIdentity.getProfile();
        return userProfile.getAvatarImageSource();
    }

    private ActivityManager getActivityManager() {
        return (ActivityManager)this.getApplicationComponent(ActivityManager.class);
    }

    private IdentityManager getIdentityManager() {
        return (IdentityManager)this.getApplicationComponent(IdentityManager.class);
    }

    public boolean isSpaceActivity(String id) {
        try {
            this.identityManager = this.getIdentityManager();
            Identity identity = this.identityManager.getIdentity(id, false);
            String remoteId = identity.getRemoteId();
            boolean result = this.identityManager.getIdentity("space", remoteId, false) != null;
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isUserActivity(String id) throws Exception {
        try {
            this.identityManager = this.getIdentityManager();
            Identity identity = this.identityManager.getIdentity(id, false);
            String remoteId = identity.getRemoteId();
            boolean result = this.identityManager.getIdentity("organization", remoteId, false) != null;
            return result;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isActivityDeletable() throws SpaceException {
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        String remoteUser = this.getRemoteUser();
        if (postContext == UIComposer.PostContext.SPACE) {
            Space space = uiActivitiesContainer.getSpace();
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            return spaceService.isLeader(space, remoteUser);
        }
        if (postContext == UIComposer.PostContext.USER) {
            UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getAncestorOfType(UIUserActivitiesDisplay.class);
            if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.MY_STATUS) {
                return true;
            }
            if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.SPACES) {
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean isCommentDeletable(String activityUserId) throws SpaceException {
        UIActivitiesContainer uiActivitiesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        UIComposer.PostContext postContext = uiActivitiesContainer.getPostContext();
        IdentityManager identityManager = (IdentityManager)this.getApplicationComponent(IdentityManager.class);
        try {
            Identity remoteUserIdentity = identityManager.getOrCreateIdentity("organization", this.getRemoteUser(), false);
            if (remoteUserIdentity.getId().equals(activityUserId)) {
                return true;
            }
            if (postContext == UIComposer.PostContext.SPACE) {
                Space space = uiActivitiesContainer.getSpace();
                SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
                return spaceService.isLeader(space, this.getRemoteUser());
            }
            if (postContext == UIComposer.PostContext.USER) {
                UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getAncestorOfType(UIUserActivitiesDisplay.class);
                if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.MY_STATUS) {
                    return true;
                }
                if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.SPACES) {
                    return false;
                }
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("can't not get remoteUserIdentity: remoteUser = " + this.getRemoteUser()));
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteCommentActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            ActivityManager activityManager = uiActivity.getActivityManager();
            activityManager.deleteComment(uiActivity.getActivity().getId(), requestContext.getRequestParameter("objectId"));
            uiActivity.refresh();
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActivityActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            uiActivity.refresh();
            ActivityManager activityManager = uiActivity.getActivityManager();
            activityManager.deleteActivity(uiActivity.getActivity().getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PostCommentActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            uiActivity.refresh();
            WebuiRequestContext requestContext = event.getRequestContext();
            UIFormTextAreaInput uiFormComment = (UIFormTextAreaInput)uiActivity.getChild(UIFormTextAreaInput.class);
            String message = (String)uiFormComment.getValue();
            uiFormComment.reset();
            uiActivity.saveComment(requestContext.getRemoteUser(), message);
            uiActivity.setCommentFormFocused(true);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToggleDisplayCommentFormActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            if (uiActivity.isCommentFormDisplayed()) {
                uiActivity.setCommentFormDisplayed(false);
            } else {
                uiActivity.setCommentFormDisplayed(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetCommentListStatusActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            uiActivity.refresh();
            String status = event.getRequestContext().getRequestParameter("objectId");
            CommentStatus commentListStatus = null;
            if (status.equals(CommentStatus.LATEST.getStatus())) {
                commentListStatus = CommentStatus.LATEST;
            } else if (status.equals(CommentStatus.ALL.getStatus())) {
                commentListStatus = CommentStatus.ALL;
            } else if (status.equals(CommentStatus.NONE.getStatus())) {
                commentListStatus = CommentStatus.NONE;
            }
            if (commentListStatus != null) {
                uiActivity.setCommentListStatus(commentListStatus);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LikeActivityActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            uiActivity.refresh();
            WebuiRequestContext requestContext = event.getRequestContext();
            String isLikedStr = requestContext.getRequestParameter("objectId");
            boolean isLiked = Boolean.parseBoolean(isLikedStr);
            uiActivity.setLike(isLiked, requestContext.getRemoteUser());
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToggleDisplayLikesActionListener
    extends EventListener<BaseUIActivity> {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            BaseUIActivity uiActivity = (BaseUIActivity)((Object)event.getSource());
            uiActivity.refresh();
            if (uiActivity.isLikesDisplayed()) {
                uiActivity.setLikesDisplayed(false);
            } else {
                uiActivity.setLikesDisplayed(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActivity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommentStatus {
        LATEST("latest"),
        ALL("all"),
        NONE("none");

        private String commentStatus;

        public String getStatus() {
            return this.commentStatus;
        }

        private CommentStatus(String status) {
            this.commentStatus = status;
        }
    }
}

