/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.activity.model.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/profile/UIUserActivitiesDisplay.gtmpl", events={@EventConfig(listeners={ChangeDisplayModeActionListener.class})})
public class UIUserActivitiesDisplay
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIUserActivitiesDisplay.class);
    private DisplayMode selectedDisplayMode = DisplayMode.CONNECTIONS;
    private String ownerName;
    private SortedSet<Activity> sortedActivityList;
    private int displayedActivityItems = 20;
    private List<Activity> activityList;
    private UIActivitiesContainer uiActivitiesContainer;

    public int getDisplayedActivityItems() {
        return this.displayedActivityItems;
    }

    public void setDisplayedActivityItems(int itemsNumber) {
        this.displayedActivityItems = itemsNumber;
    }

    public void setSelectedDisplayMode(DisplayMode displayMode) {
        this.selectedDisplayMode = displayMode;
        try {
            this.init();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to init()");
        }
    }

    public DisplayMode getSelectedDisplayMode() {
        return this.selectedDisplayMode;
    }

    public void setOwnerName(String ownerName) throws Exception {
        this.ownerName = ownerName;
        this.init();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void init() throws Exception {
        Validate.notNull((Object)this.ownerName, (String)"ownerName must not be null.");
        Identity ownerIdentity = this.getIdentityManager().getOrCreateIdentity("organization", this.ownerName);
        this.activityList = new ArrayList<Activity>();
        this.sortedActivityList = new TreeSet<Activity>(Util.activityComparator());
        if (this.getSelectedDisplayMode() == DisplayMode.MY_STATUS) {
            this.activityList = this.getActivityManager().getActivities(ownerIdentity);
        } else if (this.getSelectedDisplayMode() == DisplayMode.SPACES) {
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            ActivityManager activityManager = this.getActivityManager();
            IdentityManager identityManager = this.getIdentityManager();
            try {
                List spaceList = spaceService.getAccessibleSpaces(this.ownerName);
                for (Space space : spaceList) {
                    Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getId());
                    List spaceActivityList = activityManager.getActivities(spaceIdentity);
                    this.sortedActivityList.addAll(spaceActivityList);
                }
                Object[] activityArray = this.sortedActivityList.toArray();
                if (this.sortedActivityList.size() > this.displayedActivityItems) {
                    activityArray = ArrayUtils.subarray((Object[])activityArray, (int)0, (int)this.displayedActivityItems);
                }
                for (Object obj : activityArray) {
                    this.activityList.add((Activity)obj);
                }
            }
            catch (SpaceException e) {
                LOG.error((Object)("failed to get spaceList by userId: " + this.ownerName));
            }
            catch (Exception e) {
                LOG.error((Object)"failed to init() in UIMySpacesActivitiesDisplay");
            }
        } else {
            List<Identity> connectionsList = this.getConnections();
            ActivityManager activityManager = this.getActivityManager();
            for (Identity identity : connectionsList) {
                this.sortedActivityList.addAll(activityManager.getActivities(identity));
            }
            Object[] activityArray = this.sortedActivityList.toArray();
            if (this.sortedActivityList.size() > this.displayedActivityItems) {
                activityArray = ArrayUtils.subarray((Object[])activityArray, (int)0, (int)this.displayedActivityItems);
            }
            for (Object obj : activityArray) {
                this.activityList.add((Activity)obj);
            }
        }
        this.removeChild(UIActivitiesContainer.class);
        this.uiActivitiesContainer = (UIActivitiesContainer)this.addChild(UIActivitiesContainer.class, null, null);
        this.uiActivitiesContainer.setPostContext(UIComposer.PostContext.USER);
        this.uiActivitiesContainer.setOwnerName(this.ownerName);
        this.uiActivitiesContainer.setActivityList(this.activityList);
    }

    private List<Identity> getConnections() throws Exception {
        List connectionsList = this.getIdentityManager().getIdentities("organization");
        Iterator itr = connectionsList.iterator();
        while (itr.hasNext()) {
            Identity identity = (Identity)itr.next();
            if (this.getConnectionStatus(identity) == Relationship.Type.CONFIRM) continue;
            itr.remove();
        }
        return connectionsList;
    }

    private Relationship.Type getConnectionStatus(Identity identity) throws Exception {
        if (identity.getId().equals(this.getOwnerIdentity().getId())) {
            return Relationship.Type.SELF;
        }
        RelationshipManager relationshipManager = this.getRelationshipManger();
        Relationship relationship = relationshipManager.getRelationship(identity, this.getOwnerIdentity());
        return relationshipManager.getRelationshipStatus(relationship, this.getOwnerIdentity());
    }

    private Identity getOwnerIdentity() throws Exception {
        IdentityManager identityManger = this.getIdentityManager();
        return identityManger.getOrCreateIdentity("organization", this.ownerName);
    }

    private IdentityManager getIdentityManager() {
        return (IdentityManager)this.getApplicationComponent(IdentityManager.class);
    }

    private ActivityManager getActivityManager() {
        return (ActivityManager)this.getApplicationComponent(ActivityManager.class);
    }

    private RelationshipManager getRelationshipManger() {
        return (RelationshipManager)this.getApplicationComponent(RelationshipManager.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeDisplayModeActionListener
    extends EventListener<UIUserActivitiesDisplay> {
        public void execute(Event<UIUserActivitiesDisplay> event) throws Exception {
            UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String selectedDisplayMode = requestContext.getRequestParameter("objectId");
            if (selectedDisplayMode.equals(DisplayMode.MY_STATUS.toString())) {
                uiUserActivitiesDisplay.setSelectedDisplayMode(DisplayMode.MY_STATUS);
            } else if (selectedDisplayMode.equals(DisplayMode.SPACES.toString())) {
                uiUserActivitiesDisplay.setSelectedDisplayMode(DisplayMode.SPACES);
            } else {
                uiUserActivitiesDisplay.setSelectedDisplayMode(DisplayMode.CONNECTIONS);
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiUserActivitiesDisplay);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayMode {
        CONNECTIONS,
        SPACES,
        MY_STATUS;

    }
}

