/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

public class UISpaceSettings
extends UIFormInputSet {
    private final String SPACE_NAME = "name";
    private final String SPACE_PRIORITY = "priority";
    private final String SPACE_DESCRIPTION = "description";
    private final String PRIORITY_HIGH = "high";
    private final String PRIORITY_INTERMEDIATE = "intermediate";
    private final String PRIORITY_LOW = "low";
    private final String MSG_INVALID_SPACE_NAME = "UISpaceSettings.msg.invalid_space_name";

    public UISpaceSettings(String name) throws Exception {
        super(name);
        this.addUIFormInput((UIFormInput)new UIFormStringInput("name", "name", null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^([\\p{L}\\d]+[\\s]?)+$", "UISpaceSettings.msg.invalid_space_name"}).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
        ArrayList<SelectItemOption> priorityList = new ArrayList<SelectItemOption>(3);
        SelectItemOption pHight = new SelectItemOption("high", (Object)"1");
        SelectItemOption pImmediate = new SelectItemOption("intermediate", (Object)"2");
        SelectItemOption pLow = new SelectItemOption("low", (Object)"3");
        priorityList.add(pHight);
        priorityList.add(pImmediate);
        priorityList.add(pLow);
        pImmediate.setSelected(true);
        UIFormSelectBox selectPriority = new UIFormSelectBox("priority", "priority", priorityList);
        this.addUIFormInput((UIFormInput)selectPriority);
        UIFormInputInfo priorityInfo = new UIFormInputInfo("Priority", null, null);
        WebuiRequestContext webReqCtx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resApp = webReqCtx.getApplicationResourceBundle();
        String interMePrio = resApp.getString("UISpaceSettings.label.InterMePrio");
        priorityInfo.setValue((Object)interMePrio);
        this.addUIFormInput((UIFormInput)priorityInfo);
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput("description", "description", null).addValidator(StringLengthValidator.class, new Object[]{0, 255}));
    }
}

