/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;

@Path(value="{portalName}/social/spaces")
public class SpacesRestService
implements ResourceContainer {
    private SpaceService _spaceService;
    private IdentityManager _identityManager;

    private SpaceList showMySpaceList(String userId, String portalName) {
        List mySpaces;
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService(portalName);
        try {
            mySpaces = this._spaceService.getSpaces(userId);
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(mySpaces);
        return spaceList;
    }

    private SpaceList showPendingSpaceList(String userId, String portalName) {
        List pendingSpaces;
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService(portalName);
        try {
            pendingSpaces = this._spaceService.getPendingSpaces(userId);
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(pendingSpaces);
        return spaceList;
    }

    @GET
    @Path(value="mySpaces/show.{format}")
    public Response showMySpaceList(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        ConversationState state = ConversationState.getCurrent();
        String userId = null;
        userId = state != null ? state.getIdentity().getUserId() : this.getRemoteId(uriInfo, portalName);
        SpaceList mySpaceList = this.showMySpaceList(userId, portalName);
        return Util.getResponse(mySpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="pendingSpaces/show.{format}")
    public Response showPendingSpaceList(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format) throws Exception {
        String remoteId;
        MediaType mediaType = Util.getMediaType(format);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        if (!userId.equals(remoteId = this.getRemoteId(uriInfo, portalName))) {
            return null;
        }
        SpaceList pendingSpaceList = this.showPendingSpaceList(userId, portalName);
        return Util.getResponse(pendingSpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    private SpaceService getSpaceService(String portalName) {
        PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)portalName);
        return (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
    }

    private String getRemoteId(UriInfo uriInfo, String portalName) throws Exception {
        String viewerId = Util.getViewerId(uriInfo);
        Identity identity = this.getIdentityManager(portalName).getIdentity(viewerId);
        return identity.getRemoteId();
    }

    private IdentityManager getIdentityManager(String portalName) {
        if (this._identityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)portalName);
            this._identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this._identityManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class SpaceList {
        private List<Space> _spaces;

        public void setSpaces(List<Space> spaces) {
            this._spaces = spaces;
        }

        public List<Space> getSpaces() {
            return this._spaces;
        }

        public void addSpace(Space space) {
            if (this._spaces == null) {
                this._spaces = new ArrayList<Space>();
            }
            this._spaces.add(space);
        }
    }
}

