/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexInputStream;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.IndexOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexInfos {
    public static final String DEFALUT_NAME = "indexes";
    private int counter = 0;
    private boolean dirty = false;
    private List<String> indexes = new ArrayList<String>();
    private Set<String> names = new HashSet<String>();
    private final String name;
    private Directory dir;
    private MultiIndex multiIndex;

    public IndexInfos() {
        this(DEFALUT_NAME);
    }

    public IndexInfos(String fileName) {
        this.name = fileName;
    }

    public String getFileName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        this.names.clear();
        this.indexes.clear();
        if (this.dir.fileExists(this.name)) {
            IndexInputStream in = new IndexInputStream(this.dir.openInput(this.name));
            try {
                DataInputStream di = new DataInputStream(in);
                this.counter = di.readInt();
                for (int i = di.readInt(); i > 0; --i) {
                    String indexName = di.readUTF();
                    this.indexes.add(indexName);
                    this.names.add(indexName);
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        if (!this.dirty) {
            return;
        }
        IndexOutputStream out = new IndexOutputStream(this.dir.createOutput(this.name + ".new"));
        try {
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(this.counter);
            dataOut.writeInt(this.indexes.size());
            for (int i = 0; i < this.indexes.size(); ++i) {
                dataOut.writeUTF(this.getName(i));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)out).close();
            throw throwable;
        }
        ((OutputStream)out).close();
        if (this.dir.fileExists(this.name)) {
            this.dir.deleteFile(this.name);
        }
        this.dir.renameFile(this.name + ".new", this.name);
        this.dirty = false;
    }

    public String getName(int i) {
        return this.indexes.get(i);
    }

    public Set<String> getNames() {
        return new HashSet<String>(this.indexes);
    }

    public int size() {
        return this.indexes.size();
    }

    public void addName(String name) {
        if (this.names.contains(name)) {
            throw new IllegalArgumentException("already contains: " + name);
        }
        this.indexes.add(name);
        this.names.add(name);
        this.dirty = true;
    }

    public void removeName(String name) {
        this.indexes.remove(name);
        this.names.remove(name);
        this.dirty = true;
    }

    public void removeName(int i) {
        String name = this.indexes.remove(i);
        this.names.remove(name);
        this.dirty = true;
    }

    public boolean contains(String name) {
        return this.names.contains(name);
    }

    public String newName() {
        this.dirty = true;
        return "_" + Integer.toString(this.counter++, 36);
    }

    public void setDirectory(Directory dir) {
        this.dir = dir;
    }

    protected void setNames(Set<String> names) {
        this.names.clear();
        this.indexes.clear();
        this.names.addAll(names);
        this.indexes.addAll(names);
        this.dirty = false;
    }

    public void setMultiIndex(MultiIndex multiIndex) {
        this.multiIndex = multiIndex;
    }

    public MultiIndex getMultiIndex() {
        return this.multiIndex;
    }

    protected boolean isDirty() {
        return this.dirty;
    }
}

