/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import javax.jcr.Node;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.plugin.doc.UIDocActivity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class DocUIActivityBuilder
extends BaseUIActivityBuilder {
    private static final Log LOG = ExoLogger.getLogger(DocUIActivityBuilder.class);

    protected void extendUIActivity(BaseUIActivity uiActivity, Activity activity) {
        UIDocActivity docActivity = (UIDocActivity)uiActivity;
        String jsonData = activity.getTitle();
        try {
            JSONObject jsonObject = new JSONObject(jsonData);
            docActivity.docLink = jsonObject.getString("DOCLINK");
            docActivity.docName = jsonObject.getString("DOCNAME");
            docActivity.message = jsonObject.getString("MESSAGE");
            docActivity.docPath = jsonObject.getString("DOCPATH");
            String repository = jsonObject.getString("REPOSITORY");
            String workspace = jsonObject.getString("WORKSPACE");
            NodeLocation nodeLocation = new NodeLocation(repository, workspace, docActivity.docPath);
            Node docNode = NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
            docActivity.setDocNode(docNode);
        }
        catch (JSONException e) {
            LOG.error((Object)e);
        }
    }
}

