/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.queries;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.queries.UIQueriesList;
import org.exoplatform.ecm.webui.component.admin.queries.UIQueriesManager;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeQueryTypeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddPermissionActionListener.class})})
public class UIQueriesForm
extends UIForm
implements UISelectable {
    public static final String QUERY_NAME = "name";
    public static final String QUERY_TYPE = "type";
    public static final String STATEMENT = "statement";
    public static final String PERMISSIONS = "permissions";
    public static final String CACHE_RESULT = "cache";
    public static final String[] ACTIONS = new String[]{"Save", "Cancel"};
    public static final String SQL_QUERY = "select * from exo:article where jcr:path like '/Documents/Live/%'";
    public static final String XPATH_QUERY = "/jcr:root/Documents/Live//element(*, exo:article)";
    public static final String[] REG_EXPRESSION = new String[]{"[", "]", ":", "&"};
    private boolean isAddNew_ = false;

    public UIQueriesForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(QUERY_NAME, QUERY_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption("xPath", (Object)"xpath"));
        ls.add(new SelectItemOption("SQL", (Object)"sql"));
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(QUERY_TYPE, QUERY_TYPE, ls);
        uiSelectBox.setOnChange("ChangeQueryType");
        this.addUIFormInput((UIFormInput)uiSelectBox);
        UIFormTextAreaInput uiStatement = new UIFormTextAreaInput(STATEMENT, STATEMENT, null);
        uiStatement.setValue((Object)XPATH_QUERY);
        uiStatement.addValidator(MandatoryValidator.class, new Object[0]);
        this.addUIFormInput((UIFormInput)uiStatement);
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(CACHE_RESULT, CACHE_RESULT, null));
        UIFormInputSetWithAction uiInputAct = new UIFormInputSetWithAction("PermissionButton");
        uiInputAct.addUIFormInput((UIFormInput)new UIFormStringInput(PERMISSIONS, PERMISSIONS, null).setEditable(false).addValidator(MandatoryValidator.class, new Object[0]));
        uiInputAct.setActionInfo(PERMISSIONS, new String[]{"AddPermission"});
        this.addUIComponentInput((UIComponent)uiInputAct);
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void doSelect(String selectField, Object value) {
        this.getUIStringInput(selectField).setValue((Object)value.toString());
        UIQueriesManager uiManager = (UIQueriesManager)this.getAncestorOfType(UIQueriesManager.class);
        UIPopupWindow uiPopup = (UIPopupWindow)uiManager.getChildById("PermissionPopup");
        uiManager.removeChildById("PermissionPopup");
    }

    public void setIsAddNew(boolean isAddNew) {
        this.isAddNew_ = isAddNew;
    }

    public void update(String queryName) throws Exception {
        this.isAddNew_ = false;
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        if (queryName == null) {
            this.isAddNew_ = true;
            this.reset();
            return;
        }
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        Node query = queryService.getSharedQuery(queryName, repository, SessionProviderFactory.createSystemProvider());
        this.getUIStringInput(QUERY_NAME).setValue((Object)queryName);
        this.getUIStringInput(QUERY_NAME).setEditable(false);
        if (query.hasProperty("exo:cachedResult")) {
            this.getUIFormCheckBoxInput(CACHE_RESULT).setChecked(query.getProperty("exo:cachedResult").getBoolean());
        } else {
            this.getUIFormCheckBoxInput(CACHE_RESULT).setChecked(false);
        }
        if (query.hasProperty("jcr:statement")) {
            this.getUIFormTextAreaInput(STATEMENT).setValue((Object)query.getProperty("jcr:statement").getString());
        }
        if (query.hasProperty("jcr:language")) {
            this.getUIFormSelectBox(QUERY_TYPE).setValue(query.getProperty("jcr:language").getString());
        }
        if (query.hasProperty("exo:accessPermissions")) {
            Value[] values = query.getProperty("exo:accessPermissions").getValues();
            StringBuilder strValues = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                if (strValues.length() > 0) {
                    strValues = strValues.append(",");
                }
                strValues = strValues.append(values[i].getString());
            }
            this.getUIStringInput(PERMISSIONS).setValue((Object)strValues.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPermissionActionListener
    extends EventListener<UIQueriesForm> {
        public void execute(Event<UIQueriesForm> event) throws Exception {
            UIQueriesManager uiManager = (UIQueriesManager)((UIQueriesForm)((Object)event.getSource())).getAncestorOfType(UIQueriesManager.class);
            String membership = (String)((UIQueriesForm)((Object)event.getSource())).getUIStringInput(UIQueriesForm.PERMISSIONS).getValue();
            uiManager.initPermissionPopup(membership);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeQueryTypeActionListener
    extends EventListener<UIQueriesForm> {
        public void execute(Event<UIQueriesForm> event) throws Exception {
            UIQueriesForm uiForm = (UIQueriesForm)((Object)event.getSource());
            String queryType = (String)uiForm.getUIFormSelectBox(UIQueriesForm.QUERY_TYPE).getValue();
            if (queryType.equals("xpath")) {
                uiForm.getUIFormTextAreaInput(UIQueriesForm.STATEMENT).setValue((Object)UIQueriesForm.XPATH_QUERY);
            } else {
                uiForm.getUIFormTextAreaInput(UIQueriesForm.STATEMENT).setValue((Object)UIQueriesForm.SQL_QUERY);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIQueriesForm> {
        public void execute(Event<UIQueriesForm> event) throws Exception {
            UIQueriesForm uiForm = (UIQueriesForm)((Object)event.getSource());
            String repository = ((UIECMAdminPortlet)uiForm.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            QueryService queryService = (QueryService)uiForm.getApplicationComponent(QueryService.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String queryName = ((String)uiForm.getUIStringInput(UIQueriesForm.QUERY_NAME).getValue()).trim();
            if (uiForm.isAddNew_) {
                for (Node queryNode : queryService.getSharedQueries(repository, SessionProviderFactory.createSystemProvider())) {
                    if (!queryNode.getName().equals(queryName)) continue;
                    uiApp.addMessage(new ApplicationMessage("UIQueriesForm.msg.name-existing", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            if (!Utils.isNameValid((String)queryName, (String[])REG_EXPRESSION)) {
                uiApp.addMessage(new ApplicationMessage("UIQueriesForm.msg.name-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String statement = (String)uiForm.getUIFormTextAreaInput(UIQueriesForm.STATEMENT).getValue();
            UIFormInputSetWithAction permField = (UIFormInputSetWithAction)uiForm.getChildById("PermissionButton");
            String permissions = (String)permField.getUIStringInput(UIQueriesForm.PERMISSIONS).getValue();
            if (permissions == null || permissions.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIQueriesForm.msg.permission-require", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String queryType = (String)uiForm.getUIFormSelectBox(UIQueriesForm.QUERY_TYPE).getValue();
            boolean cacheResult = uiForm.getUIFormCheckBoxInput(UIQueriesForm.CACHE_RESULT).isChecked();
            try {
                if (permissions.indexOf(",") > -1) {
                    queryService.addSharedQuery(queryName, statement, queryType, permissions.split(","), cacheResult, repository);
                } else {
                    queryService.addSharedQuery(queryName, statement, queryType, new String[]{permissions}, cacheResult, repository);
                }
            }
            catch (InvalidQueryException qe) {
                uiApp.addMessage(new ApplicationMessage("UIQueriesForm.msg.invalid-query", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UIQueriesManager uiManager = (UIQueriesManager)uiForm.getAncestorOfType(UIQueriesManager.class);
            ((UIQueriesList)uiManager.getChild(UIQueriesList.class)).updateQueriesGrid(1);
            uiManager.removeChildById("AddQueryForm");
            uiManager.removeChildById("EditQueryForm");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIQueriesForm> {
        public void execute(Event<UIQueriesForm> event) throws Exception {
            UIQueriesForm uiForm = (UIQueriesForm)((Object)event.getSource());
            UIQueriesManager uiManager = (UIQueriesManager)uiForm.getAncestorOfType(UIQueriesManager.class);
            uiManager.removeChildById("AddQueryForm");
            uiManager.removeChildById("EditQueryForm");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

