/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core.impl;

import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WebSchemaModificationAction
implements Action {
    private Log log = ExoLogger.getLogger((String)"wcm:WebSchemaModificationAction");

    public boolean execute(Context context) throws Exception {
        Property property = (Property)context.get((Object)"currentItem");
        String propertyName = property.getName();
        if (!propertyName.equals("jcr:data")) {
            return propertyName.equalsIgnoreCase("exo:active");
        }
        Node grandParent = property.getParent().getParent();
        if (!grandParent.getPrimaryNodeType().getName().equals("nt:file")) {
            return false;
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)container.getComponentInstanceOfType(WebSchemaConfigService.class);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        try {
            schemaConfigService.updateSchemaOnModify(sessionProvider, grandParent);
        }
        catch (Exception e) {
            this.log.error((Object)("Error when update schema when modify node: " + grandParent.getPath()), e.fillInStackTrace());
        }
        return true;
    }
}

