/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.property;

import java.text.ParseException;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.parameter.TzId;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.util.ParameterValidator;
import net.fortuna.ical4j.util.Strings;

public abstract class DateProperty
extends Property {
    private Date date;
    protected TimeZone timezone;

    public DateProperty(String name, ParameterList parameters) {
        super(name, parameters);
    }

    public DateProperty(String name) {
        super(name);
    }

    public final Date getDate() {
        return this.date;
    }

    public final void setDate(Date date) {
        if (date instanceof DateTime) {
            this.setTimeZone(((DateTime)date).getTimeZone());
        }
        this.date = date;
    }

    public void setValue(String value) throws ParseException {
        this.date = Value.DATE.equals(this.getParameter("VALUE")) ? new Date(value) : new DateTime(value, this.timezone);
    }

    public String getValue() {
        return Strings.valueOf(this.getDate());
    }

    public final void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
        if (timezone != null) {
            if (this.getDate() != null && !(this.getDate() instanceof DateTime)) {
                throw new UnsupportedOperationException("TimeZone is not applicable to current value");
            }
            if (this.getDate() != null) {
                ((DateTime)this.getDate()).setTimeZone(timezone);
            }
            this.getParameters().remove(this.getParameter("TZID"));
            TzId tzId = new TzId(timezone.getID());
            this.getParameters().replace(tzId);
        } else {
            this.setUtc(false);
        }
    }

    public final void setUtc(boolean utc) {
        if (this.getDate() != null && !(this.getDate() instanceof DateTime)) {
            throw new UnsupportedOperationException("UTC time is not applicable to current value");
        }
        if (this.getDate() != null) {
            ((DateTime)this.getDate()).setUtc(utc);
        }
        this.getParameters().remove(this.getParameter("TZID"));
    }

    public final boolean isUtc() {
        if (this.getDate() instanceof DateTime) {
            return ((DateTime)this.getDate()).isUtc();
        }
        return false;
    }

    public void validate() throws ValidationException {
        ParameterValidator.getInstance().assertOneOrLess("VALUE", this.getParameters());
        if (this.isUtc()) {
            ParameterValidator.getInstance().assertNone("TZID", this.getParameters());
        } else {
            ParameterValidator.getInstance().assertOneOrLess("TZID", this.getParameters());
        }
        Value value = (Value)this.getParameter("VALUE");
        if (this.getDate() instanceof DateTime) {
            if (value != null && !Value.DATE_TIME.equals(value)) {
                throw new ValidationException("VALUE parameter [" + value + "] is invalid for DATE-TIME instance");
            }
            DateTime dateTime = (DateTime)this.date;
            Parameter tzId = this.getParameter("TZID");
            if (!(dateTime.getTimeZone() == null || tzId != null && tzId.getValue().equals(dateTime.getTimeZone().getID()))) {
                throw new ValidationException("TZID parameter [" + tzId + "] does not match the timezone [" + dateTime.getTimeZone().getID() + "]");
            }
        } else if (this.getDate() != null) {
            if (value == null) {
                throw new ValidationException("VALUE parameter [" + Value.DATE + "] must be specified for DATE instance");
            }
            if (!Value.DATE.equals(value)) {
                throw new ValidationException("VALUE parameter [" + value + "] is invalid for DATE instance");
            }
        }
    }
}

