/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.AtomUtils;
import org.xcmis.restatom.abdera.QueryTypeElement;
import org.xcmis.restatom.collections.CmisObjectCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsList;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCollection
extends CmisObjectCollection {
    public QueryCollection() {
        this.setHref("/query");
    }

    @Override
    public String getId(RequestContext request) {
        return "cmis:query:" + this.getRepositoryId(request);
    }

    public Iterable<CmisObject> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("entries");
    }

    public String getTitle(RequestContext request) {
        return "Query";
    }

    @Override
    protected Feed createFeedBase(RequestContext request) throws ResponseContextException {
        Factory factory = request.getAbdera().getFactory();
        Feed feed = factory.newFeed();
        feed.setId(this.getId(request));
        feed.setTitle(this.getTitle(request));
        feed.addAuthor(this.getAuthor(request));
        feed.setUpdated(AtomUtils.getAtomDate(Calendar.getInstance()));
        feed.addLink(this.getServiceLink(request), "service", "application/atomsvc+xml", null, null, -1L);
        return feed;
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            int maxItems = Integer.MAX_VALUE;
            int skipCount = 0;
            String q = null;
            String renditionFilter = "cmis:none";
            boolean isSearchAllVersions = false;
            IncludeRelationships includeRelationships = IncludeRelationships.NONE;
            boolean isIncludeAllowableActions = false;
            Document doc = null;
            try {
                doc = request.getDocument();
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (doc == null) {
                q = request.getParameter("q");
                try {
                    q = URLDecoder.decode(q, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                maxItems = this.getIntegerParameter(request, "maxItems", Integer.MAX_VALUE);
                skipCount = this.getIntegerParameter(request, "skipCount", 0);
                renditionFilter = request.getParameter("renditionFilter");
            } else {
                QueryTypeElement queryElement = (QueryTypeElement)doc.getRoot();
                if (queryElement != null) {
                    Query query = queryElement.getQuery();
                    q = query.getStatement();
                    maxItems = queryElement.getPageSize();
                    skipCount = queryElement.getSkipCount();
                    renditionFilter = queryElement.getRenditionFilter();
                    isSearchAllVersions = queryElement.isSearchAllVersions();
                    includeRelationships = queryElement.getIncludeRelationships();
                    isIncludeAllowableActions = queryElement.isIncludeAllowableActions();
                } else {
                    String msg = "Invalid parameter. There are no query request parameters or post body.";
                    throw new ResponseContextException(msg, 400);
                }
            }
            ItemsList list = conn.query(q, isSearchAllVersions, isIncludeAllowableActions, includeRelationships, true, renditionFilter, maxItems, skipCount);
            this.addPageLinks(q, feed, "query", maxItems, skipCount, list.getNumItems(), list.isHasMoreItems(), request);
            if (list.getItems().size() > 0) {
                if (list.getNumItems() != -1) {
                    Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                    numItems.setText(Integer.toString(list.getNumItems()));
                }
                for (CmisObject oif : list.getItems()) {
                    Entry e = feed.addEntry();
                    IRI feedIri = new IRI(this.getFeedIriForEntry(oif, request));
                    this.addEntryDetails(request, e, feedIri, oif);
                }
            }
        }
        catch (FilterNotValidException fe) {
            throw new ResponseContextException(this.createErrorResponse(fe, 400));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 404));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Override
    protected void addPageLinks(String q, Feed feed, String atomdocType, int maxItems, int skipCount, int total, boolean hasMore, RequestContext request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("repoid", this.getRepositoryId(request));
        params.put("atomdoctype", atomdocType);
        params.put("q", q);
        params.put("skipCount", "0");
        params.put("maxItems", Integer.toString(skipCount == 0 ? maxItems : (maxItems < skipCount ? maxItems : skipCount)));
        feed.addLink(request.absoluteUrlFor((Object)"feed", params), "first", "application/atom+xml;type=feed", null, null, -1L);
        if (skipCount > 0) {
            params.put("maxItems", Integer.toString(maxItems < skipCount ? maxItems : skipCount));
            params.put("skipCount", Integer.toString(maxItems < skipCount ? skipCount - maxItems : 0));
            feed.addLink(request.absoluteUrlFor((Object)"feed", params), "previous", "application/atom+xml;type=feed", null, null, -1L);
        }
        if (hasMore) {
            params.put("skipCount", Integer.toString(skipCount + maxItems));
            params.put("maxItems", Integer.toString(maxItems));
            feed.addLink(request.absoluteUrlFor((Object)"feed", params), "next", "application/atom+xml;type=feed", null, null, -1L);
            if (total > 0) {
                int pages = (total - skipCount) / maxItems;
                int rem = (total - skipCount) % maxItems;
                if (rem == 0) {
                    skipCount = total - maxItems;
                } else if (pages != 0) {
                    skipCount += pages * maxItems;
                }
                params.put("skipCount", Integer.toString(skipCount));
                params.put("maxItems", Integer.toString(maxItems));
                feed.addLink(request.absoluteUrlFor((Object)"feed", params), "last", "application/atom+xml;type=feed", null, null, -1L);
            }
        }
    }
}

