/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.download;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.ide.download.Const;
import org.exoplatform.ide.download.DirectoryContentEntity;
import org.exoplatform.ide.download.NodeTypeUtil;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/services/downloadcontent")
public class DownloadContentService
implements Const,
ResourceContainer {
    private static final String MODIFICATION_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    private static final String APPLICATION_OCTETSTREAM = "application/octet-stream";
    private String WEBDAV_CONTEXT = "jcr";
    private static Log log = ExoLogger.getLogger(DownloadContentService.class);
    private RepositoryService repositoryService;
    private ThreadLocalSessionProviderService sessionProviderService;

    public DownloadContentService(RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    protected String normalizePath(String repoPath) {
        if (repoPath.length() > 0 && repoPath.endsWith("/")) {
            return repoPath.substring(0, repoPath.length() - 1);
        }
        String[] pathElements = repoPath.split("/");
        StringBuffer escapedPath = new StringBuffer();
        for (String element : pathElements) {
            try {
                if (element.contains("[")) {
                    element = element.replaceAll("\\[", URLEncoder.encode("[", "UTF-8"));
                }
                if (element.contains("]")) {
                    element = element.replaceAll("]", URLEncoder.encode("]", "UTF-8"));
                }
                if (element.contains("'")) {
                    element = element.replaceAll("'", URLEncoder.encode("'", "UTF-8"));
                }
                if (element.contains("\"")) {
                    element = element.replaceAll("\"", URLEncoder.encode("\"", "UTF-8"));
                }
                escapedPath.append(element + "/");
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
        return escapedPath.toString().substring(0, escapedPath.length() - 1);
    }

    protected String path(String repoPath) {
        String path = repoPath.substring(this.workspaceName(repoPath).length());
        if (!"".equals(path)) {
            return path;
        }
        return "/";
    }

    protected String workspaceName(String repoPath) {
        return repoPath.split("/")[0];
    }

    private Session getSession(String repoName, String repoPath) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository repo = this.repositoryService.getRepository(repoName);
        SessionProvider sp = this.sessionProviderService.getSessionProvider(null);
        if (sp == null) {
            throw new RepositoryException("SessionProvider is not properly set. Make the application callsSessionProviderService.setSessionProvider(..) somewhere before (for instance in Servlet Filter for WEB application)");
        }
        return sp.getSession(this.workspaceName(repoPath), repo);
    }

    @GET
    @Path(value="/{fileName:.*}/")
    public Response download(@Context UriInfo uriInfo, @PathParam(value="fileName") String fileName, @QueryParam(value="repoPath") String repoPath) {
        String href = uriInfo.getBaseUri().toASCIIString() + "/" + this.WEBDAV_CONTEXT + "/";
        if (!repoPath.startsWith(href)) {
            return Response.status((int)404).entity((Object)repoPath).build();
        }
        if ((repoPath = repoPath.substring(href.length())).startsWith("/")) {
            repoPath = repoPath.substring(1);
        }
        repoPath = this.normalizePath(repoPath);
        String repoName = repoPath.substring(0, repoPath.indexOf("/"));
        repoPath = repoPath.substring(1);
        repoPath = repoPath.substring(repoPath.indexOf("/") + 1);
        try {
            Session session = this.getSession(repoName, repoPath);
            Node node = (Node)session.getItem(this.path(repoPath));
            if (NodeTypeUtil.isFile(node)) {
                return this.getFile(node);
            }
            return this.getFolder(node, repoPath);
        }
        catch (PathNotFoundException exc) {
            log.error((Object)("NoSuchWorkspaceException " + exc.getMessage()), (Throwable)exc);
            return Response.status((int)404).entity((Object)exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }

    private Response getFile(Node node) throws RepositoryException, UnsupportedEncodingException, URISyntaxException {
        long contentLength = node.getNode("jcr:content").getProperty("jcr:data").getLength();
        String contentType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        Calendar modified = node.getNode("jcr:content").getProperty("jcr:lastModified").getDate();
        SimpleDateFormat dateFormat = new SimpleDateFormat(MODIFICATION_PATTERN, Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String modifiedValue = dateFormat.format(modified.getTime());
        InputStream inputStream = node.getNode("jcr:content").getProperty("jcr:data").getStream();
        String contentDisposition = "attachment";
        return Response.ok().header("Content-Length", (Object)Long.toString(contentLength)).header("Last-Modified", (Object)modifiedValue).header(HEADER_CONTENT_DISPOSITION, (Object)contentDisposition).entity((Object)inputStream).type(contentType).build();
    }

    private Response getFolder(Node node, String repoPath) throws RepositoryException {
        String contentDisposition = "attachment";
        DirectoryContentEntity entity = new DirectoryContentEntity(node);
        return Response.ok().header(HEADER_CONTENT_DISPOSITION, (Object)contentDisposition).entity((Object)entity).type(APPLICATION_OCTETSTREAM).build();
    }
}

