/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.service;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class LinkProvider {
    private IdentityManager identityManager;
    private static Log LOG = ExoLogger.getLogger(LinkProvider.class);

    public LinkProvider(InitParams params, IdentityManager identityManager) {
        this.identityManager = identityManager;
        this.init(params);
    }

    private void init(InitParams params) {
    }

    public String getProfileUri(String username, String portalOwner) {
        String url = username;
        try {
            Identity identity = this.identityManager.getIdentity("organization:" + username, true);
            if (identity == null) {
                throw new RuntimeException("could not find a user identity for " + username);
            }
            String container = PortalContainer.getCurrentPortalContainerName();
            if (portalOwner == null || portalOwner.equals("")) {
                PortalRequestContext context = Util.getPortalRequestContext();
                portalOwner = context.getPortalOwner();
            }
            url = "/" + container + "/private/" + portalOwner + "/profile/" + identity.getRemoteId();
        }
        catch (Exception e) {
            LOG.error((Object)("failed to substitute username for " + username + ": " + e.getMessage()));
        }
        return url;
    }

    public String getProfileLink(String username, String portalOwner) {
        String link = username;
        try {
            Identity identity = this.identityManager.getIdentity("organization:" + username, true);
            if (identity == null) {
                throw new RuntimeException("could not find a user identity for " + username);
            }
            String container = PortalContainer.getCurrentPortalContainerName();
            if (portalOwner == null || portalOwner.equals("")) {
                PortalRequestContext context = Util.getPortalRequestContext();
                portalOwner = context.getPortalOwner();
            }
            String url = "/" + container + "/private/" + portalOwner + "/profile/" + identity.getRemoteId();
            link = "<a href=\"" + url + "\" target=\"_parent\">" + identity.getProfile().getFullName() + "</a>";
        }
        catch (Exception e) {
            LOG.error((Object)("failed to substitute username for " + username + ": " + e.getMessage()));
        }
        return link;
    }
}

