/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.social.webui.profile.UIProfileSection;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIHeaderSection.gtmpl", events={@EventConfig(listeners={UIProfileSection.EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class})})
public class UIHeaderSection
extends UIProfileSection {
    public static final String POSITION = "position";
    public static final String REGEX_EXPRESSION = "^\\p{L}[\\p{L}\\d._,\\s]+\\p{L}$";
    public static final String INVALID_CHAR_MESSAGE = "UIHeaderSection.msg.Invalid-char";

    public UIHeaderSection() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(POSITION, POSITION, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(ExpressionValidator.class, new Object[]{REGEX_EXPRESSION, INVALID_CHAR_MESSAGE}));
    }

    public User getViewUser() throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        if (currentViewer != null && currentViewer != currentUserName) {
            OrganizationService orgSer = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            UserHandler userHandler = orgSer.getUserHandler();
            return userHandler.findUserByName(currentViewer);
        }
        ConversationState state = ConversationState.getCurrent();
        return (User)state.getAttribute("UserProfile");
    }

    public void setValue() throws Exception {
        UIFormStringInput uiPosition = (UIFormStringInput)this.getChildById(POSITION);
        Profile profile = this.getProfile(false);
        String position = (String)profile.getProperty(POSITION);
        position = position == null ? "" : position;
        uiPosition.setValue((Object)position);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends UIProfileSection.SaveActionListener {
        @Override
        public void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIHeaderSection uiHeaderSect = (UIHeaderSection)sect;
            UIFormStringInput uiPosition = (UIFormStringInput)uiHeaderSect.getChildById(UIHeaderSection.POSITION);
            String position = (String)uiPosition.getValue();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            Profile p = uiHeaderSect.getProfile(true);
            p.setProperty(UIHeaderSection.POSITION, (Object)position);
            im.updateHeaderSection(p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIHeaderSection> {
        public void execute(Event<UIHeaderSection> event) throws Exception {
            UIHeaderSection uiHeader = (UIHeaderSection)((Object)event.getSource());
            uiHeader.setEditMode(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiHeader);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIHeaderSection> {
        public void execute(Event<UIHeaderSection> event) throws Exception {
            UIHeaderSection uiHeader = (UIHeaderSection)((Object)event.getSource());
            uiHeader.setEditMode(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiHeader);
        }
    }
}

