/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.templates.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplateConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class TemplatePlugin
extends BaseComponentPlugin {
    public static final String DIALOGS = "dialogs".intern();
    public static final String VIEWS = "views".intern();
    public static final String SKINS = "skins".intern();
    public static final String DEFAULT_DIALOG = "dialog1".intern();
    public static final String DEFAULT_VIEW = "view1".intern();
    static final String[] UNDELETABLE_TEMPLATES = new String[]{DEFAULT_DIALOG, DEFAULT_VIEW};
    public static final String DEFAULT_DIALOGS_PATH = "/" + DIALOGS + "/" + DEFAULT_DIALOG;
    public static final String DEFAULT_VIEWS_PATH = "/" + VIEWS + "/" + DEFAULT_VIEW;
    public static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    public static final String DOCUMENT_TEMPLATE_PROP = "isDocumentTemplate".intern();
    public static final String TEMPLATE_LABEL = "label".intern();
    public static final String[] EXO_ROLES_DEFAULT = new String[]{"*".intern()};
    private static final String NAME;
    private static final String COMMENT_TEMPLATE;
    private static final String HEADER_VIEW;
    private static final String JAVA_HEADER_VIEW;
    private static final String DEF_FIELD_PROPERTY;
    private static final String FIELD_PROPERTY;
    private static final String START_DIALOG_FORM;
    private static final String END_DIALOG_FORM;
    private static final String TD_LABEL;
    private static final String TD_COMPONENT;
    private static final String START_TABLE;
    private static final String END_TABLE;
    private static final String START_TR;
    private static final String END_TR;
    private static final String CHECK_PROPERTY;
    private static final String GET_PROPERTY;
    private static final String START_JAVA;
    private static final String END_JAVA;
    private static final String DEFAULT_CSS;
    private RepositoryService repositoryService_;
    private ConfigurationManager configManager_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String cmsTemplatesBasePath_;
    private InitParams params_;
    private String storedLocation_;
    private boolean autoCreateInNewRepository_ = false;
    private Log log = ExoLogger.getLogger((String)"Templateplugin");
    private TemplateService templateService;
    private DMSConfiguration dmsConfiguration_;

    public TemplatePlugin(InitParams params, RepositoryService jcrService, ConfigurationManager configManager, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = jcrService;
        this.configManager_ = configManager;
        this.cmsTemplatesBasePath_ = this.nodeHierarchyCreator_.getJcrPath("templatesPath");
        this.params_ = params;
        ValueParam locationParam = this.params_.getValueParam("storedLocation");
        this.storedLocation_ = locationParam.getValue();
        ValueParam param = this.params_.getValueParam("autoCreateInNewRepository");
        if (param != null) {
            this.autoCreateInNewRepository_ = Boolean.parseBoolean(param.getValue());
        }
        this.dmsConfiguration_ = dmsConfiguration;
        this.templateService = WCMCoreUtils.getService(TemplateService.class);
    }

    public void init() throws Exception {
        if (this.autoCreateInNewRepository_) {
            List repositories = this.repositoryService_.getConfig().getRepositoryConfigurations();
            for (RepositoryEntry repo : repositories) {
                this.importPredefineTemplates(repo.getName());
            }
        } else {
            ValueParam valueParam = this.params_.getValueParam("repository");
            String repository = null;
            repository = valueParam != null ? valueParam.getValue() : this.repositoryService_.getDefaultRepository().getConfiguration().getName();
            this.importPredefineTemplates(repository);
        }
    }

    public void init(String repository) throws Exception {
        if (this.autoCreateInNewRepository_) {
            this.importPredefineTemplates(repository);
        }
    }

    private void addTemplate(TemplateConfig templateConfig, Node templatesHome, String storedLocation) throws Exception {
        NodeTypeManager ntManager = templatesHome.getSession().getWorkspace().getNodeTypeManager();
        NodeTypeIterator nodetypeIter = ntManager.getAllNodeTypes();
        ArrayList<String> listNodeTypeName = new ArrayList<String>();
        while (nodetypeIter.hasNext()) {
            NodeType n1 = nodetypeIter.nextNodeType();
            listNodeTypeName.add(n1.getName());
        }
        List<TemplateConfig.NodeType> nodetypes = templateConfig.getNodeTypes();
        TemplateConfig.NodeType nodeType = null;
        Iterator<TemplateConfig.NodeType> iter = nodetypes.iterator();
        String repository = WCMCoreUtils.getRepository(null).getConfiguration().getName();
        while (iter.hasNext()) {
            nodeType = iter.next();
            if (!listNodeTypeName.contains(nodeType.getNodetypeName())) {
                this.log.error((Object)("The nodetype: " + nodeType.getNodetypeName() + " doesn't exist!"));
                continue;
            }
            Node nodeTypeHome = null;
            nodeTypeHome = Utils.makePath(templatesHome, nodeType.getNodetypeName(), NT_UNSTRUCTURED);
            if (nodeType.getDocumentTemplate()) {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, true);
            } else {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, false);
            }
            nodeTypeHome.setProperty(TEMPLATE_LABEL, nodeType.getLabel());
            List dialogs = nodeType.getReferencedDialog();
            this.addNode(storedLocation, nodeType, dialogs, DIALOGS, repository, templatesHome);
            List views = nodeType.getReferencedView();
            this.addNode(storedLocation, nodeType, views, VIEWS, repository, templatesHome);
            List skins = nodeType.getReferencedSkin();
            if (skins == null) continue;
            this.addNode(storedLocation, nodeType, skins, SKINS, repository, templatesHome);
        }
    }

    public void setBasePath(String basePath) {
        this.cmsTemplatesBasePath_ = basePath;
    }

    private void importPredefineTemplates(String repositoryName) throws Exception {
        Object object;
        ManageableRepository repository = this.repositoryService_.getRepository(repositoryName);
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig(repositoryName);
        String workspace = dmsRepoConfig.getSystemWorkspace();
        Session session = repository.getSystemSession(workspace);
        Node templatesHome = Utils.makePath(session.getRootNode(), this.cmsTemplatesBasePath_, NT_UNSTRUCTURED);
        TemplateConfig templateConfig = null;
        Iterator iter = this.params_.getObjectParamIterator();
        while (iter.hasNext() && (object = ((ObjectParameter)iter.next()).getObject()) instanceof TemplateConfig) {
            templateConfig = (TemplateConfig)object;
            this.addTemplate(templateConfig, templatesHome, this.storedLocation_);
        }
        session.logout();
    }

    private void addNode(String basePath, TemplateConfig.NodeType nodeType, List templates, String templateType, String repository, Node templatesHome) throws Exception {
        for (TemplateConfig.Template template : templates) {
            String templateFileName = template.getTemplateFile();
            String path = basePath + templateFileName;
            InputStream in = this.configManager_.getInputStream(path);
            String nodeName = templateFileName.substring(templateFileName.lastIndexOf("/") + 1, templateFileName.indexOf("."));
            this.templateService.addTemplate(templateType, nodeType.getNodetypeName(), nodeType.getLabel(), nodeType.getDocumentTemplate(), nodeName, template.getParsedRoles(), in, repository, templatesHome);
        }
    }

    public String buildStyleSheet(NodeType nodeType) {
        return COMMENT_TEMPLATE.concat(DEFAULT_CSS);
    }

    public String buildDialogForm(NodeType nodeType) throws ValueFormatException, RepositoryException {
        StringBuilder buildDialogForm = new StringBuilder(COMMENT_TEMPLATE);
        buildDialogForm.append(START_DIALOG_FORM).append(START_TABLE);
        buildDialogForm.append(START_TR);
        buildDialogForm.append(DEF_FIELD_PROPERTY);
        buildDialogForm.append(TD_LABEL.replace("${nodetypename}", nodeType.getName()).replace(":", "_").replace("${propertyname}", "name"));
        buildDialogForm.append(TD_COMPONENT.replace("${contentcomponent}", NAME));
        buildDialogForm.append(END_TR);
        buildDialogForm.append(this.buildDialogNodeType(nodeType));
        buildDialogForm.append(END_TABLE);
        buildDialogForm.append(END_DIALOG_FORM);
        return buildDialogForm.toString();
    }

    private String buildDialogNodeType(NodeType nodeType) throws ValueFormatException, RepositoryException {
        return this.buildDialogNodeType(nodeType, "/node/");
    }

    private String buildDialogNodeType(NodeType nodeType, String jcrPath) throws ValueFormatException, RepositoryException {
        NodeDefinition[] childdefs;
        PropertyDefinition[] prodefs;
        StringBuilder buildDialogNodeType = new StringBuilder();
        for (PropertyDefinition prodef : prodefs = nodeType.getPropertyDefinitions()) {
            if (prodef.isAutoCreated() || prodef.getName().equals("*")) continue;
            String propertyNameFormat = prodef.getName().replace(":", "_");
            String propertyPath = jcrPath.concat(prodef.getName());
            String propertyId = propertyPath.replace(":", "_");
            StringBuilder componentField = new StringBuilder("\n\t\t\t\t\t\tuicomponent.addTextField(\"").append(propertyId).append("\", ");
            StringBuilder validate = new StringBuilder("validate=");
            buildDialogNodeType.append(START_TR);
            buildDialogNodeType.append(TD_LABEL.replace("${nodetypename}", nodeType.getName()).replace(":", "_").replace("${propertyname}", propertyNameFormat));
            StringBuilder params = new StringBuilder("\t\t\t\t\t\t").append(FIELD_PROPERTY).append(" = [\"jcrPath=").append(propertyPath).append("\"");
            if (prodef.isMultiple()) {
                params.append(", \"multiValues=true\"");
            }
            if (prodef.isMandatory()) {
                validate.append("empty,");
            }
            switch (prodef.getRequiredType()) {
                case 6: {
                    params.append(", \"options=true,false\"");
                    componentField = new StringBuilder("\n\t\t\t\t\t\tuicomponent.addSelectBoxField(\"").append(propertyId).append("\", ");
                    break;
                }
                case 1: {
                    break;
                }
                case 5: {
                    validate.append("datetime,");
                    params.append(", \"options=displaytime\", \"visible=true\"");
                    componentField = new StringBuilder("\n\t\t\t\t\t\tuicomponent.addCalendarField(\"").append(propertyId).append("\", ");
                    break;
                }
                case 3: {
                    validate.append("number,");
                    break;
                }
                case 4: {
                    validate.append("number,");
                    break;
                }
                case 9: {
                    params.append(", \"reference=true\", \"editable=false\"");
                    break;
                }
                case 2: {
                    componentField = new StringBuilder("\n\t\t\t\t\t\tuicomponent.addUploadField(\"").append(propertyId).append("\", ");
                    break;
                }
            }
            Value[] defaultValuesArr = prodef.getDefaultValues();
            if (defaultValuesArr != null) {
                StringBuilder defaultValues = new StringBuilder("defaultValues=");
                for (Value value : defaultValuesArr) {
                    defaultValues.append(value.getString()).append(",");
                }
                if (defaultValues.indexOf(",") > -1) {
                    params.append(", \"").append((CharSequence)defaultValues.deleteCharAt(defaultValues.length() - 1)).append("\"");
                }
            }
            if (validate.indexOf(",") > -1) {
                params.append(", \"").append((CharSequence)validate.deleteCharAt(validate.length() - 1)).append("\"");
            }
            params.append("];");
            componentField.append(FIELD_PROPERTY).append(");");
            buildDialogNodeType.append(TD_COMPONENT.replace("${contentcomponent}", START_JAVA.concat(params.append((CharSequence)componentField).append(END_JAVA).append("\n").toString())));
            buildDialogNodeType.append(END_TR);
        }
        for (NodeDefinition childdef : childdefs = nodeType.getChildNodeDefinitions()) {
            if (childdef == null) continue;
            for (NodeType requiredNodeType : childdef.getRequiredPrimaryTypes()) {
                jcrPath = childdef.getName().equals("*") ? jcrPath.concat(childdef.getRequiredPrimaryTypes()[0].getName()).concat("/") : jcrPath.concat(childdef.getName()).concat("/");
                buildDialogNodeType.append(this.buildDialogNodeType(requiredNodeType, jcrPath));
            }
        }
        return buildDialogNodeType.toString();
    }

    public String buildViewForm(NodeType nodeType) {
        StringBuilder buildViewForm = new StringBuilder(COMMENT_TEMPLATE);
        buildViewForm.append(HEADER_VIEW.replace("${NodeType}", nodeType.getName()));
        buildViewForm.append(JAVA_HEADER_VIEW);
        buildViewForm.append("\n\t\t<div id=\"$uicomponent.id\">");
        buildViewForm.append(START_TABLE);
        buildViewForm.append(START_TR);
        buildViewForm.append(TD_LABEL.replace("${nodetypename}", nodeType.getName()).replace(":", "_").replace("${propertyname}", "name"));
        buildViewForm.append(TD_COMPONENT.replace("${contentcomponent}\t\t\t\t\t", "${name}"));
        buildViewForm.append(END_TR);
        buildViewForm.append(this.buildViewNodeType(nodeType));
        buildViewForm.append(END_TABLE);
        buildViewForm.append("\t\t</div>");
        return buildViewForm.toString();
    }

    private String buildViewNodeType(NodeType nodeType) {
        PropertyDefinition[] prodefs;
        StringBuilder buildViewNodeType = new StringBuilder();
        String label = TD_LABEL.replace("${nodetypename}", nodeType.getName().replace(":", "_"));
        for (PropertyDefinition prodef : prodefs = nodeType.getPropertyDefinitions()) {
            buildViewNodeType.append(START_JAVA).append(CHECK_PROPERTY.replace("${propertyname}", prodef.getName())).append(END_JAVA);
            buildViewNodeType.append(START_TR);
            buildViewNodeType.append(label.replace("${propertyname}", prodef.getName().replace(":", "_")));
            buildViewNodeType.append(START_JAVA);
            if (prodef.getRequiredType() == 2) {
                buildViewNodeType.append("\t\t\t\t\tvalues = BINARY; // Fix value when requiredtype = PropertyType.BINARY\n");
            }
            if (prodef.isMultiple()) {
                buildViewNodeType.append("\t\t\t\t\t// Render for multi value;\n");
                buildViewNodeType.append("\t\t\t\t\tvalues = ").append(GET_PROPERTY.replace("${propertyname}", prodef.getName())).append(".getValues()").append(";\n");
                buildViewNodeType.append("\t\t\t\t\tvalueDisplay = \"\";\n");
                buildViewNodeType.append("\t\t\t\t\tfor(value in values) {\n");
                buildViewNodeType.append("\t\t\t\t\t\tvalueDisplay += value.getString() + \",\";\n");
                buildViewNodeType.append("\t\t\t\t\t}\n");
                buildViewNodeType.append("\t\t\t\t\tif (valueDisplay.length() > 0 && valueDisplay.indexOf(\",\") > -1) valueDisplay = valueDisplay.substring(0, valueDisplay.length() - 1);");
            } else {
                buildViewNodeType.append("\t\t\t\t\t// Render for single value;\n");
                buildViewNodeType.append("\t\t\t\t\tvalueDisplay = ").append(GET_PROPERTY.replace("${propertyname}", prodef.getName())).append(".getString();");
            }
            buildViewNodeType.append(END_JAVA);
            buildViewNodeType.append(TD_COMPONENT.replace("${contentcomponent}\t\t\t\t\t", "${valueDisplay}"));
            buildViewNodeType.append(END_TR);
            buildViewNodeType.append(START_JAVA).append("\t\t\t\t\t}").append(END_JAVA);
        }
        return buildViewNodeType.toString();
    }

    static {
        COMMENT_TEMPLATE = "<%\n// Generate template for nodetype automatically\n%>\n";
        HEADER_VIEW = "<style>\n" + "\t<% _ctx.include(uicomponent.getTemplateSkin(\"${NodeType}\", \"Stylesheet\")); %>\n" + "</style>\n";
        JAVA_HEADER_VIEW = "<%\n\tdef node = uicomponent.getNode();\n" + "\tdef name = node.getName();\n" + "\tdef values;\n" + "\tdef valueDisplay;\n%>";
        DEF_FIELD_PROPERTY = "\t\t\t\t\t<%\n\t\t\t\t\t\tString[] fieldProperty; \n\t\t\t\t\t%>\n";
        FIELD_PROPERTY = "fieldProperty";
        START_DIALOG_FORM = "<div class=\"UIForm FormLayout\">\n" + "\t<% uiform.begin() %> \n" + "\t\t<div class=\"HorizontalLayout\">\n";
        NAME = "\n\t\t\t\t\t<%\n" + "\t\t\t\t\t\tString[] fieldName = [\"jcrPath=/node\", \"editable=if-null\", \"validate=empty,name\"];\n" + "\t\t\t\t\t\tuicomponent.addTextField(\"name\", fieldName);\n" + "\t\t\t\t\t%>\n";
        START_TABLE = "\n\t\t\t<table class=\"UIFormGrid\">\n";
        START_TR = "\n\t\t\t\t<tr>\n";
        END_TR = "\t\t\t\t</tr>";
        START_JAVA = "\n\t\t\t\t<%\n";
        END_JAVA = "\n\t\t\t\t%>";
        CHECK_PROPERTY = "\t\t\t\t if (node.hasProperty(\"${propertyname}\")) {";
        GET_PROPERTY = "node.getProperty(\"${propertyname}\")";
        TD_LABEL = "" + "\t\t\t\t\t<td class=\"FieldLabel\">" + "<%=_ctx.appRes(\"${nodetypename}.dialog.label.${propertyname}\")%>" + "</td>";
        TD_COMPONENT = "\n" + "\t\t\t\t\t<td class=\"FieldComponent\">" + "${contentcomponent}" + "\t\t\t\t\t</td>\n";
        END_TABLE = "\n\t\t\t</table>\n";
        END_DIALOG_FORM = "" + "\t\t\t<%uiform.processRenderAction()%>\n" + "\t\t</div>\n" + "\t<%uiform.end()%>\n" + "</div>";
        DEFAULT_CSS = ".UIFormGrid {" + "\n\tborder:1px solid #B7B7B7;" + "\n\tborder-collapse:collapse;" + "\n\tmargin:auto;" + "\n\tpadding-left:1px;" + "\n\ttable-layout:fixed;" + "\n}" + "\n\n.UIFormGrid .FieldLabel {" + "\n\tfont-weight:bold;" + "\n\twidth:auto;" + "\n}" + "\n\n.UIFormGrid td {" + "\n\tborder-left:1px solid #CCCCCC;" + "\n\tborder-right:1px solid #CCCCCC;" + "\n\tborder-top:1px solid #FFFFFF;" + "\n\tbackground:#F3F3F3 none repeat scroll 0 0;" + "\n\theight:20px;" + "\n\tline-height:20px;" + "\n\tpadding:4px;" + "\n}";
    }
}

