/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Day;
import org.jbpm.calendar.Duration;

public class DayPart
implements Serializable {
    private static final long serialVersionUID = 1L;
    int fromHour = -1;
    int fromMinute = -1;
    int toHour = -1;
    int toMinute = -1;
    Day day = null;
    int index = -1;

    public DayPart(String dayPartText, DateFormat dateFormat, Day day, int index) {
        this.day = day;
        this.index = index;
        int separatorIndex = dayPartText.indexOf(45);
        if (separatorIndex == -1) {
            throw new IllegalArgumentException("improper format of daypart '" + dayPartText + "'");
        }
        String fromText = dayPartText.substring(0, separatorIndex).trim().toLowerCase();
        String toText = dayPartText.substring(separatorIndex + 1).trim().toLowerCase();
        try {
            Date from = dateFormat.parse(fromText);
            Date to = dateFormat.parse(toText);
            Calendar calendar = BusinessCalendar.getCalendar();
            calendar.setTime(from);
            this.fromHour = calendar.get(11);
            this.fromMinute = calendar.get(12);
            calendar.setTime(to);
            this.toHour = calendar.get(11);
            if (this.toHour == 0) {
                this.toHour = 24;
            }
            this.toMinute = calendar.get(12);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("improper format of daypart '" + dayPartText + "'");
        }
    }

    public Date add(Date date, Duration duration) {
        Date end = null;
        Calendar calendar = BusinessCalendar.getCalendar();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        long millisInThisDayPart = (long)(this.toHour - hour) * 3600000L + (long)(this.toMinute - minute) * 60000L;
        long durationMillis = duration.getMilliseconds();
        if (durationMillis <= millisInThisDayPart) {
            end = duration.addTo(date);
        } else {
            Duration remainder = new Duration(durationMillis - millisInThisDayPart);
            Date dayPartEndDate = new Date(date.getTime() + millisInThisDayPart);
            Object[] result = new Object[2];
            this.day.findNextDayPartStart(this.index + 1, dayPartEndDate, result);
            Date nextDayPartStart = (Date)result[0];
            DayPart nextDayPart = (DayPart)result[1];
            end = nextDayPart.add(nextDayPartStart, remainder);
        }
        return end;
    }

    public boolean isStartAfter(Date date) {
        Calendar calendar = BusinessCalendar.getCalendar();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        return hour < this.fromHour || hour == this.fromHour && minute <= this.fromMinute;
    }

    public boolean includes(Date date) {
        Calendar calendar = BusinessCalendar.getCalendar();
        calendar.setTime(date);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        return (this.fromHour < hour || this.fromHour == hour && this.fromMinute <= minute) && (hour < this.toHour || hour == this.toHour && minute <= this.toMinute);
    }

    public Date getStartTime(Date date) {
        Calendar calendar = BusinessCalendar.getCalendar();
        calendar.setTime(date);
        calendar.set(11, this.fromHour);
        calendar.set(12, this.fromMinute);
        return calendar.getTime();
    }
}

