/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log.xa;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidFileSetException;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogClosedException;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogEventListener;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.LogRecordSizeException;
import org.objectweb.howl.log.Logger;
import org.objectweb.howl.log.ReplayListener;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;

public class XALogger
extends Logger
implements LogEventListener {
    XACommittingTx[] activeTx = null;
    XACommittingTx[] availableTx = null;
    int atxGet = 0;
    int atxPut = 0;
    int atxUsed = 0;
    int maxAtxUsed = 0;
    final Object activeTxLock = new Object();
    int growActiveTxArrayCount = 0;
    int overflowNotificationCount = 0;
    int movedRecordCount = 0;
    long totalWaitForThis = 0L;
    int waitForThisCount = 0;
    long overflowFence = 0L;
    LogEventListener eventListener = null;
    boolean replayNeeded = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growActiveTxArray() {
        XACommittingTx[] newActiveTx = new XACommittingTx[this.activeTx.length + 50];
        XACommittingTx[] newAvailableTx = new XACommittingTx[newActiveTx.length];
        for (int i = this.activeTx.length; i < newActiveTx.length; ++i) {
            newActiveTx[i] = null;
            newAvailableTx[i] = new XACommittingTx(i);
        }
        Object object = this.activeTxLock;
        synchronized (object) {
            for (int i = 0; i < this.activeTx.length; ++i) {
                newActiveTx[i] = this.activeTx[i];
                newAvailableTx[i] = this.availableTx[i];
            }
            this.atxPut = 0;
            this.atxGet = this.activeTx.length;
            this.activeTx = newActiveTx;
            this.availableTx = newAvailableTx;
        }
        ++this.growActiveTxArrayCount;
    }

    private void init() {
        int i;
        this.activeTx = new XACommittingTx[50];
        for (i = 0; i < this.activeTx.length; ++i) {
            this.activeTx[i] = null;
        }
        this.availableTx = new XACommittingTx[this.activeTx.length];
        for (i = 0; i < this.activeTx.length; ++i) {
            this.availableTx[i] = new XACommittingTx(i);
        }
        super.setLogEventListener(this);
    }

    public XALogger() throws IOException {
        super(new Configuration());
        this.init();
    }

    public XALogger(Configuration config) throws IOException {
        super(config);
        this.init();
    }

    private void checkPutEnabled() throws LogClosedException {
        if (this.replayNeeded) {
            throw new LogClosedException("replay() must be called prior to put(); activeMark [0x" + Long.toHexString(super.getActiveMark()) + "]");
        }
    }

    public long put(byte[] data, boolean sync) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        this.checkPutEnabled();
        this.onpWait();
        return this.put((short)0, new byte[][]{data}, sync);
    }

    public long put(byte[][] data, boolean sync) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        this.checkPutEnabled();
        this.onpWait();
        return this.put((short)0, data, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onpWait() throws InterruptedException {
        long beginWait = System.currentTimeMillis();
        XALogger xALogger = this;
        synchronized (xALogger) {
            if (this.overflowFence != 0L) {
                ++this.waitForThisCount;
            }
            while (this.overflowFence != 0L) {
                this.wait();
            }
            this.totalWaitForThis += System.currentTimeMillis() - beginWait;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XACommittingTx putCommit(byte[][] record) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        long key = 0L;
        long overflowFence = 0L;
        this.checkPutEnabled();
        this.onpWait();
        do {
            key = this.put((short)16512, record, true);
            XALogger xALogger = this;
            synchronized (xALogger) {
                overflowFence = this.overflowFence;
            }
        } while (key < overflowFence);
        return this.activeTxAdd(key, record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XACommittingTx activeTxAdd(long key, byte[][] record) {
        XACommittingTx tx = null;
        Object object = this.activeTxLock;
        synchronized (object) {
            if (this.atxUsed == this.activeTx.length) {
                this.growActiveTxArray();
            }
            tx = this.availableTx[this.atxGet];
            if (!$assertionsDisabled && tx == null) {
                throw new AssertionError((Object)("availableTx[" + this.atxGet + "] is null"));
            }
            this.availableTx[this.atxGet] = null;
            this.atxGet = (this.atxGet + 1) % this.activeTx.length;
            tx.setLogKey(key);
            tx.setRecord(record);
            tx.setDone(false);
            tx.setMoving(false);
            int index = tx.getIndex();
            this.activeTx[index] = tx;
            ++this.atxUsed;
            this.maxAtxUsed = Math.max(this.atxUsed, this.maxAtxUsed);
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long putDone(byte[][] record, XACommittingTx tx) throws LogClosedException, LogRecordSizeException, LogFileOverflowException, InterruptedException, IOException {
        this.checkPutEnabled();
        if (!$assertionsDisabled && tx == null) {
            throw new AssertionError((Object)"XACommitingTX is null");
        }
        Object object = this.activeTxLock;
        synchronized (object) {
            int index = tx.getIndex();
            if (this.activeTx[index] != tx) {
                throw new IllegalArgumentException();
            }
            this.activeTx[index] = null;
        }
        object = tx;
        synchronized (object) {
            tx.setDone(true);
            while (tx.isMoving()) {
                tx.wait();
            }
        }
        long doneKey = 0L;
        if (record != null) {
            do {
                try {
                    doneKey = this.put((short)0, record, false);
                }
                catch (LogFileOverflowException e) {
                    Thread.sleep(10L);
                }
            } while (doneKey == 0L);
        }
        long xadoneKey = 0L;
        do {
            try {
                xadoneKey = this.put((short)16448, tx.logKeyData, false);
            }
            catch (LogFileOverflowException e) {
                Thread.sleep(10L);
            }
        } while (xadoneKey == 0L);
        Object object2 = this.activeTxLock;
        synchronized (object2) {
            tx.setLogKey(0L);
            this.availableTx[this.atxPut] = tx;
            this.atxPut = (this.atxPut + 1) % this.activeTx.length;
            --this.atxUsed;
            if (!$assertionsDisabled && this.atxUsed < 0) {
                throw new AssertionError((Object)("Negative atxUsed (" + this.atxUsed + ")"));
            }
        }
        return doneKey;
    }

    public boolean isLoggable(int level) {
        boolean loggable = false;
        if (this.eventListener != null) {
            loggable = this.eventListener.isLoggable(level);
        }
        return loggable;
    }

    public void log(int level, String message) {
        if (this.eventListener != null) {
            this.eventListener.log(level, message);
        }
    }

    public void log(int level, String message, Throwable thrown) {
        if (this.eventListener != null) {
            this.eventListener.log(level, message, thrown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logOverflowNotification(long overflowFence) {
        boolean logClosed = false;
        long newMark = Long.MAX_VALUE;
        XACommittingTx tx = null;
        long txKey = 0L;
        if (overflowFence == 0L) {
            throw new IllegalArgumentException("overflowFence == 0");
        }
        ++this.overflowNotificationCount;
        XALogger xALogger = this;
        synchronized (xALogger) {
            this.overflowFence = overflowFence;
        }
        if (this.eventListener != null) {
            this.eventListener.logOverflowNotification(overflowFence);
        }
        for (int i = 0; i < this.activeTx.length; ++i) {
            Object object = this.activeTxLock;
            synchronized (object) {
                tx = this.activeTx[i];
                if (tx == null) {
                    continue;
                }
            }
            object = tx;
            synchronized (object) {
                if (tx.isDone()) {
                    continue;
                }
                txKey = tx.getLogKey();
                if (txKey > overflowFence) {
                    if (txKey < newMark) {
                        newMark = txKey;
                    }
                    continue;
                }
                tx.setMoving(true);
            }
            try {
                byte[][] record = tx.getRecord();
                byte[][] movedRecord = new byte[record.length + 1][];
                movedRecord[0] = tx.logKeyData[0];
                System.arraycopy(record, 0, movedRecord, 1, record.length);
                txKey = this.put((short)16576, movedRecord, false);
                ++this.movedRecordCount;
                XACommittingTx xACommittingTx = tx;
                synchronized (xACommittingTx) {
                    tx.setLogKey(txKey);
                    tx.setMoving(false);
                    tx.notifyAll();
                    continue;
                }
            }
            catch (LogClosedException e1) {
                logClosed = true;
                break;
            }
            catch (LogRecordSizeException e1) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"unexpected LogRecordSizeException");
                }
                continue;
            }
            catch (LogFileOverflowException e1) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"unexpected LogFileOverflowException");
                }
                continue;
            }
            catch (InterruptedException e1) {
                continue;
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        try {
            if (newMark == Long.MAX_VALUE) {
                newMark = overflowFence;
            }
            if (!logClosed) {
                this.mark(newMark, true);
            }
        }
        catch (InvalidLogKeyException e) {
            System.err.println(e.toString());
            Thread.yield();
        }
        catch (LogClosedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Log closed during logOverflowNotification processing");
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        XALogger xALogger2 = this;
        synchronized (xALogger2) {
            this.overflowFence = 0L;
            this.notifyAll();
        }
    }

    public String getStats() {
        String name = this.getClass().getName();
        StringBuffer stats = new StringBuffer("\n<XALogger  class='" + name + "'>");
        stats.append("\n<growActiveTxArrayCount value='" + this.growActiveTxArrayCount + "'>Number of times activeTx table was resized to accomodate " + "a larger number of transactions in COMMITTING state" + "</growActiveTxArrayCount>" + "\n<maxAtxUsed value='" + this.maxAtxUsed + "'>Maximum number of active TX entries used" + "</maxAtxUsed>" + "\n<movedRecordCount value='" + this.movedRecordCount + "'>Number of records moved during log overflow notification processing" + "</movedRecordCount>" + "\n<overflowNotificationCount value='" + this.overflowNotificationCount + "'>number of times log overflow notification event was called." + "</overflowNotificationCount>" + "\n<waitForThisCount value='" + this.getWaitForThisCount() + "'>Number of times threads waited for overflow processing to complete" + "</waitForThisCount>" + "\n<totalWaitForThis value='" + this.getTotalWaitForThis() + "'>Total time (ms) threads waited for overflow processing to complete" + "</totalWaitForThis>");
        stats.append(super.getStats());
        stats.append("\n</XALogger>\n");
        return stats.toString();
    }

    private final synchronized int getWaitForThisCount() {
        return this.waitForThisCount;
    }

    private final synchronized long getTotalWaitForThis() {
        return this.totalWaitForThis;
    }

    public void setLogEventListener(LogEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void open() {
        throw new UnsupportedOperationException("Use open(ReplayListener) instead");
    }

    public void open(ReplayListener listener) throws InvalidFileSetException, LogConfigurationException, InvalidLogBufferException, LogClosedException, ClassNotFoundException, IOException, InterruptedException {
        this.replayNeeded = true;
        super.open();
        OpenReplayListener xaListener = new OpenReplayListener(listener);
        try {
            super.replay(xaListener, this.getActiveMark(), true);
        }
        catch (InvalidLogKeyException e) {
            throw new LogClosedException(e);
        }
        if (this.replayNeeded) {
            LogClosedException lce = new LogClosedException(xaListener.replayException);
            throw lce;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, InterruptedException {
        if (this.isClosed) {
            return;
        }
        long newMark = Long.MAX_VALUE;
        XACommittingTx tx = null;
        Object object = this.activeTxLock;
        synchronized (object) {
            for (int i = 0; i < this.activeTx.length; ++i) {
                long key;
                tx = this.activeTx[i];
                if (tx == null || (key = tx.getLogKey()) >= newMark) continue;
                newMark = key;
            }
            if (newMark < Long.MAX_VALUE) {
                try {
                    this.mark(newMark, true);
                }
                catch (InvalidLogKeyException e) {
                }
                catch (LogClosedException e) {
                    // empty catch block
                }
            }
        }
        super.close();
    }

    public int getActiveTxUsed() {
        return this.atxUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void activeTxDisplay() {
        int i = 0;
        while (i < this.activeTx.length) {
            if (this.activeTx[i] != null) {
                XACommittingTx[] xACommittingTxArray = this.activeTx;
                // MONITORENTER : this.activeTx
                XACommittingTx tx = this.activeTx[i];
                byte[][] record = tx.getRecord();
                System.out.println("activeTx[" + i + "] key=" + Long.toHexString(tx.getLogKey()) + "\n  Fields: " + record.length);
                for (int j = 0; j < record.length; ++j) {
                    byte[] field = record[j];
                    System.out.println("  [" + j + "] len=" + field.length + ": " + new String(field));
                }
                // MONITOREXIT : xACommittingTxArray
            }
            ++i;
        }
    }

    public void replay(ReplayListener listener) throws LogConfigurationException {
        block2: {
            try {
                this.replay(listener, this.getActiveMark());
            }
            catch (InvalidLogKeyException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)("Unhandled InvalidLogKeyException" + e.toString()));
            }
        }
    }

    public void replay(ReplayListener listener, long key) throws InvalidLogKeyException, LogConfigurationException {
        XAReplayListener replayListener = new XAReplayListener(listener);
        super.replay(replayListener, key, true);
    }

    public void replayActiveTx(ReplayListener listener) {
        XACommittingTx tx = null;
        XALogRecord lr = null;
        for (int i = 0; i < this.activeTx.length; ++i) {
            int j;
            tx = this.activeTx[i];
            if (tx == null) continue;
            byte[][] record = tx.getRecord();
            int recordSize = 0;
            for (j = 0; j < record.length; ++j) {
                recordSize = (short)(recordSize + (2 + record[j].length));
            }
            lr = new XALogRecord(recordSize);
            lr.length = (short)recordSize;
            lr.dataBuffer.clear();
            for (j = 0; j < record.length; ++j) {
                lr.dataBuffer.putShort((short)record[j].length);
                lr.dataBuffer.put(record[j]);
            }
            lr.key = tx.getLogKey();
            lr.tod = 0L;
            lr.setTx(tx);
            lr.type = (short)16512;
            listener.onRecord(lr);
        }
        lr = new XALogRecord(0);
        lr.type = (short)19983;
        listener.onRecord(lr);
    }

    static {
        $assertionsDisabled = !XALogger.class.desiredAssertionStatus();
    }

    private static class XAReplayListener
    implements ReplayListener {
        final LogRecord lr;
        final ReplayListener tmListener;
        static final /* synthetic */ boolean $assertionsDisabled;

        XAReplayListener(ReplayListener tmListener) {
            if (!$assertionsDisabled && tmListener == null) {
                throw new AssertionError((Object)"ReplayListener must be non-null");
            }
            this.tmListener = tmListener;
            this.lr = tmListener.getLogRecord();
        }

        public void onRecord(LogRecord lr) {
            long xacommitKey = 0L;
            ((XALogRecord)lr).setTx(null);
            if (!lr.isCTRL()) {
                this.tmListener.onRecord(lr);
                return;
            }
            switch (lr.type) {
                case 19983: {
                    this.tmListener.onRecord(lr);
                    break;
                }
                case 16576: {
                    ByteBuffer b = lr.dataBuffer;
                    if (b.getShort() != 8) {
                        throw new IllegalArgumentException();
                    }
                    b.getLong();
                    int len = b.remaining();
                    int pos = b.position();
                    System.arraycopy(lr.data, pos, lr.data, 0, len);
                    b.rewind();
                    b.limit(len);
                }
                case 16512: {
                    this.tmListener.onRecord(lr);
                    break;
                }
            }
        }

        public void onError(LogException e) {
            this.tmListener.onError(e);
        }

        public LogRecord getLogRecord() {
            return this.lr;
        }

        static {
            $assertionsDisabled = !(class$org$objectweb$howl$log$xa$XALogger == null ? (class$org$objectweb$howl$log$xa$XALogger = XALogger.class$("org.objectweb.howl.log.xa.XALogger")) : class$org$objectweb$howl$log$xa$XALogger).desiredAssertionStatus();
        }
    }

    private class OpenReplayListener
    implements ReplayListener {
        LogRecord lr = new XALogRecord(80);
        final XALogger parent = XALogger.this;
        LogException replayException = null;
        final ReplayListener tmListener;
        final HashMap activeTxHashMap;
        public int unmatchedDoneCount = 0;
        public int commitCount = 0;
        public int doneCount = 0;
        public int movedCount = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        OpenReplayListener(ReplayListener tmListener) {
            this.tmListener = tmListener;
            this.activeTxHashMap = new HashMap(256);
            this.activeTxHashMap.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRecord(LogRecord lr) {
            XACommittingTx tx = null;
            short fldSize = 0;
            long xacommitKey = 0L;
            ((XALogRecord)lr).setTx(tx);
            if (!lr.isCTRL() && this.tmListener != null) {
                this.tmListener.onRecord(lr);
                return;
            }
            ByteBuffer b = lr.dataBuffer;
            switch (lr.type) {
                case 19983: {
                    OpenReplayListener openReplayListener = this;
                    synchronized (openReplayListener) {
                        this.parent.replayNeeded = false;
                        this.notifyAll();
                    }
                    if (this.tmListener == null) break;
                    this.tmListener.onRecord(lr);
                    break;
                }
                case 16576: {
                    ++this.movedCount;
                    short sz = b.getShort();
                    if (sz != 8) {
                        throw new IllegalArgumentException("Expected 8 found " + sz);
                    }
                    xacommitKey = b.getLong();
                    tx = (XACommittingTx)this.activeTxHashMap.remove(new Long(xacommitKey));
                    if (tx != null) {
                        tx.setLogKey(lr.key);
                        break;
                    }
                    int len = b.remaining();
                    int start = b.position();
                    System.arraycopy(lr.data, start, lr.data, 0, len);
                    b.rewind();
                    b.limit(len);
                }
                case 16512: {
                    ++this.commitCount;
                    tx = XALogger.this.activeTxAdd(lr.key, lr.getFields());
                    this.activeTxHashMap.put(new Long(lr.key), tx);
                    ((XALogRecord)lr).setTx(tx);
                    if (this.tmListener == null) break;
                    this.tmListener.onRecord(lr);
                    break;
                }
                case 16448: {
                    ++this.doneCount;
                    fldSize = b.getShort();
                    if (fldSize != 8) {
                        throw new IllegalArgumentException("expected 8 found " + fldSize + " at record " + Long.toHexString(lr.key));
                    }
                    xacommitKey = b.getLong();
                    if (b.remaining() > 0) {
                        fldSize = b.getShort();
                        if (fldSize != 4) {
                            throw new IllegalArgumentException("expected 4 found " + fldSize + " at record " + Long.toHexString(lr.key));
                        }
                        b.getInt();
                    }
                    if (!$assertionsDisabled && b.remaining() != 0) {
                        throw new AssertionError((Object)"Unexpected data in XADONE record");
                    }
                    tx = (XACommittingTx)this.activeTxHashMap.remove(new Long(xacommitKey));
                    if (tx == null) {
                        ++this.unmatchedDoneCount;
                        break;
                    }
                    Object object = XALogger.this.activeTxLock;
                    synchronized (object) {
                        int index = tx.getIndex();
                        if (XALogger.this.activeTx[index] != tx) {
                            throw new IllegalArgumentException();
                        }
                        XALogger.this.activeTx[index] = null;
                        XALogger.this.availableTx[XALogger.this.atxPut] = tx;
                        XALogger.this.atxPut = (XALogger.this.atxPut + 1) % XALogger.this.activeTx.length;
                        --XALogger.this.atxUsed;
                        if (!$assertionsDisabled && XALogger.this.atxUsed < 0) {
                            throw new AssertionError((Object)("Negative atxUsed (" + XALogger.this.atxUsed + ")"));
                        }
                        break;
                    }
                }
            }
        }

        public void onError(LogException e) {
            System.err.println("onError: " + e);
            this.replayException = e;
            if (this.tmListener != null) {
                this.tmListener.onError(e);
            }
        }

        public LogRecord getLogRecord() {
            return this.lr;
        }

        static {
            $assertionsDisabled = !(class$org$objectweb$howl$log$xa$XALogger == null ? (class$org$objectweb$howl$log$xa$XALogger = XALogger.class$("org.objectweb.howl.log.xa.XALogger")) : class$org$objectweb$howl$log$xa$XALogger).desiredAssertionStatus();
        }
    }
}

