/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.poll.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.poll.service.DataStorage;
import org.exoplatform.poll.service.Poll;
import org.exoplatform.poll.service.PollSummary;
import org.exoplatform.poll.service.impl.PollNodeTypes;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRDataStorage
implements DataStorage,
PollNodeTypes {
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private SessionManager sessionManager;
    KSDataLocation dataLocator;

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator, KSDataLocation dataLocator) {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.dataLocator = dataLocator;
        this.sessionManager = dataLocator.getSessionManager();
    }

    public Node getNodeByPath(String nodePath, SessionProvider sessionProvider) throws Exception {
        return (Node)this.getSession(sessionProvider).getItem(nodePath);
    }

    public Session getSession(SessionProvider sprovider) throws Exception {
        return this.sessionManager.getSession(sprovider);
    }

    private Node getPublicPollHomeNode(SessionProvider sProvider) throws Exception {
        Node publicApp = this.getNodeByPath(this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider).getPath(), sProvider);
        try {
            return publicApp.getNode(EXO_POLLS);
        }
        catch (Exception e) {
            Node pollApp = publicApp.addNode(EXO_POLLS, "nt:unstructured");
            publicApp.getSession().save();
            return pollApp;
        }
    }

    private Node getGroupPollHomeNode(SessionProvider sProvider) throws Exception {
        Node privateApp = this.getNodeByPath(this.nodeHierarchyCreator_.getJcrPath("groupsPath"), sProvider);
        return privateApp;
    }

    private Node getParentNode(SessionProvider sProvider, String parentId) throws Exception {
        Node appNode = null;
        try {
            appNode = this.getNodeByPath(parentId, sProvider);
        }
        catch (Exception e) {
            if (e instanceof PathNotFoundException || e instanceof RepositoryException) {
                if (parentId.indexOf(APPLICATION_DATA) > 0) {
                    return this.getNode(this.getGroupPollHomeNode(sProvider), parentId);
                }
                if (parentId.indexOf(POLLS) > 0) {
                    return this.getNode(this.getPublicPollHomeNode(sProvider), parentId);
                }
            }
            e.printStackTrace();
        }
        return appNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Poll getPoll(String pollId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String parentId = "";
            if (pollId.lastIndexOf("/") > 0) {
                parentId = pollId.substring(0, pollId.lastIndexOf("/") + 1);
                pollId = pollId.substring(pollId.lastIndexOf("/") + 1);
            }
            Node appNode = this.getParentNode(sProvider, parentId);
            Node pollNode = appNode.getNode(pollId);
            Poll poll = this.getPollNode(pollNode);
            return poll;
        }
        catch (Exception e) {
            Poll poll = this.getPollNode(this.getNodeById(sProvider, pollId));
            return poll;
        }
        finally {
            sProvider.close();
        }
    }

    private Node getNodeById(SessionProvider sProvider, String pollId) throws Exception {
        QueryManager qm = this.getSession(sProvider).getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root");
        queryString.append("//element(*,").append("exo:poll").append(")").append("[fn:name() = '").append(pollId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        if (iter.getSize() > 0L) {
            return iter.nextNode();
        }
        return null;
    }

    private Poll getPollNode(Node pollNode) throws Exception {
        if (pollNode == null) {
            return null;
        }
        Poll pollNew = new Poll();
        pollNew.setId(pollNode.getName());
        pollNew.setParentPath(pollNode.getParent().getPath());
        if (pollNode.hasProperty("exo:owner")) {
            pollNew.setOwner(pollNode.getProperty("exo:owner").getString());
        }
        if (pollNode.hasProperty("exo:createdDate")) {
            pollNew.setCreatedDate(pollNode.getProperty("exo:createdDate").getDate().getTime());
        }
        if (pollNode.hasProperty("exo:modifiedBy")) {
            pollNew.setModifiedBy(pollNode.getProperty("exo:modifiedBy").getString());
        }
        if (pollNode.hasProperty("exo:modifiedDate")) {
            pollNew.setModifiedDate(pollNode.getProperty("exo:modifiedDate").getDate().getTime());
        }
        if (pollNode.hasProperty("exo:lastVote")) {
            pollNew.setLastVote(pollNode.getProperty("exo:lastVote").getDate().getTime());
        }
        if (pollNode.hasProperty("exo:timeOut")) {
            pollNew.setTimeOut(pollNode.getProperty("exo:timeOut").getLong());
        }
        if (pollNode.hasProperty("exo:question")) {
            pollNew.setQuestion(pollNode.getProperty("exo:question").getString());
        }
        if (pollNode.hasProperty("exo:option")) {
            pollNew.setOption(this.valuesToArray(pollNode.getProperty("exo:option").getValues()));
        }
        if (pollNode.hasProperty("exo:vote")) {
            pollNew.setVote(this.valuesToArray(pollNode.getProperty("exo:vote").getValues()));
        }
        if (pollNode.hasProperty("exo:userVote")) {
            pollNew.setUserVote(this.valuesToArray(pollNode.getProperty("exo:userVote").getValues()));
        }
        if (pollNode.hasProperty("exo:isMultiCheck")) {
            pollNew.setIsMultiCheck(pollNode.getProperty("exo:isMultiCheck").getBoolean());
        }
        if (pollNode.hasProperty("exo:isAgainVote")) {
            pollNew.setIsAgainVote(pollNode.getProperty("exo:isAgainVote").getBoolean());
        }
        if (pollNode.hasProperty("exo:isClosed")) {
            pollNew.setIsClosed(pollNode.getProperty("exo:isClosed").getBoolean());
        }
        return pollNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Poll> getPagePoll() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<Poll> listPoll = new ArrayList<Poll>();
        try {
            NodeIterator iter = this.getIterNodePoll(sProvider);
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                listPoll.add(this.getPollNode(node));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return listPoll;
    }

    private NodeIterator getIterNodePoll(SessionProvider sProvider) throws Exception {
        QueryManager qm = this.getSession(sProvider).getWorkspace().getQueryManager();
        StringBuffer queryString = new StringBuffer("/jcr:root");
        queryString.append("//element(*,").append("exo:poll").append(")").append(" order by @").append("exo:createdDate").append(" descending");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        return result.getNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollSummary getPollSummary() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        PollSummary poll = new PollSummary();
        try {
            NodeIterator iter = this.getIterNodePoll(sProvider);
            ArrayList<String> pollId = new ArrayList<String>();
            ArrayList<String> pollName = new ArrayList<String>();
            ArrayList<String> groupPrivate = new ArrayList<String>();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                pollId.add(node.getName());
                pollName.add(node.getProperty("exo:question").getString());
                groupPrivate.add(node.getPath());
            }
            poll.setPollId(pollId);
            poll.setPollName(pollName);
            poll.setGroupPrivate(groupPrivate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return poll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Poll removePoll(String pollId) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        Poll poll = null;
        try {
            Node pollNode = null;
            pollNode = pollId.lastIndexOf("/") > 0 ? this.getNodeByPath(pollId, sProvider) : this.getNodeById(sProvider, pollId);
            poll = this.getPollNode(pollNode);
            Node parentNode = pollNode.getParent();
            pollNode.remove();
            if (parentNode.hasProperty("exo:isPoll")) {
                parentNode.setProperty("exo:isPoll", false);
            }
            if (parentNode.isNew()) {
                parentNode.getSession().save();
            } else {
                parentNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
        return poll;
    }

    private Node getNode(Node nodeApp, String ids) throws Exception {
        Node node = null;
        if (ids.indexOf("/") < 0) {
            node = nodeApp.addNode(ids);
        } else {
            String[] ar = ids.split("/");
            for (int i = 0; i < ar.length; ++i) {
                try {
                    node = nodeApp.getNode(ar[i]);
                }
                catch (PathNotFoundException e) {
                    node = nodeApp.addNode(ar[i], "nt:unstructured");
                }
                nodeApp = node;
            }
            if (nodeApp.isNew()) {
                nodeApp.getSession().save();
            } else {
                nodeApp.getParent().save();
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePoll(Poll poll, boolean isNew, boolean isVote) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            String pollId = poll.getId();
            Node parentNode = this.getParentNode(sProvider, poll.getParentPath() != null ? poll.getParentPath() : pollId);
            if (isVote) {
                Node pollNode = parentNode.getNode(pollId);
                pollNode.setProperty("exo:vote", poll.getVote());
                pollNode.setProperty("exo:userVote", poll.getUserVote());
                try {
                    pollNode.setProperty("exo:lastVote", JCRDataStorage.getGreenwichMeanTime());
                }
                catch (RepositoryException e) {}
            } else {
                Node pollNode;
                if (isNew) {
                    if (parentNode.hasNode(pollId)) {
                        return;
                    }
                    pollNode = parentNode.addNode(pollId, "exo:poll");
                    pollNode.setProperty("exo:id", pollId);
                    pollNode.setProperty("exo:owner", poll.getOwner());
                    pollNode.setProperty("exo:userVote", new String[0]);
                    pollNode.setProperty("exo:createdDate", JCRDataStorage.getGreenwichMeanTime());
                    pollNode.setProperty("exo:modifiedDate", JCRDataStorage.getGreenwichMeanTime());
                    if (parentNode.hasProperty("exo:isPoll")) {
                        parentNode.setProperty("exo:isPoll", true);
                    }
                } else {
                    if (!JCRDataStorage.isEmpty(poll.getOldParentPath()) && !parentNode.getPath().equals(poll.getOldParentPath())) {
                        Session session = this.getSession(sProvider);
                        session.move(poll.getOldParentPath() + "/" + pollId, parentNode.getPath() + "/" + pollId);
                        session.save();
                        pollNode = parentNode.getNode(pollId);
                    }
                    pollNode = parentNode.getNode(pollId);
                }
                if (poll.getUserVote().length > 0) {
                    pollNode.setProperty("exo:userVote", poll.getUserVote());
                }
                pollNode.setProperty("exo:vote", poll.getVote());
                pollNode.setProperty("exo:modifiedBy", poll.getModifiedBy());
                if (!isNew && pollNode.getProperty("exo:timeOut").getLong() != poll.getTimeOut()) {
                    pollNode.setProperty("exo:modifiedDate", JCRDataStorage.getGreenwichMeanTime());
                }
                pollNode.setProperty("exo:timeOut", poll.getTimeOut());
                pollNode.setProperty("exo:question", poll.getQuestion());
                pollNode.setProperty("exo:option", poll.getOption());
                pollNode.setProperty("exo:isMultiCheck", poll.getIsMultiCheck());
                pollNode.setProperty("exo:isClosed", poll.getIsClosed());
                pollNode.setProperty("exo:isAgainVote", poll.getIsAgainVote());
            }
            if (parentNode.isNew()) {
                parentNode.getSession().save();
            } else {
                parentNode.save();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClosedPoll(Poll poll) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node appNode = this.getParentNode(sProvider, poll.getParentPath());
            Node pollNode = appNode.getNode(poll.getId());
            pollNode.setProperty("exo:isClosed", poll.getIsClosed());
            if (poll.getTimeOut() == 0L) {
                pollNode.setProperty("exo:modifiedDate", JCRDataStorage.getGreenwichMeanTime());
                pollNode.setProperty("exo:timeOut", 0L);
            }
            appNode.save();
        }
        catch (Exception exception) {
        }
        finally {
            sProvider.close();
        }
    }

    public static Calendar getGreenwichMeanTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public String[] valuesToArray(Value[] Val) throws Exception {
        if (Val.length < 1) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < Val.length; ++i) {
            String s = Val[i].getString();
            if (JCRDataStorage.isEmpty(s)) continue;
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public List<String> valuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            String s = values[i].getString();
            if (JCRDataStorage.isEmpty(s)) continue;
            list.add(s);
        }
        return list;
    }
}

