/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.drives.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.drives.impl.ManageDrivePlugin;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageDriveServiceImpl
implements ManageDriveService,
Startable {
    private static String WORKSPACE = "exo:workspace".intern();
    private static String ALL_DRIVES_CACHED = "allDrives".intern();
    private static String ALL_DRIVES_CACHED_BY_ROLES = "_allDrivesByRoles".intern();
    private static String ALL_MAIN_CACHED_DRIVE = "_mainDrives".intern();
    private static String ALL_PERSONAL_CACHED_DRIVE = "_personalDrives".intern();
    private static String ALL_GROUP_CACHED_DRIVES = "_groupDrives".intern();
    private static String PERMISSIONS = "exo:accessPermissions".intern();
    private static String VIEWS = "exo:views".intern();
    private static String ICON = "exo:icon".intern();
    private static String PATH = "exo:path".intern();
    private static String VIEW_REFERENCES = "exo:viewPreferences".intern();
    private static String VIEW_NON_DOCUMENT = "exo:viewNonDocument".intern();
    private static String VIEW_SIDEBAR = "exo:viewSideBar".intern();
    private static String SHOW_HIDDEN_NODE = "exo:showHiddenNode".intern();
    private static String ALLOW_CREATE_FOLDER = "exo:allowCreateFolders".intern();
    private static String ALLOW_NODETYPES_ON_TREE = "exo:allowNodeTypesOnTree".intern();
    private List<ManageDrivePlugin> drivePlugins_ = new ArrayList<ManageDrivePlugin>();
    private RepositoryService repositoryService_;
    private String baseDrivePath_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private DMSConfiguration dmsConfiguration_;
    private static final Log LOG = ExoLogger.getLogger(ManageDriveServiceImpl.class);
    private ExoCache drivesCache_;

    public ManageDriveServiceImpl(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreator, DMSConfiguration dmsConfiguration, CacheService caService) throws Exception {
        this.repositoryService_ = jcrService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.baseDrivePath_ = this.nodeHierarchyCreator_.getJcrPath("exoDrivesPath");
        this.dmsConfiguration_ = dmsConfiguration;
        this.drivesCache_ = caService.getCacheInstance(ManageDriveService.class.getName());
    }

    public void start() {
        try {
            for (ManageDrivePlugin plugin : this.drivePlugins_) {
                plugin.init();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
    }

    @Override
    public void init(String repository) throws Exception {
        for (ManageDrivePlugin plugin : this.drivePlugins_) {
            plugin.init(repository);
        }
    }

    public void setManageDrivePlugin(ManageDrivePlugin drivePlugin) {
        this.drivePlugins_.add(drivePlugin);
    }

    @Override
    public List<DriveData> getAllDrives(String repository) throws Exception {
        List allDrives = (List)this.drivesCache_.get((Serializable)((Object)ALL_DRIVES_CACHED));
        if (allDrives != null && allDrives.size() > 0) {
            return allDrives;
        }
        Session session = this.getSession(repository);
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        NodeIterator itr = driveHome.getNodes();
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        DriveData data = null;
        Node drive = null;
        while (itr.hasNext()) {
            data = new DriveData();
            drive = itr.nextNode();
            data.setName(drive.getName());
            data.setWorkspace(drive.getProperty(WORKSPACE).getString());
            data.setHomePath(drive.getProperty(PATH).getString());
            data.setPermissions(drive.getProperty(PERMISSIONS).getString());
            data.setViews(drive.getProperty(VIEWS).getString());
            data.setIcon(drive.getProperty(ICON).getString());
            data.setViewPreferences(Boolean.parseBoolean(drive.getProperty(VIEW_REFERENCES).getString()));
            data.setViewNonDocument(Boolean.parseBoolean(drive.getProperty(VIEW_NON_DOCUMENT).getString()));
            data.setViewSideBar(Boolean.parseBoolean(drive.getProperty(VIEW_SIDEBAR).getString()));
            data.setShowHiddenNode(Boolean.parseBoolean(drive.getProperty(SHOW_HIDDEN_NODE).getString()));
            data.setAllowCreateFolders(drive.getProperty(ALLOW_CREATE_FOLDER).getString());
            data.setAllowNodeTypesOnTree(drive.getProperty(ALLOW_NODETYPES_ON_TREE).getString());
            driveList.add(data);
        }
        this.drivesCache_.put((Serializable)((Object)ALL_DRIVES_CACHED), driveList);
        session.logout();
        return driveList;
    }

    @Override
    public DriveData getDriveByName(String name, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        if (driveHome.hasNode(name)) {
            Node drive = driveHome.getNode(name);
            DriveData data = new DriveData();
            data.setName(drive.getName());
            data.setWorkspace(drive.getProperty(WORKSPACE).getString());
            data.setHomePath(drive.getProperty(PATH).getString());
            data.setPermissions(drive.getProperty(PERMISSIONS).getString());
            data.setViews(drive.getProperty(VIEWS).getString());
            data.setIcon(drive.getProperty(ICON).getString());
            data.setViewPreferences(Boolean.parseBoolean(drive.getProperty(VIEW_REFERENCES).getString()));
            data.setViewNonDocument(Boolean.parseBoolean(drive.getProperty(VIEW_NON_DOCUMENT).getString()));
            data.setViewSideBar(Boolean.parseBoolean(drive.getProperty(VIEW_SIDEBAR).getString()));
            data.setShowHiddenNode(Boolean.parseBoolean(drive.getProperty(SHOW_HIDDEN_NODE).getString()));
            data.setAllowCreateFolders(drive.getProperty(ALLOW_CREATE_FOLDER).getString());
            try {
                data.setAllowNodeTypesOnTree(drive.getProperty(ALLOW_NODETYPES_ON_TREE).getString());
            }
            catch (PathNotFoundException e) {
                data.setAllowNodeTypesOnTree("*");
            }
            session.logout();
            return data;
        }
        session.logout();
        return null;
    }

    @Override
    public void addDrive(String name, String workspace, String permissions, String homePath, String views, String icon, boolean viewReferences, boolean viewNonDocument, boolean viewSideBar, boolean showHiddenNode, String repository, String allowCreateFolder, String allowNodeTypesOnTree) throws Exception {
        Session session = this.getSession(repository);
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        if (!driveHome.hasNode(name)) {
            Node driveNode = driveHome.addNode(name, "exo:drive");
            driveNode.setProperty(WORKSPACE, workspace);
            driveNode.setProperty(PERMISSIONS, permissions);
            driveNode.setProperty(PATH, homePath);
            driveNode.setProperty(VIEWS, views);
            driveNode.setProperty(ICON, icon);
            driveNode.setProperty(VIEW_REFERENCES, Boolean.toString(viewReferences));
            driveNode.setProperty(VIEW_NON_DOCUMENT, Boolean.toString(viewNonDocument));
            driveNode.setProperty(VIEW_SIDEBAR, Boolean.toString(viewSideBar));
            driveNode.setProperty(ALLOW_CREATE_FOLDER, allowCreateFolder);
            driveNode.setProperty(SHOW_HIDDEN_NODE, Boolean.toString(showHiddenNode));
            driveNode.setProperty(ALLOW_NODETYPES_ON_TREE, allowNodeTypesOnTree);
            driveHome.save();
        } else {
            Node driveNode = driveHome.getNode(name);
            driveNode.setProperty(WORKSPACE, workspace);
            driveNode.setProperty(PERMISSIONS, permissions);
            driveNode.setProperty(PATH, homePath);
            driveNode.setProperty(VIEWS, views);
            driveNode.setProperty(ICON, icon);
            driveNode.setProperty(VIEW_REFERENCES, Boolean.toString(viewReferences));
            driveNode.setProperty(VIEW_NON_DOCUMENT, Boolean.toString(viewNonDocument));
            driveNode.setProperty(VIEW_SIDEBAR, Boolean.toString(viewSideBar));
            driveNode.setProperty(ALLOW_CREATE_FOLDER, allowCreateFolder);
            driveNode.setProperty(SHOW_HIDDEN_NODE, Boolean.toString(showHiddenNode));
            driveNode.setProperty(ALLOW_NODETYPES_ON_TREE, allowNodeTypesOnTree);
            driveNode.save();
        }
        this.drivesCache_.clearCache();
        session.save();
        session.logout();
    }

    @Override
    public List<DriveData> getAllDriveByPermission(String permission, String repository) throws Exception {
        ArrayList<DriveData> driveByPermission = new ArrayList<DriveData>();
        try {
            List<DriveData> driveList = this.getAllDrives(repository);
            for (DriveData drive : driveList) {
                if (!drive.hasPermission(drive.getAllPermissions(), permission)) continue;
                driveByPermission.add(drive);
            }
            if (this.getDriveByName("Private", repository) != null) {
                driveByPermission.add(this.getDriveByName("Private", repository));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        return driveByPermission;
    }

    @Override
    public void removeDrive(String driveName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        if (driveHome.hasNode(driveName)) {
            driveHome.getNode(driveName).remove();
            driveHome.save();
        }
        this.drivesCache_.clearCache();
        session.logout();
    }

    private Session getSession(String repository) throws Exception {
        ManageableRepository manaRepository = this.repositoryService_.getRepository(repository);
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig(repository);
        return manaRepository.getSystemSession(dmsRepoConfig.getSystemWorkspace());
    }

    @Override
    public boolean isUsedView(String viewName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node driveHome = (Node)session.getItem(this.baseDrivePath_);
        NodeIterator iter = driveHome.getNodes();
        while (iter.hasNext()) {
            String[] views;
            Node drive = iter.nextNode();
            for (String view : views = drive.getProperty("exo:views").getString().split(",")) {
                if (!viewName.equals(view)) continue;
                session.logout();
                return true;
            }
        }
        session.logout();
        return false;
    }

    @Override
    public List<DriveData> getDriveByUserRoles(String repository, String userId, List<String> userRoles) throws Exception {
        Object drivesByRoles = this.drivesCache_.get((Serializable)((Object)(userId + ALL_DRIVES_CACHED_BY_ROLES)));
        if (drivesByRoles != null) {
            return (List)drivesByRoles;
        }
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        if (userId != null) {
            block0: for (DriveData drive : this.getAllDrives(repository)) {
                String[] allPermission = drive.getAllPermissions();
                boolean flag = false;
                block1: for (String permission : allPermission) {
                    if (permission.equalsIgnoreCase("${userId}")) {
                        if (!driveList.contains(drive)) {
                            driveList.add(drive);
                        }
                        flag = true;
                        continue block0;
                    }
                    if (permission.equalsIgnoreCase("*")) {
                        if (!driveList.contains(drive)) {
                            driveList.add(drive);
                        }
                        flag = true;
                        continue block0;
                    }
                    if (flag) continue;
                    for (String rolse : userRoles) {
                        if (!drive.hasPermission(allPermission, rolse)) continue;
                        if (driveList.contains(drive)) continue block1;
                        driveList.add(drive);
                        continue block1;
                    }
                }
            }
        } else {
            block3: for (DriveData drive : this.getAllDrives(repository)) {
                String[] allPermission;
                for (String permission : allPermission = drive.getAllPermissions()) {
                    if (!permission.equalsIgnoreCase("*")) continue;
                    driveList.add(drive);
                    continue block3;
                }
            }
        }
        Collections.sort(driveList);
        this.drivesCache_.put((Serializable)((Object)(userId + ALL_DRIVES_CACHED_BY_ROLES)), driveList);
        return driveList;
    }

    @Override
    public List<DriveData> getGroupDrives(String repository, String userId, List<String> userRoles, List<String> groups) throws Exception {
        Object drives = this.drivesCache_.get((Serializable)((Object)(userId + ALL_GROUP_CACHED_DRIVES)));
        if (drives != null) {
            return (List)drives;
        }
        ArrayList<DriveData> groupDrives = new ArrayList<DriveData>();
        String groupPath = this.nodeHierarchyCreator_.getJcrPath("groupsPath");
        block0: for (DriveData drive : this.getDriveByUserRoles(repository, userId, userRoles)) {
            if (drive.getHomePath().equals(groupPath) || !drive.getHomePath().startsWith(groupPath)) continue;
            for (String group : groups) {
                if (!drive.getHomePath().equals(groupPath + group)) continue;
                groupDrives.add(drive);
                break;
            }
            for (String permission : drive.getAllPermissions()) {
                String[] arrPer = permission.split(":/");
                if (!groups.contains("/" + arrPer[1]) || groupDrives.contains(drive)) continue;
                groupDrives.add(drive);
                continue block0;
            }
        }
        Collections.sort(groupDrives);
        this.drivesCache_.put((Serializable)((Object)(userId + ALL_GROUP_CACHED_DRIVES)), groupDrives);
        return groupDrives;
    }

    @Override
    public List<DriveData> getMainDrives(String repository, String userId, List<String> userRoles) throws Exception {
        Object drives = this.drivesCache_.get((Serializable)((Object)(userId + ALL_MAIN_CACHED_DRIVE)));
        if (drives != null) {
            return (List)drives;
        }
        ArrayList<DriveData> generalDrives = new ArrayList<DriveData>();
        String userPath = this.nodeHierarchyCreator_.getJcrPath("usersPath");
        String groupPath = this.nodeHierarchyCreator_.getJcrPath("groupsPath");
        for (DriveData drive : this.getDriveByUserRoles(repository, userId, userRoles)) {
            if ((drive.getHomePath().startsWith(userPath) || drive.getHomePath().startsWith(groupPath)) && !drive.getHomePath().equals(userPath) && !drive.getHomePath().equals(groupPath)) continue;
            generalDrives.add(drive);
        }
        Collections.sort(generalDrives);
        this.drivesCache_.put((Serializable)((Object)(userId + ALL_MAIN_CACHED_DRIVE)), generalDrives);
        return generalDrives;
    }

    @Override
    public List<DriveData> getPersonalDrives(String repository, String userId, List<String> userRoles) throws Exception {
        Object drives = this.drivesCache_.get((Serializable)((Object)(userId + ALL_PERSONAL_CACHED_DRIVE)));
        if (drives != null) {
            return (List)drives;
        }
        ArrayList<DriveData> personalDrives = new ArrayList<DriveData>();
        String userPath = this.nodeHierarchyCreator_.getJcrPath("usersPath");
        for (DriveData drive : this.getDriveByUserRoles(repository, userId, userRoles)) {
            if (drive.getHomePath().startsWith(userPath + "/${userId}/")) {
                personalDrives.add(drive);
                continue;
            }
            if (!drive.getHomePath().startsWith(userPath + "/" + userId + "/")) continue;
            personalDrives.add(drive);
        }
        Collections.sort(personalDrives);
        this.drivesCache_.put((Serializable)((Object)(userId + ALL_PERSONAL_CACHED_DRIVE)), personalDrives);
        return personalDrives;
    }
}

