/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarCategory;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.CalendarUpdateEventListener;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.RssData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarEventListener;
import org.exoplatform.calendar.service.impl.CsvImportExport;
import org.exoplatform.calendar.service.impl.ICalendarImportExport;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarServiceImpl
implements CalendarService,
Startable {
    private ResourceBundle rb_;
    private ResourceBundleService rbs_;
    private JCRDataStorage storage_;
    private Map<String, CalendarImportExport> calendarImportExport_ = new LinkedHashMap<String, CalendarImportExport>();
    protected List<CalendarUpdateEventListener> listeners_ = new ArrayList<CalendarUpdateEventListener>(3);
    protected List<CalendarEventListener> eventListeners_ = new ArrayList<CalendarEventListener>(3);

    public CalendarServiceImpl(InitParams params, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService reposervice, ResourceBundleService rbs) throws Exception {
        this.storage_ = new JCRDataStorage(nodeHierarchyCreator, reposervice);
        this.calendarImportExport_.put(CalendarService.ICALENDAR, new ICalendarImportExport(this.storage_));
        this.calendarImportExport_.put(CalendarService.EXPORTEDCSV, new CsvImportExport(this.storage_));
        this.rbs_ = rbs;
        ExoProperties props = params.getPropertiesParam("eventNumber.info").getProperties();
        String eventNumber = props.getProperty("eventNumber");
        Utils.EVENT_NUMBER = Integer.parseInt(eventNumber);
    }

    @Override
    public List<CalendarCategory> getCategories(String username) throws Exception {
        return this.storage_.getCategories(username);
    }

    @Override
    public List<GroupCalendarData> getCalendarCategories(String username, boolean isShowAll) throws Exception {
        return this.storage_.getCalendarCategories(username, isShowAll);
    }

    @Override
    public CalendarCategory getCalendarCategory(String username, String calendarCategoryId) throws Exception {
        return this.storage_.getCalendarCategory(username, calendarCategoryId);
    }

    @Override
    public void saveCalendarCategory(String username, CalendarCategory calendarCategory, boolean isNew) throws Exception {
        this.storage_.saveCalendarCategory(username, calendarCategory, isNew);
    }

    @Override
    public CalendarCategory removeCalendarCategory(String username, String calendarCategoryId) throws Exception {
        return this.storage_.removeCalendarCategory(username, calendarCategoryId);
    }

    @Override
    public Calendar getUserCalendar(String username, String calendarId) throws Exception {
        return this.storage_.getUserCalendar(username, calendarId);
    }

    @Override
    public List<Calendar> getUserCalendars(String username, boolean isShowAll) throws Exception {
        try {
            this.rb_ = this.rbs_.getResourceBundle("locale.portlet.calendar.CalendarPortlet", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return this.storage_.getUserCalendars(username, isShowAll);
    }

    @Override
    public List<Calendar> getUserCalendarsByCategory(String username, String calendarCategoryId) throws Exception {
        return this.storage_.getUserCalendarsByCategory(username, calendarCategoryId);
    }

    @Override
    public void saveUserCalendar(String username, Calendar calendar, boolean isNew) throws Exception {
        this.storage_.saveUserCalendar(username, calendar, isNew);
    }

    @Override
    public Calendar removeUserCalendar(String username, String calendarId) throws Exception {
        return this.storage_.removeUserCalendar(username, calendarId);
    }

    @Override
    public Calendar getGroupCalendar(String calendarId) throws Exception {
        return this.storage_.getGroupCalendar(calendarId);
    }

    @Override
    public List<GroupCalendarData> getGroupCalendars(String[] groupIds, boolean isShowAll, String username) throws Exception {
        return this.storage_.getGroupCalendars(groupIds, isShowAll, username);
    }

    @Override
    public void savePublicCalendar(Calendar calendar, boolean isNew, String username) throws Exception {
        this.storage_.savePublicCalendar(calendar, isNew, username);
    }

    @Override
    public void savePublicCalendar(Calendar calendar, boolean isNew) throws Exception {
        this.storage_.savePublicCalendar(calendar, isNew, null);
    }

    @Override
    public Calendar removePublicCalendar(String calendarId) throws Exception {
        return this.storage_.removeGroupCalendar(calendarId);
    }

    @Override
    public List<EventCategory> getEventCategories(String username) throws Exception {
        return this.storage_.getEventCategories(username);
    }

    @Override
    public void saveEventCategory(String username, EventCategory eventCategory, boolean isNew) throws Exception {
        EventCategory ev = this.getEventCategoryByName(username, eventCategory.getName());
        if (ev != null && (isNew || !ev.getId().equals(eventCategory.getId()))) {
            throw new ItemExistsException();
        }
        this.storage_.saveEventCategory(username, eventCategory, isNew);
    }

    public void saveEventCategory(String username, EventCategory eventCategory, String[] values, boolean isNew) throws Exception {
        this.saveEventCategory(username, eventCategory, isNew);
    }

    @Override
    public void removeEventCategory(String username, String eventCategoryName) throws Exception {
        this.storage_.removeEventCategory(username, eventCategoryName);
    }

    @Override
    public List<CalendarEvent> getUserEventByCalendar(String username, List<String> calendarIds) throws Exception {
        return this.storage_.getUserEventByCalendar(username, calendarIds);
    }

    @Override
    public List<CalendarEvent> getUserEvents(String username, EventQuery eventQuery) throws Exception {
        return this.storage_.getUserEvents(username, eventQuery);
    }

    @Override
    public CalendarEvent getEvent(String username, String eventId) throws Exception {
        return this.storage_.getEvent(username, eventId);
    }

    @Override
    public void saveUserEvent(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.saveUserEvent(username, calendarId, event, isNew);
    }

    @Override
    public CalendarEvent removeUserEvent(String username, String calendarId, String eventId) throws Exception {
        return this.storage_.removeUserEvent(username, calendarId, eventId);
    }

    @Override
    public CalendarEvent getGroupEvent(String calendarId, String eventId) throws Exception {
        return this.storage_.getGroupEvent(calendarId, eventId);
    }

    @Override
    public List<CalendarEvent> getGroupEventByCalendar(List<String> calendarIds) throws Exception {
        return this.storage_.getGroupEventByCalendar(calendarIds);
    }

    @Override
    public List<CalendarEvent> getPublicEvents(EventQuery eventQuery) throws Exception {
        return this.storage_.getPublicEvents(eventQuery);
    }

    @Override
    public void savePublicEvent(String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.savePublicEvent(calendarId, event, isNew);
        for (CalendarEventListener cel : this.eventListeners_) {
            if (isNew) {
                cel.savePublicEvent(event, calendarId);
                continue;
            }
            cel.updatePublicEvent(event, calendarId);
        }
    }

    @Override
    public CalendarEvent removePublicEvent(String calendarId, String eventId) throws Exception {
        return this.storage_.removePublicEvent(calendarId, eventId);
    }

    @Override
    public CalendarImportExport getCalendarImportExports(String type) {
        return this.calendarImportExport_.get(type);
    }

    @Override
    public String[] getExportImportType() throws Exception {
        return this.calendarImportExport_.keySet().toArray(new String[0]);
    }

    @Override
    public void saveCalendarSetting(String username, CalendarSetting setting) throws Exception {
        this.storage_.saveCalendarSetting(username, setting);
    }

    @Override
    public CalendarSetting getCalendarSetting(String username) throws Exception {
        return this.storage_.getCalendarSetting(username);
    }

    @Override
    public int generateRss(String username, LinkedHashMap<String, Calendar> calendars, RssData rssData) throws Exception {
        return this.storage_.generateRss(username, calendars, rssData, this.calendarImportExport_.get(CalendarService.ICALENDAR));
    }

    @Override
    public int generateCalDav(String username, LinkedHashMap<String, Calendar> calendars, RssData rssData) throws Exception {
        return this.storage_.generateCalDav(username, calendars, rssData, this.calendarImportExport_.get(CalendarService.ICALENDAR));
    }

    @Override
    public List<FeedData> getFeeds(String username) throws Exception {
        return this.storage_.getFeeds(username);
    }

    @Override
    public Node getRssHome(String username) throws Exception {
        return this.storage_.getRssHome(username);
    }

    @Override
    public EventPageList searchEvent(String username, EventQuery query, String[] publicCalendarIds) throws Exception {
        return this.storage_.searchEvent(username, query, publicCalendarIds);
    }

    @Override
    public EventCategory getEventCategory(String username, String eventCategoryId) throws Exception {
        return this.storage_.getEventCategory(username, eventCategoryId);
    }

    @Override
    public Map<Integer, String> searchHightLightEvent(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.storage_.searchHightLightEvent(username, eventQuery, publicCalendarIds);
    }

    @Override
    public void shareCalendar(String username, String calendarId, List<String> receiverUsers) throws Exception {
        this.storage_.shareCalendar(username, calendarId, receiverUsers);
    }

    @Override
    public GroupCalendarData getSharedCalendars(String username, boolean isShowAll) throws Exception {
        return this.storage_.getSharedCalendars(username, isShowAll);
    }

    @Override
    public List<CalendarEvent> getEvents(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        return this.storage_.getEvents(username, eventQuery, publicCalendarIds);
    }

    @Override
    public void removeSharedCalendar(String username, String calendarId) throws Exception {
        this.storage_.removeSharedCalendar(username, calendarId);
    }

    @Override
    public void saveEventToSharedCalendar(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        this.storage_.saveEventToSharedCalendar(username, calendarId, event, isNew);
    }

    @Override
    public Map<String, String> checkFreeBusy(EventQuery eventQuery) throws Exception {
        return this.storage_.checkFreeBusy(eventQuery);
    }

    @Override
    public void saveSharedCalendar(String username, Calendar calendar) throws Exception {
        this.storage_.saveSharedCalendar(username, calendar);
    }

    @Override
    public void removeSharedEvent(String username, String calendarId, String eventId) throws Exception {
        this.storage_.removeSharedEvent(username, calendarId, eventId);
    }

    @Override
    public void moveEvent(String fromCalendar, String toCalendar, String fromType, String toType, List<CalendarEvent> calEvents, String username) throws Exception {
        this.storage_.moveEvent(fromCalendar, toCalendar, fromType, toType, calEvents, username);
        if (fromType.equalsIgnoreCase(toType) && toType.equalsIgnoreCase(String.valueOf(2)) && fromCalendar.equalsIgnoreCase(toCalendar)) {
            for (CalendarEventListener cel : this.eventListeners_) {
                for (CalendarEvent event : calEvents) {
                    cel.updatePublicEvent(event, toCalendar);
                }
            }
        }
    }

    @Override
    public void confirmInvitation(String fromUserId, String toUserId, int calType, String calendarId, String eventId, int answer) throws Exception {
        this.storage_.confirmInvitation(fromUserId, toUserId, calType, calendarId, eventId, answer);
    }

    @Override
    public void confirmInvitation(String fromUserId, String confirmingEmail, String confirmingUser, int calType, String calendarId, String eventId, int answer) throws Exception {
        this.storage_.confirmInvitation(fromUserId, confirmingEmail, confirmingUser, calType, calendarId, eventId, answer);
    }

    public void start() {
        for (CalendarUpdateEventListener updateListener : this.listeners_) {
            updateListener.preUpdate();
        }
    }

    public void stop() {
    }

    @Override
    public synchronized void addListenerPlugin(CalendarUpdateEventListener listener) throws Exception {
        this.listeners_.add(listener);
    }

    @Override
    public void updateCalDav(String usename, String calendarId, CalendarImportExport imp) throws Exception {
        this.storage_.updateCalDav(usename, calendarId, imp);
    }

    @Override
    public void updateCalDav(String usename, String calendarId, CalendarImportExport imp, int number) throws Exception {
        this.storage_.updateCalDav(usename, calendarId, imp, number);
    }

    @Override
    public void updateRss(String usename, String calendarId, CalendarImportExport imp) throws Exception {
        this.storage_.updateRss(usename, calendarId, imp);
    }

    @Override
    public void updateRss(String usename, String calendarId, CalendarImportExport imp, int number) throws Exception {
        this.storage_.updateRss(usename, calendarId, imp, number);
    }

    @Override
    public int getTypeOfCalendar(String userName, String calendarId) throws Exception {
        return this.storage_.getTypeOfCalendar(userName, calendarId);
    }

    @Override
    public int generateCalDav(String username, List<String> calendarIds, RssData rssData) throws Exception {
        return this.storage_.generateCalDav(username, calendarIds, rssData, this.calendarImportExport_.get(CalendarService.ICALENDAR));
    }

    @Override
    public int generateRss(String username, List<String> calendarIds, RssData rssData) throws Exception {
        return this.storage_.generateRss(username, calendarIds, rssData, this.calendarImportExport_.get(CalendarService.ICALENDAR));
    }

    @Override
    public ResourceBundle getResourceBundle() throws Exception {
        return this.rb_;
    }

    @Override
    public EventCategory getEventCategoryByName(String username, String eventCategoryName) throws Exception {
        ResourceBundle rb = null;
        try {
            rb = this.rbs_.getResourceBundle("locale.portlet.calendar.CalendarPortlet", Locale.getDefault());
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        for (EventCategory ev : this.storage_.getEventCategories(username)) {
            if (ev.getName().equalsIgnoreCase(eventCategoryName)) {
                return ev;
            }
            if (rb == null) continue;
            try {
                if (!eventCategoryName.equalsIgnoreCase(rb.getString("UICalendarView.label." + ev.getId()))) continue;
                return ev;
            }
            catch (MissingResourceException e) {
            }
        }
        return null;
    }

    @Override
    public List<CalendarEvent> getSharedEventByCalendars(String username, List<String> calendarIds) throws Exception {
        return this.storage_.getSharedEventByCalendars(username, calendarIds);
    }

    @Override
    public void removeFeedData(String username, String title) {
        this.storage_.removeFeedData(username, title);
    }

    @Override
    public void initNewUser(String userName, CalendarSetting defaultCalendarSetting_) throws Exception {
        EventCategory eventCategory = new EventCategory();
        eventCategory.setDataInit(true);
        for (int id = 0; id < NewUserListener.defaultEventCategoryId.length; ++id) {
            eventCategory.setId(NewUserListener.defaultEventCategoryId[id]);
            eventCategory.setName(NewUserListener.defaultEventCategoryName[id]);
            this.saveEventCategory(userName, eventCategory, true);
        }
        CalendarCategory calCategory = new CalendarCategory();
        calCategory.setId("defaultCalendarCategoryId");
        calCategory.setName("defaultCalendarCategoryName");
        calCategory.setDataInit(true);
        this.saveCalendarCategory(userName, calCategory, true);
        Calendar cal = new Calendar();
        cal.setId(Utils.getDefaultCalendarId(userName));
        cal.setName("defaultCalendarName");
        cal.setCategoryId(calCategory.getId());
        cal.setDataInit(true);
        cal.setCalendarOwner(userName);
        if (defaultCalendarSetting_ != null) {
            if (defaultCalendarSetting_.getLocation() != null) {
                cal.setLocale(defaultCalendarSetting_.getLocation());
            }
            if (defaultCalendarSetting_.getTimeZone() != null) {
                cal.setTimeZone(defaultCalendarSetting_.getTimeZone());
            }
        }
        this.saveUserCalendar(userName, cal, true);
        if (defaultCalendarSetting_ != null) {
            this.saveCalendarSetting(userName, defaultCalendarSetting_);
        }
        OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        Object[] groupsOfUser = organizationService.getGroupHandler().findGroupsOfUser(userName).toArray();
        ArrayList<String> groups = new ArrayList<String>();
        for (Object object : groupsOfUser) {
            String groupId = ((Group)object).getId();
            groups.add(groupId);
        }
        this.storage_.autoShareCalendar(groups, userName);
    }

    @Override
    public void addEventListenerPlugin(CalendarEventListener listener) throws Exception {
        this.eventListeners_.add(listener);
    }

    @Override
    public void assignGroupTask(String taskId, String calendarId, String assignee) throws Exception {
        this.storage_.assignGroupTask(taskId, calendarId, assignee);
    }

    @Override
    public void setGroupTaskStatus(String taskId, String calendarId, String status) throws Exception {
        this.storage_.setGroupTaskStatus(taskId, calendarId, status);
    }
}

