/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MimeMessageParser {
    private static final Log logger = ExoLogger.getLogger((String)"cs.mail.service");

    public static Calendar getReceivedDate(Message msg) throws Exception {
        Calendar gc = GregorianCalendar.getInstance();
        Date date = msg.getReceivedDate();
        if (date != null) {
            gc.setTime(date);
        } else {
            gc.setTime(MimeMessageParser.getDateHeader(msg));
        }
        return gc;
    }

    private static Date getDateHeader(Message msg) throws MessagingException {
        String[] dateHeader;
        Date msgDate;
        String dateStr;
        Date today = new Date();
        String[] received = msg.getHeader("received");
        if (received != null) {
            for (int i = 0; i < received.length; ++i) {
                dateStr = null;
                try {
                    dateStr = MimeMessageParser.getDateString(received[i]);
                    if (dateStr != null && !(msgDate = MimeMessageParser.parseDate(dateStr)).after(today)) {
                        return msgDate;
                    }
                    continue;
                }
                catch (ParseException ex) {
                    // empty catch block
                }
            }
        }
        if ((dateHeader = msg.getHeader("date")) != null) {
            dateStr = dateHeader[0];
            try {
                msgDate = MimeMessageParser.parseDate(dateStr);
                if (!msgDate.after(today)) {
                    return msgDate;
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return today;
    }

    private static String getDateString(String text) {
        String[] daysInDate = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        int startIndex = -1;
        for (int i = 0; i < daysInDate.length && (startIndex = text.lastIndexOf(daysInDate[i])) == -1; ++i) {
        }
        if (startIndex == -1) {
            return null;
        }
        return text.substring(startIndex);
    }

    private static Date parseDate(String dateStr) throws ParseException {
        dateStr = dateStr.replaceAll("\r\n", "");
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yy HH:mm:ss Z", Locale.ENGLISH);
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
                return dateFormat.parse(dateStr);
            }
            catch (ParseException ex) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
                    return dateFormat.parse(dateStr);
                }
                catch (ParseException exx) {
                    try {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yy HH:mm:ss", Locale.ENGLISH);
                        return dateFormat.parse(dateStr.substring(0, dateStr.lastIndexOf(":") + 2));
                    }
                    catch (ParseException exxx) {
                        System.out.println(" [WARNING] Cannot parse date time from message: " + dateStr);
                        return null;
                    }
                }
            }
        }
    }

    public static long getPriority(Message message) throws MessagingException {
        MimeMessage msg = (MimeMessage)message;
        String xpriority = msg.getHeader("Importance", null);
        if (xpriority != null) {
            if ((xpriority = xpriority.toLowerCase()).indexOf("high") == 0) {
                return 1L;
            }
            if (xpriority.indexOf("low") == 0) {
                return 5L;
            }
            return 3L;
        }
        xpriority = msg.getHeader("X-Priority", null);
        if (xpriority != null) {
            if ((xpriority = xpriority.toLowerCase()).indexOf("1") == 0 || xpriority.indexOf("2") == 0) {
                return 1L;
            }
            if (xpriority.indexOf("4") == 0 || xpriority.indexOf("5") == 0) {
                return 5L;
            }
            return 3L;
        }
        return 3L;
    }

    public static String getMessageId(Message message) throws Exception {
        try {
            String[] msgIdHeaders = message.getHeader("Message-ID");
            if (msgIdHeaders != null && msgIdHeaders[0] != null) {
                return msgIdHeaders[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getMD5MsgId(Message msg) throws Exception {
        String key = "";
        long t1 = System.currentTimeMillis();
        Enumeration enu = msg.getAllHeaders();
        while (enu.hasMoreElements()) {
            Header header = (Header)enu.nextElement();
            key = key + header.getValue();
        }
        String md5 = MimeMessageParser.getMD5(key);
        long t2 = System.currentTimeMillis();
        logger.error((Object)("getMD5MsgId spending time : " + (t2 - t1) + "ms"));
        return md5;
    }

    public static String getMD5(String s) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(s.getBytes(), 0, s.length());
            return "" + new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"MD5 is not supported !!!");
            return s;
        }
    }

    public static String getInReplyToHeader(Message message) throws Exception {
        String[] inReplyToHeaders = message.getHeader("In-Reply-To");
        if (inReplyToHeaders != null && inReplyToHeaders[0] != null) {
            return inReplyToHeaders[0];
        }
        return "";
    }

    public static String[] getReferencesHeader(Message message) throws Exception {
        String[] references = message.getHeader("References");
        return references;
    }

    public static String[] getInvitationHeader(Message message) throws Exception {
        String[] exoInvitationHeaders = message.getHeader("X-Exo-Invitation");
        if (exoInvitationHeaders != null) {
            return exoInvitationHeaders;
        }
        return null;
    }

    public static boolean isSeenMessage(Message message) throws Exception {
        Flags.Flag[] sf = message.getFlags().getSystemFlags();
        for (int i = 0; i < sf.length; ++i) {
            if (sf[i] != Flags.Flag.SEEN) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnsweredMessage(Message message) throws Exception {
        Flags flags = message.getFlags();
        Flags.Flag[] sf = flags.getSystemFlags();
        for (int i = 0; i < sf.length; ++i) {
            if (sf[i] != Flags.Flag.ANSWERED) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistHeader(Message message, String header) throws Exception {
        String[] headers = message.getHeader(header);
        return headers != null;
    }

    public static boolean requestReturnReceipt(Message message) throws Exception {
        boolean requestReturnReceipt = false;
        if (!MimeMessageParser.isSeenMessage(message) && MimeMessageParser.isExistHeader(message, "Disposition-Notification-To")) {
            requestReturnReceipt = true;
        }
        return requestReturnReceipt;
    }
}

