/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.Hashtable;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.BaseUIActivityBuilder;
import org.exoplatform.social.webui.activity.UIActivityExtension;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

public class UIActivityFactory
extends BaseComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(UIActivityFactory.class);
    private Hashtable<String, BaseUIActivityBuilder> builders = new Hashtable();

    public UIActivityFactory() {
        UIExtensionManager extensionManager = (UIExtensionManager)PortalContainer.getInstance().getComponentInstanceOfType(UIExtensionManager.class);
        List extensions = extensionManager.getUIExtensions(BaseUIActivity.class.getName());
        for (UIExtension extension : extensions) {
            try {
                this.registerBuilder((UIActivityExtension)extension);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }

    public BaseUIActivity addChild(Activity activity, UIContainer parent) throws Exception {
        String type = activity.getType();
        if (type != null) {
            return this.buildActivity(activity, parent, type);
        }
        return this.buildActivity(activity, parent, "DEFAULT_ACTIVITY");
    }

    private BaseUIActivity buildActivity(Activity activity, UIContainer parent, String type) throws Exception {
        UIExtensionManager extensionManager = (UIExtensionManager)PortalContainer.getInstance().getComponentInstanceOfType(UIExtensionManager.class);
        UIExtension activityExtension = extensionManager.getUIExtension(BaseUIActivity.class.getName(), type);
        if (activityExtension == null) {
            activityExtension = extensionManager.getUIExtension(BaseUIActivity.class.getName(), "DEFAULT_ACTIVITY");
        }
        BaseUIActivity uiActivity = (BaseUIActivity)extensionManager.addUIExtension(activityExtension, null, (org.exoplatform.webui.core.UIContainer)parent);
        uiActivity.setId(uiActivity.getId() + "_" + ((Object)((Object)uiActivity)).hashCode());
        BaseUIActivityBuilder builder = this.getBuilder(type);
        return builder.populateData(uiActivity, activity);
    }

    private BaseUIActivityBuilder getBuilder(String activityType) {
        BaseUIActivityBuilder builder = this.builders.get(activityType);
        if (builder == null) {
            builder = this.builders.get("DEFAULT_ACTIVITY");
        }
        return builder;
    }

    private void registerBuilder(UIActivityExtension activityExtension) throws Exception {
        String activityType = activityExtension.getName();
        if (this.builders.contains(activityType)) {
            this.builders.remove(activityType);
        }
        Class<?> builderClass = Thread.currentThread().getContextClassLoader().loadClass(activityExtension.getActivityBuiderClass());
        this.builders.put(activityType, (BaseUIActivityBuilder)builderClass.newInstance());
    }
}

