/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import org.exoplatform.services.organization.Group;
import org.exoplatform.social.webui.UISocialGroupSelector;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInputInfo;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/space/UISpaceGroupBound.gtmpl", events={@EventConfig(listeners={SelectGroupActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIPopupWindow.class, id="SelectGroup", template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={ClosePopupActionListener.class}, name="ClosePopup")})})
public class UISpaceGroupBound
extends UIContainer {
    private final String USE_EXISTING_GROUP = "useExistingGroup";
    private final String POPUP_GROUP_BOUND = "UIPopupGroupBound";
    private final String SELECTED_GROUP = "groupId";

    public UISpaceGroupBound() throws Exception {
        UIFormCheckBoxInput uiUseExisting = new UIFormCheckBoxInput("useExistingGroup", null, (Object)false);
        uiUseExisting.setOnChange("ToggleUseGroup");
        this.addChild((UIComponent)uiUseExisting);
        UIFormInputInfo uiFormInputInfo = new UIFormInputInfo("groupId", null, null);
        this.addChild((UIComponent)uiFormInputInfo);
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, "SelectGroup", "UIPopupGroupBound");
        uiPopup.setWindowSize(550, 0);
        this.addChild((UIComponent)uiPopup);
    }

    public String getSelectedGroup() {
        UIFormCheckBoxInput uiCheckBox = (UIFormCheckBoxInput)this.getChild(UIFormCheckBoxInput.class);
        if (uiCheckBox.isChecked()) {
            UIFormInputInfo uiInfo = (UIFormInputInfo)this.getChild(UIFormInputInfo.class);
            return (String)uiInfo.getValue();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClosePopupActionListener
    extends EventListener<UIPopupWindow> {
        public void execute(Event<UIPopupWindow> event) throws Exception {
            UIPopupWindow uiPopup = (UIPopupWindow)event.getSource();
            UISpaceGroupBound uiGroupBound = (UISpaceGroupBound)uiPopup.getAncestorOfType(UISpaceGroupBound.class);
            UISocialGroupSelector uiGroupSelector = (UISocialGroupSelector)uiPopup.getUIComponent();
            Group group = uiGroupSelector.getCurrentGroup();
            if (group == null) {
                UIFormCheckBoxInput uiUseExisting = (UIFormCheckBoxInput)uiGroupBound.getChild(UIFormCheckBoxInput.class);
                uiUseExisting.setChecked(false);
            } else {
                UIFormInputInfo uiSelected = (UIFormInputInfo)uiGroupBound.getChild(UIFormInputInfo.class);
                uiSelected.setValue((Object)group.getId());
            }
            uiPopup.setShow(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectGroupActionListener
    extends EventListener<UISocialGroupSelector> {
        public void execute(Event<UISocialGroupSelector> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            String groupId = context.getRequestParameter("objectId");
            UISocialGroupSelector uiGroupSelector = (UISocialGroupSelector)((Object)event.getSource());
            UISpaceGroupBound uiGroupBound = (UISpaceGroupBound)uiGroupSelector.getAncestorOfType(UISpaceGroupBound.class);
            UIFormInputInfo uiFormInputInfo = (UIFormInputInfo)uiGroupBound.getChild(UIFormInputInfo.class);
            uiFormInputInfo.setValue((Object)groupId);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiGroupBound);
        }
    }
}

