/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.relationship.model.Relationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipStorage {
    private static final Log LOG = ExoLogger.getLogger(RelationshipStorage.class);
    private IdentityManager identityManager;
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    public static final String RELATION_NODETYPE = "exo:relationship".intern();
    public static final String PROPERTY_ISSYMETRIC = "exo:isSymetric".intern();
    public static final String PROPERTY_STATUS = "exo:status".intern();
    public static final String PROPERTY_NAME = "exo:name".intern();
    public static final String PROPERTY_INITIATOR = "exo:initiator".intern();
    public static final String PROPERTY_NODETYPE = "exo:relationshipProperty".intern();
    public static final String RELATION_SENDER = "exo:identity1Id".intern();
    public static final String RELATION_RECEIVER = "exo:identity2Id".intern();
    public static final String REFERENCEABLE_TYPE = "mix:referenceable";

    public RelationshipStorage(SocialDataLocation dataLocation, IdentityManager identityManager) {
        this.dataLocation = dataLocation;
        this.identityManager = identityManager;
        this.sessionManager = dataLocation.getSessionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRelationship(Relationship relationship) throws Exception {
        Session session = this.sessionManager.openSession();
        Node relationshipNode = null;
        try {
            Node relationshipHomeNode = this.getRelationshipServiceHome(session);
            if (relationship.getId() == null) {
                relationshipNode = relationshipHomeNode.addNode(RELATION_NODETYPE, RELATION_NODETYPE);
                relationshipNode.addMixin(REFERENCEABLE_TYPE);
            } else {
                relationshipNode = session.getNodeByUUID(relationship.getId());
            }
            Node id1Node = session.getNodeByUUID(relationship.getSender().getId());
            Node id2Node = session.getNodeByUUID(relationship.getReceiver().getId());
            relationshipNode.setProperty(RELATION_SENDER, id1Node);
            relationshipNode.setProperty(RELATION_RECEIVER, id2Node);
            relationshipNode.setProperty(PROPERTY_STATUS, relationship.getStatus().toString());
            this.updateProperties(relationship, relationshipNode, session);
            if (relationship.getId() == null) {
                relationshipHomeNode.save();
                relationship.setId(relationshipNode.getUUID());
            } else {
                relationshipNode.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        this.loadProperties(relationship, relationshipNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelationship(Relationship relationship) {
        Session session = this.sessionManager.openSession();
        try {
            Node relationshipHomeNode = this.getRelationshipServiceHome(session);
            Node relationshipNode = session.getNodeByUUID(relationship.getId());
            relationshipNode.remove();
            relationshipHomeNode.save();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Relationship getRelationship(String uuid) throws Exception {
        Node relationshipNode;
        Session session = this.sessionManager.openSession();
        try {
            relationshipNode = session.getNodeByUUID(uuid);
        }
        catch (ItemNotFoundException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            Relationship relationship = null;
            return relationship;
        }
        finally {
            this.sessionManager.closeSession();
        }
        Relationship relationship = new Relationship(relationshipNode.getUUID());
        Node idNode = relationshipNode.getProperty(RELATION_SENDER).getNode();
        Identity id = this.identityManager.getIdentity(idNode.getUUID());
        relationship.setSender(id);
        idNode = relationshipNode.getProperty(RELATION_RECEIVER).getNode();
        id = this.identityManager.getIdentity(idNode.getUUID());
        relationship.setReceiver(id);
        relationship.setStatus(Relationship.Type.valueOf(relationshipNode.getProperty(PROPERTY_STATUS).getString()));
        this.loadProperties(relationship, relationshipNode);
        return relationship;
    }

    public List<Relationship> getRelationshipByIdentity(Identity identity) throws Exception {
        if (identity.getId() == null) {
            return null;
        }
        return this.getRelationshipByIdentityId(identity.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Relationship> getRelationshipByIdentityId(String identityId) throws Exception {
        Session session = this.sessionManager.openSession();
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        PropertyIterator refNodes = null;
        try {
            if (identityId == null) {
                List<Relationship> list = null;
                return list;
            }
            Node identityNode = session.getNodeByUUID(identityId);
            refNodes = identityNode.getReferences();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            List<Relationship> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
        while (refNodes.hasNext()) {
            Property property = (Property)refNodes.next();
            Node node = property.getParent();
            if (!node.isNodeType(RELATION_NODETYPE)) continue;
            results.add(this.getRelationship(node.getUUID()));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Identity> getRelationshipIdentitiesByIdentity(Identity identity) throws Exception {
        Session session = this.sessionManager.openSession();
        ArrayList<Identity> results = new ArrayList<Identity>();
        PropertyIterator refNodes = null;
        try {
            if (identity.getId() == null) {
                List<Identity> list = null;
                return list;
            }
            Node identityNode = session.getNodeByUUID(identity.getId());
            refNodes = identityNode.getReferences();
        }
        catch (Exception e) {
            List<Identity> list = null;
            return list;
        }
        finally {
            this.sessionManager.closeSession();
        }
        while (refNodes.hasNext()) {
            Node relationshipNode;
            Property property = (Property)refNodes.next();
            Node node = property.getParent();
            if (!node.isNodeType(RELATION_NODETYPE)) continue;
            try {
                relationshipNode = session.getNodeByUUID(node.getUUID());
            }
            catch (ItemNotFoundException e) {
                continue;
            }
            Node idNode = relationshipNode.getProperty(RELATION_SENDER).getNode();
            String sId = idNode.getUUID();
            if (!sId.equals(identity.getId())) {
                results.add(this.identityManager.getIdentity(idNode.getUUID()));
                continue;
            }
            idNode = relationshipNode.getProperty(RELATION_RECEIVER).getNode();
            results.add(this.identityManager.getIdentity(idNode.getUUID()));
        }
        return results;
    }

    private Node getRelationshipServiceHome(Session session) throws Exception {
        String path = this.dataLocation.getSocialRelationshipHome();
        return session.getRootNode().getNode(path);
    }

    private void loadProperties(Relationship relationship, Node relationshipNode) throws Exception {
        NodeIterator nodes = relationshipNode.getNodes(PROPERTY_NODETYPE);
        ArrayList<org.exoplatform.social.core.relationship.model.Property> props = new ArrayList<org.exoplatform.social.core.relationship.model.Property>();
        while (nodes.hasNext()) {
            Node node = (Node)nodes.next();
            org.exoplatform.social.core.relationship.model.Property property = new org.exoplatform.social.core.relationship.model.Property();
            property.setId(node.getUUID());
            property.setName(node.getProperty(PROPERTY_NAME).getString());
            property.setSymetric(node.getProperty(PROPERTY_ISSYMETRIC).getBoolean());
            property.setStatus(Relationship.Type.valueOf(node.getProperty(PROPERTY_STATUS).getString()));
            if (node.hasProperty(PROPERTY_INITIATOR)) {
                Node idNode = node.getProperty(PROPERTY_INITIATOR).getNode();
                Identity id = this.identityManager.getIdentity(idNode.getUUID());
                property.setInitiator(id);
            }
            props.add(property);
        }
        relationship.setProperties(props);
    }

    private void updateProperties(Relationship relationship, Node relationshipNode, Session session) throws Exception {
        List<org.exoplatform.social.core.relationship.model.Property> properties = relationship.getProperties();
        NodeIterator oldNodes = relationshipNode.getNodes(PROPERTY_NODETYPE);
        while (oldNodes.hasNext()) {
            Node node = (Node)oldNodes.next();
            String uuid = node.getUUID();
            Boolean toRemove = true;
            for (org.exoplatform.social.core.relationship.model.Property property : properties) {
                if (!uuid.equals(property.getId())) continue;
                toRemove = false;
                break;
            }
            if (!toRemove.booleanValue()) continue;
            node.remove();
        }
        for (org.exoplatform.social.core.relationship.model.Property property : properties) {
            Node propertyNode;
            if (property.getId() == null) {
                propertyNode = relationshipNode.addNode(PROPERTY_NODETYPE, PROPERTY_NODETYPE);
                propertyNode.addMixin(REFERENCEABLE_TYPE);
            } else {
                propertyNode = session.getNodeByUUID(relationship.getId());
            }
            propertyNode.setProperty(PROPERTY_NAME, property.getName());
            propertyNode.setProperty(PROPERTY_ISSYMETRIC, property.isSymetric());
            propertyNode.setProperty(PROPERTY_STATUS, property.getStatus().toString());
            if (property.getInitiator() == null) continue;
            Node initiatorNode = session.getNodeByUUID(property.getInitiator().getId());
            propertyNode.setProperty(PROPERTY_INITIATOR, initiatorNode);
        }
    }
}

